FUNCTION vu(
	text/CHAR/
	indent/INT,1,3/
	width/REAL,1/
	height/REAL,1/
	line/REAL,1,0.015/
	csize/REAL,1,.5/
	font/CHAR,OPTIONAL/
	)

#	vu graphs with Hershey fonts
#	V 1.3 of 81/11/20

INCLUDE(graphics,device)
STATIC(real dx,dy; integer idev,nsize; POINTER pfont)
QUERY(fin(dx,dy),dev(idev))
if(MISSING(width)) {
	if(idev!=AED512) dx=amin1(dx,7.0)*.98
	}
else {
	dx = amin1(width,.98*dx)
	if( dx < width ) WARNING(Could not fit specified width)
	}
if(MISSING(height)) {
	if(idev!=AED512) dy=amin1(dy,7.0)*.98
	}
else {
	dy = amin1(height,.98*dy)
	if( dy < height ) WARNING(Could not fit specified height)
	}
nsize=LENGTH(csize)
if(MISSING(csize)) { #choose legal sizes
	if(!(MISSING(font) & (idev==STARE | idev==PRISM))) nsize=0	# assume continuous size
	}
else call sort(csize,LENGTH(csize))
if(MISSING(font))pfont=NULL; else pfont=font
call beginz
call vudraw(text,LENGTH(text),dx,dy,line,indent,csize,nsize,pfont)
END
