# data used - none                                                ex6   ======
# subs,fcts used - qlogis,qcauc
# test of point, line and axis transforms
subroutine ex6
INCLUDE(graphics)
external qlogis,qcauc
real p(100)
real x(2),y(2)
integer bottom,left,top,right,tick
logical axis,labels
real table(7)
equivalence(y(1),ya),(y(2),yb),(x(1),xa),(x(2),xb)
data table/.05,.01,.1,.1,.9,.01,.95/
data axis,labels/TRUE,TRUE/
data bottom,left,top,right/1,2,3,4/,tick/0/
data xa,xb,ya,yb/-5.,5.,-5.,5./
do i = 1,100
	p(i) = float(i)*.01-.005
call beginz
call mtextz(top,4.,TSTRING(EX6  - Probability Plot))
call srngez(x,y,2)
SPECIFY( las(2) )
call titlez(TSTRING(Theoretical Q-Q Plot),TSTRING(Logistic Distribution),TSTRING(Cauchy Distribution))
# label opposite sides with probabilities
call faxisz(top,table,7,qlogis,axis,labels)
call faxisz(right,table,7,qcauc,axis,labels)
call lintfz(p,p,100,3,qlogis,qcauc)
call pnttfz(p,p,100,3,qlogis,qcauc)
return
end
# qcauc
function qcauc(p)
pp = 3.14159*(p-.5)
qcauc = sin(pp)/cos(pp)
return
end
# qlogis
function qlogis(p)
pp = amax1(amin1(p,.9999),0.0001)
q = -alog(1./pp-1.)
qlogis = q*0.5513
return
end
