ROUTINE(hhcntz,		count the number of observations in each class)
# if an obs. falls on a class break, it goes to class on left
# assumes sorted break points
subroutine hhcntz(z,n,nbreak,cbreak,class,idens)
real cbreak(nbreak),z(n),class(*)
logical idens
if(n<=0) return
nclass = nbreak-1
do i = 1,nclass
	class(i) = 0.0
do i = 1,n {	# if obs. out of bounds, throw it away
	if(z(i)<=cbreak(1)) next
	for(j = 2; j <= nbreak; j = j+1) if(z(i)<=cbreak(j)) break
	if(j<=nbreak) class(j-1) = class(j-1)+1.
	}
if (idens) {	# change count into density if requested
	sumw=cbreak(nbreak)-cbreak(1)
	sumc = 0.
	do i = 1,nclass 
		sumc = sumc+class(i)
	suma = 0.
	do i = 1,nclass {
		class(i) = (class(i)/sumc)/((cbreak(i+1)-cbreak(i))/sumw)
		suma = suma+class(i)
		}
	do i = 1,nclass
		class(i) = class(i)/suma
	}
return
end
