ROUTINE(plot1,		high-level controlled plotting routine)
subroutine plot1(x,y,n,ttl,sub,xlab,ylab,ctrl,text)
real x(n),y(n),rparms(12)
CHARACTER(ttl,*); CHARACTER(sub,*); CHARACTER(xlab,*)
CHARACTER(ylab,*); CHARACTER(ctrl,*)
POINTER text(n)
common/cpl1/tldash,tldot,nskbox
common/cruntt/locrtt,oline
CHARACTER(irtt,100)
common/crunt2/irtt
integer flags(12),parms(12)
call plot2(ctrl,parms,rparms,flags)
call plot3(x,y,n,ttl,sub,xlab,ylab,text,parms,rparms,flags)
return
end


define(`UNDEF',-1e10)
subroutine plot2(ctrl,parms,rparms,flags)
integer parms(12),flags(12)
CHARACTER(ctrl,*)
real rparms(12)
INCLUDE(print)
CHARACTER(cmd,12); CHARACTER(carg,12)
CHARACTER(jgetch,1); CHARACTER(lastch,1); CHARACTER(c,1)
define(`NCMD',45)
CHARACTER(table,12,NCMD)
integer action(NCMD)
logical charg,plotd,streq,doinit
real rarg
SAVE(table,doinit)
data doinit/TRUE/
data action(1)/15/
data action(2)/15/
data action(3)/121/
data action(4)/121/
data action(5)/121/
data action(6)/122/
data action(7)/122/
data action(8)/122/
data action(9)/2/
data action(10)/2/
data action(11)/2/
data action(12)/108/
data action(13)/106/
data action(14)/107/
data action(15)/105/
data action(16)/107/
data action(17)/105/
data action(18)/107/
data action(19)/106/
data action(20)/19/
data action(21)/19/
data action(22)/19/
data action(23)/23/
data action(24)/4/
data action(25)/4/
data action(26)/118/
data action(27)/116/
data action(28)/118/
data action(29)/117/
data action(30)/120/
data action(31)/120/
data action(32)/101/
data action(33)/101/
data action(34)/101/
data action(35)/103/
data action(36)/103/
data action(37)/24/
data action(38)/12/
data action(39)/12/
data action(40)/12/
data action(41)/12/
data action(42)/14/
data action(43)/13/
data action(44)/14/
data action(45)/13/
if(doinit){
	doinit = FALSE
	table(1) = TSTRING(C)
	table(2) = TSTRING(CONSEC)
	table(3) = TSTRING(DASH)
	table(4) = TSTRING(DASHLINE)
	table(5) = TSTRING(DASHLINES)
	table(6) = TSTRING(DOT)
	table(7) = TSTRING(DOTLINE)
	table(8) = TSTRING(DOTLINES)
	table(9) = TSTRING(L)
	table(10) = TSTRING(LINE)
	table(11) = TSTRING(LINES)
	table(12) = TSTRING(LINLIN)
	table(13) = TSTRING(LINLOG)
	table(14) = TSTRING(LOG)
	table(15) = TSTRING(LOGLIN)
	table(16) = TSTRING(LOGLOG)
	table(17) = TSTRING(LOGX)
	table(18) = TSTRING(LOGXY)
	table(19) = TSTRING(LOGY)
	table(20) = TSTRING(M)
	table(21) = TSTRING(MARK)
	table(22) = TSTRING(MARKS)
	table(23) = TSTRING(MISS)
	table(24) = TSTRING(N)
	table(25) = TSTRING(NPLOT)
	table(26) = TSTRING(OLD)
	table(27) = TSTRING(OLDX)
	table(28) = TSTRING(OLDXY)
	table(29) = TSTRING(OLDY)
	table(30) = TSTRING(OVER)
	table(31) = TSTRING(OVERPLOT)
	table(32) = TSTRING(P)
	table(33) = TSTRING(POINT)
	table(34) = TSTRING(POINTS)
	table(35) = TSTRING(S)
	table(36) = TSTRING(SETUP)
	table(37) = TSTRING(SIZE)
	table(38) = TSTRING(T)
	table(39) = TSTRING(TC)
	table(40) = TSTRING(TEXT)
	table(41) = TSTRING(TEXTC)
	table(42) = TSTRING(TEXTL)
	table(43) = TSTRING(TEXTR)
	table(44) = TSTRING(TL)
	table(45) = TSTRING(TR)
	}
for(i=1; i<=12; i=i+1) {
	flags(i) = 0
	parms(i) = 0
	rparms(i) = 0.
	}
plotd = FALSE
ipos = 0
repeat {
	call cscan(ctrl,ipos,12,cmd,nch,lastch,TRUE)
	if(nch<=0)break
	for(i=1; i<=NCMD; i=i+1) if(streq(table(i),cmd)) break
	if(i>NCMD){
		EPRINT("Unrecognized directive ignored: ",C(cmd))
		if (lastch=="=") call cscan(ctrl,ipos,12,cmd,nch,lastch,FALSE)
		}
	else {
		iact = mod(action(i),100)
		charg = action(i)>100
		rarg = UNDEF
		if (lastch=="=")
			if (charg)
				call cscan(ctrl,ipos,12,carg,nch,lastch,FALSE)
			else {
				ipos = ipos+1
				while (jgetch(ctrl,ipos)==" ")
					ipos = ipos+1
				call strnum(ctrl,ipos,rarg,i,isign,itype,nch,lastch,TRUE)
				if(itype==0) rarg = UNDEF	# default
				ipos = ipos+nch
				while (jgetch(ctrl,ipos)==" ")
					ipos = ipos+1
				}
		switch(iact) {	# now set up parms and flags
		case 1:	# points
			flags(2) = 1
			plotd = TRUE
			c = jgetch(carg,1)
			if(c!=EOS) parms(2)=ICHAR(c)
			else parms(2) = -1
		case 2:	# lines
			flags(1) = 1
			plotd = TRUE
			if (rarg==UNDEF&&rparms(1)==0.) rparms(1) = 1.
			else if (rarg!=UNDEF) rparms(1) = rarg
		case 3:	# setup
			plotd = TRUE	# inhibit default point plot
		case 4:	# nplot
			flags(6) = 1
			plotd = TRUE
			if (rarg==UNDEF) rarg = 1.
			rparms(6) = rarg
		case 5:	# loglin
			parms(10) = parms(10)+1
		case 6:	# linlog
			parms(10) = parms(10)+2
		case 7:	# loglog
			parms(10) = 3
		case 8:	# linlin
			parms(10) = 0
		case 12:	# textc
			flags(4)=1; rparms(4) = .5
			plotd = TRUE
		case 13:	# textl
			flags(4)=1; rparms(4) = 1.
			plotd = TRUE
		case 14:	# textl
			flags(4)=1; rparms(4) = 0.
			plotd = TRUE
		case 15:	# consec
			flags(5) = 1
			plotd = TRUE
			if (rarg!=UNDEF) parms(5) = rarg
			else parms(5) = 1
		case 16:	# oldx
			parms(9) = parms(9)+1
		case 17:	# oldy
			parms(9) = parms(9)+2
		case 18:	# oldxy
			parms(9) = 3
		case 19:	# marks
			flags(3) = 1
			plotd = TRUE
			if (rarg!=UNDEF) parms(3) = rarg
			else  parms(3) = 0
		case 20:	# overplot
			flags(8) = 1
		case 21:	# dashed lines
			flags(1) = 2
			plotd = TRUE
		case 22:	# dotted lines
			flags(1) = 3
			plotd = TRUE
		case 23:	# lines miss points
			flags(7) = 1
			plotd = TRUE
			if (rarg==UNDEF) rarg = 1.
			rparms(7) = rarg
			if (flags(1)==0) {
				flags(1) = 1
				rparms(1) = 1.
				}
		case 24:	# size
			if (rarg==UNDEF) rarg = 0.
			rparms(11) = rarg
			}
		}
	}
	until(lastch==EOS)
if (!plotd) {
	flags(2) = 1
	parms(2) = -1
	}
return
end


subroutine plot3(x,y,n,ttl,sub,xlab,ylab,text,parms,rparms,flags)
INCLUDE(graphics,stack)
CHARACTER(ttl,*); CHARACTER(sub,*); CHARACTER(xlab,*)
CHARACTER(ylab,*)
POINTER text(n)
integer parms(12),flags(12),n
real x(n),y(n),rparms(12)
integer xsub,ysub
integer fsum,nx,ny,leng
CHARACTER(axtype,1); CHARACTER(pch,1)
logical logx,logy,oldx,oldy,over,xpd
real umin,umax,lty,adj,cty,cex
common/cpl1/dashl,dotl,nbox
fsum=flags(1)+flags(2)+flags(3)+flags(4)+flags(5)+flags(6)
if (n<=0 & !(fsum<=0 & parms(9)==3) ) return	# allow arbitrary n for "setup/oldxy"
over = flags(8)>0
if (over) SPECIFY( new(TRUE) )	# supress frame eject
call pinit	# needed to set up common blocks, etc
oldx = mod(parms(9),2)>0
oldy = parms(9)/2>0
if (!oldx&&!over)
	logx = mod(parms(10),2)>0
else {
	QUERY( axt(1,axtype) )
	logx = axtype=="l"
	}
if (!oldy&&!over)
	logy = parms(10)/2>0
else {
	QUERY( axt(2,axtype) )
	logy = axtype=="l"
	}
QUERY( lab(nx,ny,leng) )
if (!oldx&&!over) {
	call rangev(x,n,umin,umax)
	if (!logx) call stdaxz(BOTTOM," ",umin,umax,nx,2)
	else call logaxz(BOTTOM," ",umin,umax,nx,2)
	}
if (!oldy&&!over) {
	call rangev(y,n,umin,umax)
	if (!logy) call stdaxz(LEFT," ",umin,umax,ny,2)
	else call logaxz(LEFT," ",umin,umax,ny,2)
	}
if (fsum>0) {
	xsub = jstkgt(n,REAL)
	if (!logx) call rcopy(x,rs(xsub),n)
	else {
		for(i=0; i<n; i=i+1){
			j = xsub+i
			rs(j) = alog10(x(i+1))
			}
		}
	ysub = jstkgt(n,REAL)
	if (!logy) call rcopy(y,rs(ysub),n)
	else {
		for(i=0; i<n; i=i+1){
			j = ysub+i
			rs(j) = alog10(y(i+1))
			}
		}
	size = rparms(11)
	if (size<=0.) size = 1.
	if (flags(1)>0) {	# lines
		QUERY( lty(lty) )
		switch(flags(1)){
		case 1: SPECIFY( lty(rparms(1)) )
		case 2: SPECIFY( lty(dashl) )
		case 3: SPECIFY( lty(dotl) )
			}
		if (flags(7)<=0) call linesz(rs(xsub),rs(ysub),n)
		else {
			QUERY( cex(cex) )
			SPECIFY( cex(cex*size*rparms(7)) )
			call dlinez(rs(xsub),rs(ysub),n)
			SPECIFY( cex(cex) )
			}
		SPECIFY( lty(lty) )
		}
	QUERY( xpd(xpd)	) # expand for all but lines
	SPECIFY( xpd(TRUE) )
	if (flags(2)>0) {	# points
		QUERY( cty(cty), pch(pch) )
		if (parms(2)!=-1)
			SPECIFY( pch(CHARMAKE(parms(2))) )
		QUERY( cex(cex) )
		SPECIFY( cex(cex*size) )
		call pointz(rs(xsub),rs(ysub),n)
		SPECIFY( cex(cex), pch(pch), cty(cty) )
		}
	if (flags(3)>0) {	# dmarks
		QUERY( csi(ht) )
		SPECIFY( csi(ht*size) )
		call dmarkz(rs(xsub),rs(ysub),n,parms(3))
		SPECIFY( csi(ht) )
		}
	if (flags(4)>0) {	# text
		QUERY( cex(cex), adj(adj) )
		SPECIFY( cex(.75*size*cex), adj(rparms(4)) )
		for(i=0; i<n; i=i+1)
			call textz(rs(xsub+i),rs(ysub+i),TEXT(text(i+1)))
		SPECIFY( adj(adj), cex(cex) )
		}
	if (flags(5)>0) {	# consecutive ints
		QUERY( adj(adj), cex(cex) )
		SPECIFY( adj(.5), cex(cex*size) )
		for(i=0; i<n; i=i+1){
			j = xsub+i
			k = ysub+i
			call intz(rs(j),rs(k),i+parms(5))
			}
		SPECIFY( cex(cex), adj(adj) )
		}
	if (flags(6)>0) {	# nplot
		QUERY( pch(pch), cex(cex) )
		SPECIFY( pch("1"), cex(rparms(6)*size*cex) )
		call npntsz(rs(xsub),rs(ysub),n)
		SPECIFY( cex(cex), pch(pch) )
		}
	SPECIFY( xpd(xpd) )
	call jstkrl(2)	# allocations for xsub and ysub
	}
if (!over) {
	if (!logx) {
		call saxisz(BOTTOM,TRUE,TRUE)
		call saxisz(TOP,TRUE,FALSE)
		}
	else {
		call laxisz(BOTTOM,TRUE,TRUE)
		call laxisz(TOP,TRUE,FALSE)
		}
	if (!logy) {
		call saxisz(LEFT,TRUE,TRUE)
		call saxisz(RIGHT,TRUE,FALSE)
		}
	else {
		call laxisz(LEFT,TRUE,TRUE)
		call laxisz(RIGHT,TRUE,FALSE)
		}
	call bboxz(nbox)
	call ptitle(ttl,sub,xlab,ylab)
	}
return
end


subroutine runttl(rttl)

CHARACTER(rttl,*)
CHARACTER(rtt,100)
logical called
SAVE( called )
common/cruntt/locrtt,oline
common/crunt2/rtt
data called/FALSE/
if (!called) call pinit
QUERY( oma(o1,o2,o3,o4) )
if (!called) o3 = o3+3.0
else o3 = amax1(o3,3.0)
SPECIFY( oma(o1,o2,o3,o4) )
oline = o3-2.0
called = TRUE
locrtt = islenz(rttl)
if (locrtt!=0) {
	rtt=rttl
	call jputch(rtt,100,EOS)
	}
return
end



subroutine cscan(string,ipos,maxch,value,nch,lastch,cvt)
CHARACTER(string,*); CHARACTER(value,*)
CHARACTER(lastch,1)
integer ipos,maxch,nch
logical cvt
CHARACTER(jgetch,1); CHARACTER(upper,1); CHARACTER(ichar,1)
for(ipos=ipos+1; jgetch(string,ipos)==" "; ipos=ipos+1) ;	# skip blanks
ipos = ipos-1
for(i=1; i<=maxch; i=i+1) {
	ipos = ipos+1
	ichar = jgetch(string,ipos)
	if (ichar==EOS||ichar=="/"||ichar=="="){
		lastch=ichar
		nch=i-1
		call jputch(value,i,EOS)
		return
		}
	if (cvt) ichar = upper(ichar)
	call jputch(value,i,ichar)
	}
nch=0	# die if too long
lastch=EOS
return
end


subroutine oplot1(x,y,n,ctrl,text)
real x(n),y(n),rparms(12)
integer parms(12),flags(12)
POINTER text(n)
CHARACTER(ctrl,*)
common/cpl1/tldash,tldot,nskbox
common/cruntt/locrtt,oline
CHARACTER(irtt,100)
common/crunt2/irtt
call plot2(ctrl,parms,rparms,flags)
flags(8) = 1
call plot3(x,y,n,EOS,EOS,EOS,EOS,text,parms,rparms,flags)
return
end


SUPPORT(strnum,convert string to numeric (int or real))
subroutine strnum(it,ipos,val,intval,isign,itype,leng,ibrk,signed)
CHARACTER( it,*)
CHARACTER( ibrk,1)
INCLUDE(stack)
integer ipos,intval,j,isign2,itype,ival,isign,leng,leng1,leng2; real val; logical signed
CHARACTER( jbrk,1)
CHARACTER(jgetch,1)

itype = NULL
j = ipos
jbrk = jgetch(it,ipos)
isign = 1
if(signed && (jbrk=="+"|jbrk=="-")){
	if(jbrk=="-") isign=-1
	j=j+1
	}
call strint(it,j,FALSE,ival,isign2,leng1,ibrk)
val = ival
leng = leng1+j-ipos
if (leng1!=0||ibrk=="."){
	itype = INT
	if (ibrk=="."){	# pick up digits after decimal
		j = ipos+leng+1
		call strint(it,j,FALSE,ival,isign2,leng2,ibrk)
		if (leng1<=0&&leng2<=0){	# not a number - back up
			itype = NULL; leng=0; ibrk=jgetch(it,ipos); return
			}
		if (leng2>0) val = val+float(ival)*10.**(-leng2)
		itype = REAL
		leng = leng+leng2+1
		}
	if (ibrk=="E"||ibrk=="e"){	# exponent
		j = ipos+leng+1
		call strint(it,j,TRUE,ival,isign2,leng1,jbrk)
		if (leng1>0){
			val = val*10.**(ival*isign2)
			ibrk = jbrk
			itype = REAL
			leng = leng+leng1+1
			}
		}
	}
val=val*float(isign)
intval=val
return
end


SUPPORT(strint,		convert string to integer)
subroutine strint(it,ipos,sign,ival,isign,leng,ibrk)
CHARACTER( it,*)
CHARACTER( ibrk,1)
integer ipos,ival,isign,leng
logical sign,nodigs
integer i,j,digit,n
CHARACTER( jgetch,1)
CHARACTER(ichar,1)
ichar = jgetch(it,ipos)
isign = 1
i = ipos
n = 0
nodigs = TRUE
if (sign&&(ichar=="+"||ichar=="-")){
	if (ichar=="-")
		isign = -1
	i = i+1
	ichar=jgetch(it,i)
	}
repeat{
	j = digit(ichar)
	if(j<0)break
	n = n*10+j
	nodigs = FALSE
	i = i+1
	ichar = jgetch(it,i)
	}
if (nodigs)i = ipos
leng = i-ipos
ival = n
if (n==0)
	ichar = jgetch(it,i)
ibrk = ichar
return
end
