ROUTINE(rpntsz,		robust plot of scatter of points)
subroutine rpntsz(x,y,n,rbd,bd,obd)
real x(n),y(n),rbd(4),bd(4),obd(4)
INCLUDE(graphics)
logical clip,xpd
real sn(4),u(2),ub(4),eps(2)
data sn/-1., 1., -1., 1./
do j = 1,4 {
	ub(j) = 0.0
	if (bd(j)!=rbd(j))
		ub(j) = (obd(j)-rbd(j))/(bd(j)-rbd(j))
	}
eps(1) = (rbd(2)-rbd(1))*0.001
eps(2) = (rbd(4)-rbd(3))*0.001
QUERY( xpd(xpd), adj(adj), 1em(cx,cy) )
if (!xpd) SPECIFY( xpd(TRUE) )
SPECIFY( adj(0.0) )
cx = cx*.5
do i = 1,n {
	u(1) = x(i)
	u(2) = y(i)
	clip = FALSE
	do j = 1,4 {
		jj = (j+1)/2
		if (sn(j)*(u(jj)-rbd(j))>=eps(jj)) {
			u(jj) = rbd(j)+(u(jj)-rbd(j))*ub(j)
			clip = TRUE
			}
		}
	call pointz(u(1),u(2),1)
	if (clip) call intz(u(1)+cx,u(2),i)
	}
SPECIFY( adj(adj) )
if (!xpd) SPECIFY( xpd(FALSE) )
return
end
