SUPPORT(zstylz,		pick new axis style)
subroutine zstylz(pstyle,rstyle,nstyle,igo)
CHARACTER(pstyle,1); CHARACTER(rstyle,1); CHARACTER(nstyle,1)
# previous, requested and new styles
define(`NSTYLE',7)
integer action(NSTYLE,NSTYLE)
CHARACTER(style,1,NSTYLE)

# action table rows and columns indexed by styles
# " ", "s", "i", "e", "r", "d", and x

# rows correspond to previous style
# columns correspond to requested style

# each action is composed of 2 digits
# - first digit represents the new style
# - second digit represents the segment of code to execute
# 	= 1 set up s style from input
# 	= 2 set up i style from input
# 	= 3 set up e style from input
# 	= 4 set up d style from input
# 	= 5, ignore current call, return
# 	= 6, leave current axis, plot if desired
# 	= 7 set up r style from input

data ((action(i,j),j=1,NSTYLE),i=1,NSTYLE) /_
_ #current:   s   i   e   r   d   x	
	13, 21, 32, 43, 57, 64, 74,	#   :previous:
	21, 21, 32, 43, 57, 64, 74,	# s
	32, 21, 32, 43, 57, 64, 74,	# i
	43, 21, 32, 43, 57, 64, 74,	# e
	57, 21, 32, 43, 57, 64, 74,	# r
	66, 66, 66, 66, 66, 64, 66,	# d
	15, 25, 35, 45, 55, 64, 75/	# x

data style/" ", "s", "i", "e", "r", "d", " "/

style(NSTYLE) = pstyle
do i = 1,NSTYLE
	if (style(i)==pstyle) break
style(NSTYLE) = rstyle
do j = 1,NSTYLE
	if (style(j)==rstyle) break
igo = mod(action(i,j),10)
is = action(i,j)/10
nstyle = style(is)
return
end
