SUPPORT(zzdevz,		recompute after device size change)
subroutine zzdevz(rx1,rx2,ry1,ry2)
integer rx1,rx2,ry1,ry2

INCLUDE(graphics)
CHARACTER(ich,1)
logical xpd
real o1,o2,o3,o4

# this routine recomputes the 33 values in am(...)
# 32-47 55-56 67 68 72 73 76 77 84 90-93 98 99 123 124
# it is a modified version of zzfigz, zzpltz, and zscalz

am(22) = rx1
am(23) = rx2
am(24) = ry1
am(25) = ry2

o1 = am(90)*am(98)		# outer margin sizes in inches
o2 = (1.-am(91))*am(98)
o3 = am(92)*am(99)
o3 = (1.-am(93))*am(99)

am(98) = (am(23)-am(22))*am(28)	# recompute device in inches
am(99) = (am(25)-am(24))*am(29)

am(90) = o1/am(98)		# new outer margins as fractions
am(91) = 1.-o2/am(98)
am(92) = o3/am(99)
am(93) = 1.-o4/am(99)

fw = am(98)*(am(91)-am(90))/am(83)	# figure size
fh = am(99)*(am(93)-am(92))/am(82)

QUERY( fty(ich) )
if(ich=="s") ar = 1.0			# square
else if(ich=="i"){			# inches
	pw = amin1(am(123),fw)
	ph = amin1(am(124),fh)
	}
else if(ich=="d"){			# direct
	fw = am(91)-am(90)
	fh = am(93)-am(92)
	pw1 = am(44)*fw+am(90)
	pw2 = am(45)*fw+am(90)
	ph1 = am(46)*fh+am(92)
	ph2 = am(47)*fh+am(92)
	}
else if(ich=="a") ar = am(123)/am(124)	# aspect ratio
else{					# max "m" "c" "r"
	pw = fw
	ph = fh
	}
if(ich=="s" | ich=="a") {
	if (fw>ar*fh) {	# squeeze horizontally
		ph = fh
		pw = ph*ar
		}
	else {	# squeeze vertically
		pw = fw
		ph = pw/ar
		}
	}
if(ich!="d"){
	wextra = 0.5*(fw-pw)	# compute centered co-ordinates
	hextra = 0.5*(fh-ph)
	pw1 = amax1(0.0,am(90)+((am(81)-1.0)*fw+wextra)/am(98))
	pw2 = amin1(1.0,pw1+pw/am(98))
	ph1 = amax1(0.0,am(92)+((am(82)-am(80))*fh+hextra)/am(99))
	ph2 = amin1(1.,ph1+ph/am(99))
	}
if (pw1>=pw2||ph1>=ph2) {	# error, use entire device area
	pw1 = 0.
	pw2 = 1.
	ph1 = 0.
	ph2 = 1.
	}
am(44) = pw1
am(45) = pw2
am(46) = ph1
am(47) = ph2

fwc = am(98)*(am(45)-am(44))	# figure size inches
fhc = am(99)*(am(47)-am(46))

w1 = am(51)	# margin size
w2 = am(53)
h1 = am(50)
h2 = am(52)
fw = fwc-w1-w2	# available figure space inside margins
fh = fhc-h1-h2	# compute figure size w/o margins

QUERY( pty(ich) )
if(ich== "s") ar = 1.0			# square
else if(ich== "i"){			# inches
	pw = amin1(am(55),fw)
	ph = amin1(am(56),fh)
	}
else if(ich== "d"){			# direct
	pw1 = am(40)
	pw2 = am(41)
	ph1 = am(42)
	ph2 = am(43)
	}
else if(ich== "a") ar = am(55)/am(56)	# aspect ratio
else{					# max "m"
	pw = fw
	ph = fh
	}
if(ich=="s" | ich=="a"){
	if (fw>ar*fh) {	# squeeze horizontally
		ph = fh
		pw = ph*ar
		}
	else {	# squeeze vertically
		pw = fw
		ph = pw/ar
		}
	}
# compute centered co-ordinates
if(ich!="d"){
	wextra = 0.5*(fw-pw)
	hextra = 0.5*(fh-ph)
	pw1 = amax1(0.0,(w1+wextra)/fwc)
	pw2 = amin1(1.0,(fwc-w2-wextra)/fwc)
	ph1 = amax1(0.0,(h1+hextra)/fhc)
	ph2 = amin1(1.,(fhc-h2-hextra)/fhc)
	}
if (pw1>=pw2||ph1>=ph2) {	# error use entire figure
	pw1 = 0.
	pw2 = 1.
	ph1 = 0.
	ph2 = 1.
	}
am(40) = pw1
am(41) = pw2
am(42) = ph1
am(43) = ph2

fx = am(45)-am(44)
fy = am(47)-am(46)
px = am(41)-am(40)
py = am(43)-am(42)
dux = am(62)-am(61)
duy = am(64)-am(63)
xpd = am(65)>0.5
am(123) = am(98)*fx	# figure size
am(124) = am(99)*fy
am(55) = am(98)*fx*px	# plot size
am(56) = am(99)*fy*py
am(76) = am(55)/dux	# user co-ordinates in physical length
am(77) = am(56)/duy
drw = am(23)-am(22)	# 22-25 give the display in rasters
drh = am(25)-am(24)
am(37) = px*fx*drw/dux	# user to rasters linear transform
am(36) = am(22)+(am(40)*fx+am(44))*drw-am(37)*am(61)
am(39) = py*fy*drh/duy
am(38) = am(24)+(am(42)*fy+am(46))*drh-am(39)*am(63)
if (xpd) {	# expand on - clip at raster coords of figure
	am(32) = am(22)+am(44)*drw
	am(33) = am(22)+am(45)*drw
	am(34) = am(24)+am(46)*drh
	am(35) = am(24)+am(47)*drh
	}
else {	# not expand mode - clip at raster coords of plot
	am(32) = am(61)*am(37)+am(36)
	am(33) = am(62)*am(37)+am(36)
	am(34) = am(63)*am(39)+am(38)
	am(35) = am(64)*am(39)+am(38)
	}
crot = am(48)*DEG2RD
c = cos(crot)
s = sin(crot)
am(67) = (am(74)*c+am(75)*s)/am(76)	# character in user co-ordinates
am(68) = (am(74)*s+am(75)*c)/am(77)
c1em = amax1(am(74),am(75))		# 1em space
am(72) = c1em/am(76)
am(73) = c1em/am(77)
					# character as a fraction of figure
am(84) = c1em/amin1(am(98)*(am(45)-am(44)),am(99)*(am(47)-am(46)))
return
end
