SUPPORT(albeta,		compute function of a and b for betai)
real function albeta(a,b)
# july 1977 edition.   w. fullerton, c3, los alamos scientific lab.
real a,b,p,corr,q,alnrel,alngam,r9lgmc,gamma,sq2pil
data sq2pil/0.9189385332 0467274 e0/
p = amin1(a,b)
if(p<=0.0) ERROR(both arguments must be greater than zero)
q = amax1(a,b)

if (p>=10.0) {	# p and q are big.
	corr = r9lgmc(p)+r9lgmc(q)-r9lgmc(p+q)
	return( -0.5*alog(q)+sq2pil+corr+(p-0.5)*alog(p/(p+q))+q*alnrel(-p/(p+q)) )
	}

if (q<10.0)	# p and q are small.
	return(  alog(gamma(p)*(gamma(q)/gamma(p+q))) )

# p is small, but q is big.
corr = r9lgmc(q)-r9lgmc(p+q)
return( alngam(p)+corr+p-p*alog(p+q)+(q-0.5)*alnrel(-p/(p+q)) )

end
