ROUTINE(gam,computes gamma(eta))
real function gam(eta)
real eta

real a(8),feta,g1feta,test,prod,term
data a/-0.577191652,0.988205891,-.897056937,0.918206857,-0.756704078,0.482199394,-0.193527818,0.035868343/
if (eta>33.) {
	ERROR(eta greater than 33)
	return(BIG)
	}
if (eta<=0.0) {
	ERROR(eta less than or equal zero)
	return(0.0)
	}
feta = amod(eta,1.)
if (feta>0.)
	g1feta = 1.+feta*(a(1)+feta*(a(2)+feta*(a(3)+feta*(a(4)+feta*(a(5)+feta*(a(6)+feta*(a(7)+feta*a(8))))))))
else
	g1feta = 1.
if (eta<1.)
	gam = g1feta/feta
else if (eta<=2.)
	gam = g1feta
else {
	test = eta-.5
	prod = 1.
	term = 1.+feta
	repeat {
		prod = prod*term
		term = term+1.
		}
		until(term>=test)
	gam = prod*g1feta
	}
return
end
