ROUTINE(gslsi,gram-schmidt least-squares optional intercept)
subroutine gslsi(x,n,k,y,ny,q,r,corth,coef,nc,resid,int,work)
integer n,k,ny,nc
real x(n,k),y(n,ny),q(n,nc),r(2),corth(nc,ny),coef(nc,ny),resid(n,ny),work(2)
logical int

INCLUDE(stack)
INCLUDE(gs) #parameters for gs iteration
integer j,jj,i,ii,rank
real fn,dot
POINTER jstkgt,const,other,ocoef

omega=0.; theta=1.4; sigma=PRECISION
if(int) { # prepare intercept calculations
	const=jstkgt(ny,REAL)
	other=jstkgt(k*ny,REAL)
	ocoef=jstkgt(k*ny,REAL)
	fn=sqrt(float(n))
	call rfill(1./fn,q,n)
	call devw(x,n,k,y,ny,work,rs(const),q)
	call rfill(0.,r,nc**2)
	call gsls(x,n,k,y,ny,q(1,2),r(1+nc),rs(other),rs(ocoef),resid,rank,work(k+1))
	for(j=nc; j>1; j=j-1){ # shift elements of r down
		jj=j-1; ii=(j-1)*k
		for(i=ii+j; i>ii; i=i-1){ r(i+jj)=r(i); r(i)=0. }
		}
	r(1)=fn
	for(i=1;i<nc;i=i+1) r(1+i*nc)=work(i)
	for(i=1;i<=ny;i=i+1){
		call rcopy(rs(other+(i-1)*k),corth(2,i),k)
		call rcopy(rs(ocoef+(i-1)*k),coef(2,i),k)
		corth(1,i)=rs(const+i-1)
		coef(1,i)=-dot(-corth(1,i),work,1,k,coef(2,i),1)/fn
		}
	call jstkrl(3)
	}
else {
	call rfill(0.,r,k**2)
	call gsls(x,n,k,y,ny,q,r,corth,coef,resid,rank,work)
	}
return
end
