ROUTINE(ranset,		initialize seeds for random number generator,
`subroutine ranset(icseed,itseed)
integer icseed,itseed')
/* Used for stand-alone algorithms or setting non-standard seeds */
/* icseed is congruential generator seed, itseed for Tausworthe generator */

extern unsigned congr1,congr2,congr3, lambda1,lambda2;
extern long tausval;

F77_SUB(ranset, int=icseed, int=itseed)
{
	r_ranset(F_INTP(icseed),F_INTP(itseed));
}

static r_ranset(icseed,itseed)
long *icseed, *itseed;
{
	lambda2 = 69069>>12; lambda1 = 69069-(lambda2<<12);

	tausval = *itseed;
	/* make sure non-zero seeds are odd */
	if(tausval!=0 && tausval % 2 == 0) tausval++;

	if(*icseed!=0 && *icseed % 2 == 0) *icseed++;
	congr1 = (unsigned)*icseed & 07777;
	congr2 = ((unsigned)*icseed >> 12) & 07777;
	congr3 = (unsigned)*icseed >> 24;
}
