ROUTINE(tinvit,		inverse iteration technique)
subroutine tinvit(nm,n,d,e,e2,m,w,ind,z,ierr,rv1,rv2,rv3,rv4,rv6)
integer i,j,m,n,p,q,r,s,ii,ip,jj,nm,its,tag,ierr,group
real d(n),e(n),e2(n),w(m),z(nm,m),
	rv1(n),rv2(n),rv3(n),rv4(n),rv6(n)
integer ind(m)
#     this subroutine is a translation of the inverse iteration tech-
#     nique in the algol procedure tristurm by peters and wilkinson.
#     handbook for auto. comp., vol.ii-linear algebra, 418-439(1971).

real u,v,uk,xu,x0,x1,eps2,eps3,eps4,norm,order
real sqrt,abs,float
#
#
#     this subroutine finds those eigenvectors of a tridiagonal
#     symmetric matrix corresponding to specified eigenvalues,
#     using inverse iteration.
#
#     on input-
#
#        nm must be set to the row dimension of two-dimensional
#          array parameters as declared in the calling program
#          dimension statement,
#
#        n is the order of the matrix,
#
#        d contains the diagonal elements of the input matrix,
#
#        e contains the subdiagonal elements of the input matrix
#          in its last n-1 positions.  e(1) is arbitrary,
#
#        e2 contains the squares of the corresponding elements of e,
#          with zeros corresponding to negligible elements of e.
#          e(i) is considered negligible if it is not larger than
#          the product of the relative machine precision and the sum
#          of the magnitudes of d(i) and d(i-1).  e2(1) must contain
#          0.0 if the eigenvalues are in ascending order, or 2.0
#          if the eigenvalues are in descending order.  if  bisect,
#          tridib, or  imtqlv  has been used to find the eigenvalues,
#          their output e2 array is exactly what is expected here,
#
#        m is the number of specified eigenvalues,
#
#        w contains the m eigenvalues in ascending or descending order,
#
#        ind contains in its first m positions the submatrix indices
#          associated with the corresponding eigenvalues in w --
#          1 for eigenvalues belonging to the first submatrix from
#          the top, 2 for those belonging to the second submatrix, etc.
#
#     on output-
#
#        all input arrays are unaltered,
#
#        z contains the associated set of orthonormal eigenvectors.
#          any vector which fails to converge is set to zero,
#
#        ierr is set to
#          zero       for normal return,
#          -r         if the eigenvector corresponding to the r-th
#                     eigenvalue fails to converge in 5 iterations,
#
#        rv1, rv2, rv3, rv4, and rv6 are temporary storage arrays.
#
#     questions and comments should be directed to b. s. garbow,
#     applied mathematics division, argonne national laboratory
#
ierr = 0
if (m!=0) {
	tag = 0
	order = 1.0-e2(1)
	q = 0
	repeat {
#     ********** establish and process next submatrix **********
		p = q+1
#
		do q = p,n {
			if (q==n)
				break 1
			if (e2(q+1)==0.0)
				break 1
			}
#     ********** find vectors by inverse iteration **********
		tag = tag+1
		s = 0
#
		do r = 1,m
			if (ind(r)==tag) {
				its = 1
				x1 = w(r)
				if (s==0) {
#     ********** check for isolated root **********
					xu = 1.0
					if (p==q) {
						rv6(p) = 1.0
						go to 30
						}
					else {
						norm = abs(d(p))
						ip = p+1
#
						do i = ip,q
							norm = norm+abs(d(i))+abs(e(i))
#     ********** eps2 is the criterion for grouping,
#                eps3 replaces zero pivots and equal
#                roots are modified by eps3,
#                eps4 is taken very small to avoid overflow **********
						eps2 = 1.0e-3*norm
						eps3 = PRECISION*norm
						uk = float(q-p+1)
						eps4 = uk*eps3
						uk = eps4/sqrt(uk)
						s = p
						}
					}
				else
#     ********** look for close or coincident roots **********
				 if (abs(x1-x0)<eps2) {
					group = group+1
					if (order*(x1-x0)<=0.0)
						x1 = x0+order*eps3
					go to 10
					}
				group = 0
#     ********** elimination with interchanges and
#                initialization of vector **********
				10  v = 0.0
#
				do i = p,q {
					rv6(i) = uk
					if (i!=p)
						if (abs(e(i))<abs(u)) {
							xu = e(i)/u
							rv4(i) = xu
							rv1(i-1) = u
							rv2(i-1) = v
							rv3(i-1) = 0.0
							}
						else {
#     ********** warning -- a divide check may occur here if
#                e2 array has not been specified correctly **********
							xu = u/e(i)
							rv4(i) = xu
							rv1(i-1) = e(i)
							rv2(i-1) = d(i)-x1
							rv3(i-1) = 0.0
							if (i!=q)
								rv3(i-1) = e(i+1)
							u = v-xu*rv2(i-1)
							v = -xu*rv3(i-1)
							next 1
							}
					u = d(i)-x1-xu*v
					if (i!=q)
						v = e(i+1)
					}
#
				if (u==0.0)
					u = eps3
				rv1(q) = u
				rv2(q) = 0.0
				rv3(q) = 0.0
				repeat {
#     ********** back substitution
#                for i=q step -1 until p do -- **********
					do ii = p,q {
						i = p+q-ii
						rv6(i) = (rv6(i)-u*rv2(i)-v*rv3(i))/rv1(i)
						v = u
						u = rv6(i)
						}
#     ********** orthogonalize with respect to previous
#                members of group **********
					if (group!=0) {
						j = r
#
						do jj = 1,group {
							repeat
								j = j-1
								until(ind(j)==tag)
							xu = 0.0
#
							do i = p,q
								xu = xu+rv6(i)*z(i,j)
#
							do i = p,q
								rv6(i) = rv6(i)-xu*z(i,j)
							}
						}
#
					norm = 0.0
#
					do i = p,q
						norm = norm+abs(rv6(i))
#
					if (norm>=1.0)
						go to 20
#     ********** forward substitution **********
					if (its==5)
						break 1
					if (norm!=0.0) {
						xu = eps4/norm
#
						do i = p,q
							rv6(i) = rv6(i)*xu
						}
					else {
						rv6(s) = eps4
						s = s+1
						if (s>q)
							s = p
						}
#     ********** elimination operations on next vector
#                iterate **********
					do i = ip,q {
						u = rv6(i)
#     ********** if rv1(i-1) .eq. e(i), a row interchange
#                was performed earlier in the
#                triangularization process **********
						if (rv1(i-1)==e(i)) {
							u = rv6(i-1)
							rv6(i-1) = rv6(i)
							}
						rv6(i) = u-rv4(i)*rv6(i-1)
						}
#
					its = its+1
					}
#     ********** set error -- non-converged eigenvector **********
				ierr = -r
				xu = 0.0
				go to 30
#     ********** normalize so that sum of squares is
#                1 and expand to full order **********
				20  u = 0.0
#
				do i = p,q
					u = u+rv6(i)**2
#
				xu = 1.0/sqrt(u)
#
				30  do i = 1,n
					z(i,r) = 0.0
#
				do i = p,q
					z(i,r) = rv6(i)*xu
#
				x0 = x1
				}
		}
		until(q>=n)
	}
return
end



