ROUTINE(tranr,		in-situ transposition of rectangular matrix)
subroutine tranr(a,m,n,mn,move,iwrk,iok)
# algorithm 380 cacm
# susan laflin and m a brebner
integer m,n,mn,iwrk,iok
real a(mn),b
integer move(iwrk)

integer ncount,m2,i,ia,ib,k,kmi,max,i1,i2,n1,j1,j
# check args and initialize
iok=0
if(m<2|n<2) return
if (mn!=m*n | iwrk<1) FATAL(bad input values)
if (m==n) { # if matrix square, exchange a(i,j) and a(j,i)
	n1 = n-1
	do i = 1,n1 {
		j1 = i+1
		do j = j1,n {
			i1 = i+(j-1)*m
			i2 = j+(i-1)*m
			if (NA(a(i1))) NASET(b); else b = a(i1)
			if (NA(a(i2))) NASET(a(i1)); else a(i1) = a(i2)
			if (NA(b)) NASET(a(i2)); else a(i2) = b
			}
		}
	return
	}


ncount = 2	# non-square matrices
m2 = m-2
do i = 1,iwrk
	move(i) = 0
if (m2>=1)	# count number, ncount, of single points
	do ia = 1,m2 {
		ib = ia*(n-1)/(m-1)
		if (ia*(n-1)==ib*(m-1)) {
			ncount = ncount+1
			i = ia*n+ib
			if (i<=iwrk) move(i) = 1
			}
		}
k = mn-1	# set initial values for search
kmi = k-1
max = mn
i = 1
repeat {	# rearrange elements of a loop
	i1 = i
	repeat {
		if (NA(a(i1+1))) NASET(b); else b = a(i1+1)
		repeat {
			i2 = m*i1-k*(i1/n)
			if (i1<=iwrk) move(i1) = 2
			ncount = ncount+1
			if (i2==i||i2>=kmi) {
				if (max==kmi||i2==i) break
				max = kmi
				}
			if (NA(a(i2+1))) NASET(a(i1+1)); else a(i1+1) = a(i2+1)
			i1 = i2
			}
# test for symmetric pair of loops
		if (NA(b)) NASET(a(i1+1)); else a(i1+1) = b
		if (ncount>=mn) return
		if (i2==max||max==kmi) break
		max = kmi
		i1 = max
		}
	repeat {	# search for loops to rearrange
		max = k-i
		i = i+1
		kmi = k-i
		if (i>max) FATAL(Transposition error)
		if (i>iwrk) {
			i2 = m*i-k*(i/n)
			if (i2>i&&i2<max) {
				repeat
					i2 = m*i2-k*(i2/n)
					until(i2<=i||i2>=max)
				if (i2==i) break
				}
			}
		else if (move(i)<1) break
		}
	}
end
