ROUTINE(trmean,trimmed mean or median)
real function trmean(x,n,alpha)
integer n
real x(n),alpha

double precision sum, trimmd, wt
integer partl,last,l,m,i

if(alpha>.5 | alpha<0.)ERROR(Trimming parameter must be between 0 and .5 inclusive)
if(n<1)ERROR(Number of points not positive)

if(alpha==.5){	# median
	L= (n+1)/2; m=(n+2)/2
	return(.5*(x(L)+x(m)))
	}

trimmd=dble(alpha)*dble(float(n))	# (fractional) number of points trimmed
partl=trimmd+1.d0		# index of first partially included point
wt=dble(float(partl))-trimmd	# fraction of partial point to include
last=n+1-partl		# symmetric opposite of partl
if(partl>=last) return(x(partl))	# only center point involved

sum=0.0d0
for(i=partl+1; i<last; i=i+1) sum=sum+dble(x(i))
sum=sum+wt*(dble(x(partl))+dble(x(last)))
return( sum/(dble(float(n))-2.d0*trimmd) )
end
