#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <math.h>
#include "S.h"
#include "y.tab.h"
#include "eval.h"
#include "options.h"

/*
 * the vector defining the atomic types: this has to be
 * consistent with the choice of modes in S.h
 */
int atomic_types[MAX_ATOMIC+1] = {TRUE,TRUE,TRUE,TRUE,TRUE,TRUE,FALSE,TRUE};

/*
	allocation for QPE routines:
	This strategy is intended to work well when a lot of storage is allocated
	in varying size chunks and then a whole arena is freed at once.
	Overhead in individual allocations is avoided by subdividing relatively
	large blocks, without any internal chaining.
	Routines calling S_alloc must, of course, NEVER free except by freeing
	the whole temporary space (a list of arenas).
	The mode routine set_alloc(n) sets the arena to that for frame n.
	Note that the strategy can be changed by redefining the BLOCK_SIZE
	parameter and recompiling this file alone.
	BLOCK_SIZE is slightly less than a multiple of malloc's
	For proper alignment, SIZE_UNIT should be the size of the largest
	atomic data type.
	block size since malloc will add a pointer word.
	Each data frame, as established by eval(), has its own list of arenas,
	to permit releasing space when the frame is deleted.
	In addition there are three special frames, FRAME0, for explicit assigns
	to frame 0, CACHE_FRAME for the function hash table, and PERM_FRAME for
	objects that remain unconditionally throughout the session (e.g., things
	needed by the evaluator itself
*/

#define BLOCK_SIZE	4090
#define SIZE_UNIT	sizeof(complex)
#define SET_BOUNDS(p,m)	(p<min_alloc?(min_alloc=p):NULL,\
			p+m>max_alloc?(max_alloc=p+m):NULL);
#define UNDEF_PTR ((char *)-2)
#define CHECK_MEM_SIZE	if((long)(sbrk(0)-sbrk0) > max_memory) {\
			if(sbrk0 == UNDEF_PTR)sbrk0 = sbrk(0);\
			else mem_terminate();}
#define FRAME_ARENA	Arenas[cur_frame]

typedef struct s_arena {
	int Type;
	char *block;
	int used;
	struct s_arena *next;
	struct s_arena *prev;
	int size;
} S_arena;
#define ARENA_TYPE LBRACE
#define BUCKET_TYPE LPAR
/* just not ENTRY_TYPE */

#define BUCKET_SIZE 500
typedef struct s_bucket {
	int Type;
	struct s_vector vectors[BUCKET_SIZE];
	long nfree;
	long top;
	struct s_bucket *prev;
	struct s_bucket *next;
		} S_bucket;


vector *compact_keep(), *S_storage();
char *S_alloc(), *S_realloc();
void do_compact();
int hash();
unsigned charmash();
long set_alloc(), menu(), file_mtime();
void clear_alloc(), mem_size(), ichar(), hash_enter(), un_hash(), nprime();
void echo_on(), echo_off(), flush_input();
S_arena *cur_arena;
long cur_frame;
char *min_alloc = (char *)INTEGER_MAX, *max_alloc = NULL;

static int bad_guy();
static unsigned cmash2(), emash();
static char *val_ptr(), *make_block();
static void new_block(), mem_terminate(), frame_keep();
static vector *get_header();
static long *S_stack, used, free0;
static char *cur_block, *sbrk0 = UNDEF_PTR;
static vector *storage = NULL, *vectors, **Arenas, **Buckets;
static S_bucket *cur_bucket =NULL;

char *
S_alloc(n,size)
long n; int size;
{
	register long i, need ;
if(check) {
	if(storage &&(cur_arena != (S_arena *)FRAME_ARENA)) {
		fprintf(stderr,"Storage botch: arena=%x, frame=%ld, storage[frame]=%x\n",cur_arena,cur_frame,(S_arena *)FRAME_ARENA);
		S_terminate("");
	if(cur_arena && cur_arena->used != used)
		S_terminate("Storage botch: arena->used not tracked");
	if(cur_arena && cur_arena->block != cur_block)
		S_terminate("Storage botch: arena->block not tracked");
	}
}
	if(n < 0)
		Recover("System error: request for negative amount of memory", NULL_ENTRY);
	if(!cur_arena)
		new_block();
	n *= size; /* compute needed bytes, but always allocate in whole words */
	if(need = n % SIZE_UNIT)
		n += SIZE_UNIT - need;
		/* NB: above assumes alignment on long boundaries is sufficient 
		   may be machine dependent */
	if(n > scrap)
		return(make_block(n)); /* put big guys into block by themselves */
	if(n+used > BLOCK_SIZE)
		new_block();
	i = used; used += n; cur_arena->used = used;
	if(check) {
		char *p = cur_block+i;
		while(n--)
			if(*p++)
				S_terminate("Dynamic storage overwritten on allocation");
	}
	return(cur_block + i);
}

extern long F77_SUB(jstkst) ();
static long one = 1L, nstack; /* for old-S storage */

/* set the current storage arena to frame n, create if necessary
/* frame 0 is the permanent storage frame */
long 
set_alloc(n)
long n;
{
	long i,j, old; long N;
	extern int cache_ok; /* temporary */
	if(storage == NULL) { /* initialize */
		if(scrap<1)scrap = 500; /* before .Options read */
		new_block();
		cur_frame = PERM_FRAME;
		storage = alcvec(LIST, EXTRA_FRAMES+1);
		Arenas = storage->value.tree + EXTRA_FRAMES;
		Arenas[0] = (vector *)cur_arena;
		vectors = alcvec(LIST,EXTRA_FRAMES+1);
		Buckets = vectors->value.tree + EXTRA_FRAMES;
		Buckets[0] = (vector *)cur_bucket;
		for(i= -EXTRA_FRAMES; i< 1; i++)
			Arenas[i] = Buckets[i] = NULL_ENTRY;
		S_stack = (long *)Perm_alloc(storage->nalloc, sizeof(long))+EXTRA_FRAMES;
	}
	N = n + EXTRA_FRAMES; /* need N+1, including special frames */
	if(N >= storage->length) {
		j = storage->length;
		if(N >= storage->nalloc) {
			long prev = set_alloc(PERM_FRAME);
			append_el(storage, N, S_void);
			Arenas = storage->value.tree + EXTRA_FRAMES;
			append_el(vectors, N, S_void);
			Buckets = vectors->value.tree + EXTRA_FRAMES;
			if(running_S)
				S_stack = (long *)Perm_realloc((char *)(S_stack-EXTRA_FRAMES),
					(storage->nalloc)*sizeof(long))+EXTRA_FRAMES;
			set_alloc(prev);
		} else
			storage->length = vectors->length = N + 1;
		j -= EXTRA_FRAMES;
		for(i = n; i >= j; i--)
			Arenas[i] = Buckets[i] = NULL_ENTRY;
	}
	old = cur_frame;
	if(n == old)
		return(n);
	if(n+EXTRA_FRAMES < 0 ) PROBLEM "Storage frame %ld invalid", n+EXTRA_FRAMES
		RECOVER(NULL_ENTRY);
	if(n == CACHE_FRAME && !cache_ok)
		Recover("Tried to allocate in cache frame outside of hash",NULL_ENTRY);
	if(cur_arena)
		Arenas[old] = (vector *)cur_arena;
	if(cur_bucket)
		Buckets[old] = (vector *)cur_bucket;
	cur_frame = n; cur_arena =  (S_arena *)Arenas[n];
		cur_bucket = (S_bucket *)Buckets[n];
	if(!cur_arena) {
		new_block();
		Arenas[n] = (vector *)cur_arena;
		if(running_S)
			S_stack[n] = F77_SUB(jstkst) (&one);
	}
	cur_block = cur_arena->block;
	used = cur_arena->used;
	return(old);
}

/* clear current frame's storage (i>0) or all storage (i==0) */
void 
clear_alloc(i)
long i;
{
	S_arena *n, *nn; S_bucket *b, *bb;
	switch((int)i) {
	case PERM_FRAME:/* clean up at the end of the statement  evaluation */
		i = storage->length - 1-EXTRA_FRAMES;
		while(i>0) clear_alloc(i--);
		storage->length = vectors->length = 2+EXTRA_FRAMES;
		cur_frame = 1; cur_arena = NULL; cur_bucket = NULL;
		return;
	case FRAME0: 
		Recover("System error: trying to clear frame 0",NULL_ENTRY);
		break;
	case CACHE_FRAME:  /* don't do it now, things may point at the
		/* definitions.  Instead, stick arenas, buckets into frame 1
		/* to be deallocated at the  end of the evaluation*/
		n = (S_arena *)Arenas[1];
		b = (S_bucket *)Buckets[1];
		if(!n || !b) /* outside of evaluator, just do it (possible?)*/
		  break;
		while(n->prev)n = n->prev;
		n->prev = (S_arena *)Arenas[i]; (n->prev)->next = n;
		while(b->prev)b = b->prev;
		b->prev = (S_bucket *)Buckets[i]; (b->prev)->next = b;
		Arenas[i] = Buckets[i] = NULL;
		return;
	default: if(i < -EXTRA_FRAMES || i>= storage->length-EXTRA_FRAMES)
		Recover(enci1("System error: invalid frame(%ld) to be de-allocated",
			i), NULL_ENTRY);
	}
	n = (S_arena *)Arenas[i];
	while(n && n->Type==ARENA_TYPE) {
		if(n == cur_arena)
			cur_arena = NULL;
		nn = n->prev; if(n->block)free(n->block); free((char *)n);
		n = nn;
	}
	b = (S_bucket *)Buckets[i];
	while(b ) {
if(check && b->Type!=BUCKET_TYPE)
	Recover(enci2("Vector bucket in frame %ld has bad Type (%ld) on clear",
	  i,(long)b->Type), NULL_ENTRY);
		if(b == cur_bucket)
			cur_bucket = NULL;
		bb = b->prev; free((char *)b);
		b = bb;
	}
	if(running_S) {
		nstack  = F77_SUB(jstkst) (&one) - S_stack[i];
		if(nstack>0)
			F77_SUB(jstkrl) (&nstack);
	}
	Arenas[i] = Buckets[i] = NULL_ENTRY;
}


free_block(p)
char *p;
{
	S_arena *n, *nright, *nleft;
	nleft = cur_arena; n = cur_arena->prev;
	while(n) {
if(check && n->Type!=ARENA_TYPE)
	Recover(enci2("Arena in frame %ld has bad Type (%ld)",
	  cur_frame,(long)n->Type), NULL_ENTRY);
		nright = n->prev;
		if(n->block == p) {
			nleft->prev = nright;
			if(nright)nright->next = nleft;
			free(n->block); free((char *)n);
			break;
		}
		nleft = n; n = nright;
	}
}

void 
try_to_free(object,recursive)
vector *object; int recursive;
{
	long n,s, mode; vector **p; char *val;
	if(!Compact)return;
	if(object->Type == FREED_TYPE)return; /* already freed: the assumption is
		that this is innocuous, but one may question the assumption */
	if(PRECIOUS(object) && object->x.frame != Local_data) { /*non-local */
		free_header(object); /* can ONLY free the local pointer */
		return;
	}
	mode = object->mode; /* not data_mode() */
	if(recursive++ && !(atomic_type(mode) || NOT_RECURSIVE(mode)))
		for(n = object->length, p = object->value.tree; n>0; n--, p++)
			try_to_free(*p,recursive);
	switch((int)mode) {
	case INT:
	case LGL:
		s = sizeof(long); val = (char *)object->value.Long; break;
	case REAL:
		s = sizeof(float); val = (char *)object->value.Float; break;
	case CHAR:
		s = sizeof(char *); val = (char *)object->value.Char; break;
	case DOUBLE:
		s = sizeof(double); val = (char *)object->value.Double; break;
	case COMPLEX:
		s = sizeof(complex); val = (char *)object->value.Complex; break;
	default:
		if(NOT_RECURSIVE(mode)){MEANINGFUL(val);s=0; break;}
		s = sizeof(vector *); val = (char *)object->value.tree;
	}
	if(s*object->length > scrap) free_block(val);
	else if(cur_frame == FRAME0)free0 += s;
	free_header(object);
}

static char **lower, **upper;
static S_arena *throw, *old_top, **to_throw;
static long nthrow;

void 
mem_size(n)
long *n;
{
	*n = (long)(sbrk(0) - sbrk0);
}

static 
make_ptrs(ptr)
char **ptr;
{
/* return pointers to the cur_arena and its current prev pointer */
/* anything in between when compacting occurs was a later make_block() */
/* and so can be free'd */
	S_arena *p;
	ptr[0] = (char *)cur_arena;
	p = cur_arena->prev;
	if(p && p->used == p->size) { /* want an arena that will not
		be deleted, & this make_block() might be, so put in a new one */
		make_block(1L);
		p = cur_arena->prev;
	}
	ptr[1] = (char *)p;
}

/* returns pointer to current arena, if ptr[0] is null */
/* otherwise, checks if arenas beyond ptr[0] occupy more than */
/* Compact bytes.  If so, compaction is done and the revised */
/* pointer to the end of occupied space is returned. */
/* save1, save2 contain pointers to objects that need to be copied, */
/* and revised versions will be stored into them if compaction occurs */
void 
alloc_ptr(ptr,save1,save2)
char **ptr; vector **save1, **save2;
{
	long nblock, nbyte = 0, n, n1, n2;
	S_arena *p, *pp, *top;
	/*top, pp are the previous top & ->prev ptr at the time */
	top = (S_arena *)ptr[0]; pp = (S_arena *)ptr[1];
	if(!top) {
		make_ptrs(ptr);
		return;
	}
	if(!Compact)return;
	for(p = cur_arena, n1=0; p && p != top; p = p->prev) {
		n1++; nbyte += (p->size + sizeof(S_arena));
	}
	if(!p) Recover("Internal problem: pointer for storage check invalid", NULL_ENTRY);
	for(p = top->prev, n2=0;p && p!=pp; p = p->prev) {
		n2++; nbyte += (p->size + sizeof(S_arena));
	}
	if(pp && pp->size==1)n2++; /* the inserted block */
	if(nbyte < Compact) return;
	/* else, set up the lower & upper bounds, cut off the storage */
	nblock = n1 + n2;
	lower = CALLOC(2*nblock, char*);
	upper = lower + nblock; nthrow = nblock;
	to_throw = CALLOC(nblock, S_arena*);
	for(p = cur_arena, n = 0; p && p!=top && n < n1; p = p->prev, n++) {
		lower[n] = p->block;
		upper[n] = lower[n] + p->size;
		to_throw[n] = p;
	}
if(check) {
	if(n!=n1)Warning(enci2("compacting: no of left arenas was %ld, expected %ld",n,n1),NULL_ENTRY);
}
	n2 = n1 +n2;
	for(p = top->prev; p && p!=pp && n<n2; p = p->prev,n++) {
		lower[n] = p->block;
		upper[n] = lower[n] + p->size;
		to_throw[n] = p;
	}
	if(pp && pp->size==1){ /* the inserted block */
		lower[n] = p->block; upper[n] = lower[n]+1;
		to_throw[n] = p;
		pp = pp->prev; n++;
	}
if(check) {
	if(n!=nblock)Recover(enci2("compacting: Total no. of arenas was %ld, expected %ld",n,nblock),NULL_ENTRY);
}
	throw = top->next; top->next = NULL;/* the rest is now thrown away */
	top->prev = pp; if(pp)pp->next = top;
	cur_arena = top; used = top->used; cur_block = top->block;
	Arenas[cur_frame] = (vector *)cur_arena;
	if(save1) *save1 = compact_keep(*save1);
	if(save2) *save2 = compact_keep(*save2);
	do_compact(ptr);
}

static void
frame_keep(frame)
vector *frame;
{
	long n=frame->length; vector *object, **p; char *name;
	if(bad_guy((char *)frame))Recover(
		enci1("internal error: can't compact data in frame %ld",
		cur_frame),NULL_ENTRY);
	if(bad_guy((char *)frame->value.tree)) {
		vector **new;
		new = (vector **)S_alloc(frame->nalloc,sizeof(vector *));
		MEMCPY(new, frame->value.tree, frame->nalloc);
		frame->value.tree = new;
	}
	for( p = frame->value.tree; n>0; n--, p++) {
		object = *p = compact_keep(*p);
		name = object->name;
		if(*name == '.')re_assign(cur_frame,name,object);
	}
}

vector *
compact_keep(object)
vector *object;
{
	vector *p;
	long mode;
	if(object==NULL_ENTRY)return(S_void); /* On_stop, e.g., may have NULLs*/
	mode = object->mode;
	if(bad_guy((char *)object))
		return(copy_data(object, object->x.frame));
	if(bad_guy(object->name))
		object->name = c_s_cpy(object->name);
	if(bad_guy(val_ptr(object))) { /* value bad: copy */
		p = copy_data(object, object->x.frame);
		*object = *p;
	} else if(!NOT_RECURSIVE(mode)) { /*check the elements */
		vector **pp; long n;
		for(n = object->length, pp = object->value.tree; n > 0; n--, pp++)
			*pp = compact_keep(*pp);
	} else if(mode == CHAR) { /*  check for strings to copy */
		char **pp; long n;
		for(n = object->length, pp = object->value.Char; n > 0; n--, pp++)
			if(bad_guy(*pp))
				*pp = c_s_cpy(*pp);
	}
	return(object);
}


/* save the global information about this frame, */
/* throw away the extra blocks, set ptrs to the new top */
void 
do_compact(ptr)
char **ptr;
{
	S_arena *p; extern vector *On_stop, *C_wrapup, *to_frame0;
	long n; S_bucket *b; vector *v, **vv; char *pp; extern vector **C_specials;
	frame_keep(Local_data); /* will not change Local_data itself*/
	for(n=Local_data->length, vv = Local_data->value.tree; n>0; n--,vv++){
if(check){
	if(pp = sanity(*vv,NULL_STRING))
		Recover(encs2("Bad object in copied local data for \"%s\": %s",
			(*vv)->name,pp),NULL_ENTRY);
	if(!(*vv)->name)Recover("Unnamed element in compacted data",NULL_ENTRY);
}
		pp = (*vv)->name;
		if(*pp == '.')check_assign(cur_frame,pp,*vv);
	}
	if(On_stop->length >=cur_frame) {
		v = On_stop->value.tree[cur_frame-1];
		if(v!=NULL_ENTRY && v!=S_void)
			On_stop->value.tree[cur_frame-1] = compact_keep(v);
	}
	if(C_on_stop->length >=cur_frame) {
		v = C_on_stop->value.tree[cur_frame-1];
		if(v!=NULL_ENTRY && v!=S_void)
			C_on_stop->value.tree[cur_frame-1] = compact_keep(v);
	}
	if(C_specials[cur_frame-1]->length){ /* something visible to C */
		install_search(compact_keep(Search_list));
		if(Trace)Trace = compact_keep(Trace);
	}
	if(cur_frame == 1L) { /* check the globals for the top level frame */
		frame_keep(S_data);
		if(assign_data != NULL_ENTRY)
			assign_data = compact_keep(assign_data);
		h_S_data = compact_keep(h_S_data);
		if(to_frame0 != NULL_ENTRY)
			to_frame0 = compact_keep(to_frame0);
		if(hash_data != NULL_ENTRY)
			hash_data = compact_keep(hash_data);
		On_stop = compact_keep(On_stop);
		if(C_wrapup != NULL_ENTRY)
			C_wrapup = compact_keep(C_wrapup);
		if(Warn_list != NULL_ENTRY)
			Warn_list = compact_keep(Warn_list);
	}
	for(n = 0; n < nthrow; n++) {
		p=to_throw[n];
if(check) {
	if(!p)Warning("Null pointer to be freed in compacting",NULL_ENTRY);
	else if(p->Type != ARENA_TYPE) Recover(enci1("system error: bad arena pointer (type %ld) to compact",
		(long)p->Type),NULL_ENTRY);
}
		 if(p){if(p->block)free(p->block); free((char *)p);}
	}
	for(b = cur_bucket; b; b = b->prev) { /* mark free-able headers */
if(check) {
	if(b->Type != BUCKET_TYPE) Recover(enci1("system error: bad bucket pointer (type %ld) to compact",
		(long)b->Type),NULL_ENTRY);
}
		for(n = b->top, v = b->vectors+n-1; n>0; n--, v--) {
		/* assertion: if v not already free & its value or name point into
		/* the throw space, then it must be freeable, (either unused or already
		/* copied by compact_keep) */
			if(v->Type == ENTRY_TYPE && (((pp = val_ptr(v))
			   && bad_guy(pp)) ||((pp = (v)->name) && bad_guy(pp)))) {
				(b->nfree)++;
				v->Type = FREED_TYPE;
			}
		}
	}
	throw = NULL; free((char *)lower); upper = lower = NULL;
	free((char *)to_throw);
	make_ptrs(ptr);
}

static int 
bad_guy(ptr)
char *ptr;
{
	long n; char **l, **u;
	for(n = nthrow, l = lower, u = upper; n > 0; n--, l++, u++)
		if(ptr >= *l && ptr < *u)
			return(TRUE);
	return(FALSE);
}

static char *
val_ptr(object)
vector *object;
{
	switch(object->mode) {
	case LGL:
	case INT:
		return((char *)(object->value.Long)) ;
	case REAL: 
		return((char *)(object->value.Float)) ;
	case DOUBLE: 
		return((char *)(object->value.Double)) ;
	case COMPLEX: 
		return((char *)(object->value.Complex)) ;
	case CHAR: 
		return((char *)(object->value.Char)) ;
	case NAME:
		return((char *)(object->value.name)) ;
	default: 
		return((char *)(object->value.tree)) ;
	}
}

char *
S_realloc(p,new,old,size)
char *p; long new,old; int size;
{
	register char *t;
if(check) {
	if(new <= old) {
		fprintf(stderr, "realloc: warning: new (%ld) <= old (%ld)\n", new, old);
		return(p);
	}
}
	t = S_alloc(new, size);
	if(old && p)
		MEMCPY(t, p, old*size);
	if(old > scrap)free_block(p);
	return(t);
}

/* make a block for single allocation */
static char *
make_block(n)
long n;
{
	char *cblock, err_buf[100];
	S_arena *p;

	CHECK_MEM_SIZE
	if(n > max_block) {
		sprintf(err_buf, "Asked for too much memory (%ld bytes): max. allowed is %ld\n",n,max_block);
		Recover(err_buf, NULL_ENTRY);
	}
	p = ALLOC(1, S_arena); SET_BOUNDS((char *)p, sizeof(S_arena));
	p->Type = ARENA_TYPE;
	cblock = ALLOC(n, char); SET_BOUNDS(cblock, n);
	if(cur_arena) {
		S_arena *cur_prev;
if(check && cur_arena->Type!=ARENA_TYPE)
	Recover(enci2("Current arena in frame %ld has bad Type (%ld)",
	  cur_frame,(long)cur_arena->Type), NULL_ENTRY);
		cur_prev = cur_arena->prev;
		p->prev = cur_prev; p->next = cur_arena;
		cur_arena->prev = p;
		if(cur_prev)
			cur_prev->next = p;
		/* leave cur_arena alone, insert new guy just below */
	} else {
		cur_arena = p; FRAME_ARENA = (vector *)p; used = n;
	}
	p->size = n; p->used = n;
	return(p->block = cblock);
}

char *
S_calloc(n,size)
unsigned n, size;
{
	char *p = calloc(n,size);
	if(!p) Recover("Unable to obtain requested dynamic memory", NULL_ENTRY);
	return(p);
}


/* make a new arena for chopping up */
static void 
new_block()
{
	S_arena *p;
	CHECK_MEM_SIZE

	p = ALLOC(1, S_arena); SET_BOUNDS((char *)p, sizeof(S_arena));
	p->Type = ARENA_TYPE;
	cur_block = ALLOC(BLOCK_SIZE, char); SET_BOUNDS(cur_block, BLOCK_SIZE);
	if(p == (S_arena *)NULL || cur_block == (char *)NULL)
		Recover("Unable to obtain requested dynamic memory", NULL_ENTRY);
	p->prev = cur_arena; 
	if(cur_arena) {
if(check && cur_arena->Type!=ARENA_TYPE)
	Recover(enci2("Current arena in frame %ld has bad Type (%ld)",
	  cur_frame,(long)cur_arena->Type), NULL_ENTRY);
		cur_arena->next = p;
	}
	p->block = cur_block;
	p->size = BLOCK_SIZE;
	p->used = used = 0;
	cur_arena = p; cur_arena->next = NULL;
	if(storage)
		FRAME_ARENA = (vector *)cur_arena;
}

/* return the current map of allocated storage for all the frames */
vector *
S_storage(ent, arglist)
vector *ent, *arglist;
{
	S_arena *p;
	vector **vals = storage->value.tree, *val, *v;
	long nframe = storage->length, nt = 0, n = nframe, nn;
	long *alloc, *used, *where, *frames;
	UNUSED(ent);
	
	while(n--) {
		p = (S_arena *)*vals++;
		while(p) {
if(check && p->Type!=ARENA_TYPE)
	Recover(enci2("Arena in frame %ld has bad Type (%ld)",
	  cur_frame,(long)p->Type), NULL_ENTRY);
			p = p->prev; nt++;
		}
	}	
	v = alcvec(LIST,4L); vals = v->value.tree;
	*vals++ = val = alcvec(INT,nt); val->name = "allocated";
	alloc = val->value.Long;
	*vals++ = val = alcvec(INT,nt); val->name = "used";
	used = val->value.Long;
	*vals++ = val = alcvec(INT,nt); val->name = "location";
	where = val->value.Long;
	*vals = val = alcvec(INT,nt); val->name = "frame";
	frames = val->value.Long;
	n = nframe; nn = 0; vals = Arenas;
	while(n--) {
		p = (S_arena *)*vals++;
		while(p && nt) {
			*alloc++ = p->size; *used++ = p->used;
			*where++ = (long)p->block; *frames++ = nn;
			p = p->prev; nt--;
		}
		nn++;
	}	
	return(v);
}

int
check_arenas(min_brk)
char *min_brk;
{
	int bad = FALSE;
	vector **vals = storage->value.tree;
	long n = storage->length, nn= -EXTRA_FRAMES;
	S_arena *p;
	while(n--) {
		p = (S_arena *)*vals++;
		while(p) {
			if(p->block + p->size-1 > min_brk){
				fprintf(stderr,"Block at %ld in frame %ld hangs past the break\n",(long)p->block, nn);
				bad = TRUE;
			}
			p = p->prev;
		}
		nn++;
	}
	return(bad);
}

void
check_frame0()
/* if at least 10 try_to_free's have occured on frame 0 and if the total
/* block size has exceeded by Compact the amount after the last compacting,
/* make a copy of the current frame 0 and switch it in
*/
{
	long prev, n; vector *new; extern vector *Trace;
	if(!Compact || free0 < Compact)return;
	free0 = 0; n = storage->length-EXTRA_FRAMES;
	prev = set_alloc(n);
	new = copy_data(frame0,frame0);
	*frame0 = *new;
	new = Arenas[n]; Arenas[n] = Arenas[FRAME0]; Arenas[FRAME0] = new;
	new = Buckets[n]; Buckets[n] = Buckets[FRAME0]; Buckets[FRAME0] = new;
	set_alloc(FRAME0);
	new = xact_comp(frame0,".Trace");
	if(new) Trace = new;
	new = xact_comp(frame0,".Search.list");
	if(new) install_search(new);
	set_alloc(prev);
	clear_alloc(n);
}

/*
 * this routine is invoked via .C from marks(): it catenates any number of
 * strings into a vector of integers representing the ascii codes for their
 * individual characters.
 */
void 
ichar(strings, nstr, codes)
char **strings; long *nstr, *codes;
{
	long n = *nstr; char *p;
	while(n--) {
		p = *strings++;
		do
			*codes++ = *p++;
		while(*p);
	}
}

long 
menu(names, nnames)
char **names;
long nnames;
{
	long n = nnames, i = 0;
	char **pn = names, buf[80];
	while(n--)
		fprintf(stderr, "%d: %s\n", ++i, *pn++);
	while(TRUE) {
		fputs("Selection: ", stderr);
		fflush(stderr);
		fgets(buf, 80, stdin);
		n = sscanf(buf, "%ld", &i);
		if(n != 1) {
			n = nnames; pn = names;
			while(n--)
				if(!strcmp(buf, *pn++))
					break;
			if(++n) {
				i = nnames - n + 1; break;
			}
		} else
			if(i >= 0 && i <= nnames)
				break;
		fputs("Enter an item from the menu, or 0 to exit\n", stderr);
	}
	return(i);
}

static char mmbuf[] = "                                  "; long nmbuf = 32;
static char *mbuf = mmbuf;

long 
file_mtime(name)
char *name; 
{
	long n = strlen(name)+3;
	struct stat sb;

	/* following because bug in stat overwrites name */
	if(n > nmbuf) {
		long prev = set_alloc(PERM_FRAME);
		mbuf = S_alloc(n, sizeof(char));
		nmbuf = n; set_alloc(prev);
	}
	strcpy(mbuf,name);
	return((stat(mbuf,&sb)!=0)? -1 : sb.st_mtime);
}

/*
 * General purpose hash function: see S_hash.c and x_hash.c for specialized funs.
 * Table should be allocated by calling routine and hash_table, hash_length set.
 * Entries are of modes INT, REAL, CHAR or DOUBLE; all name args should
 * be cast to (char *)
 */
static x_h *plast;

int 
hash(name, mode, index, pos, hash_table, hash_length)
char *name; int mode; long *index; long *pos;
x_h **hash_table;
long hash_length;
{
	unsigned l; x_h *p; long n;
	int found = FALSE,i; complex *cx1, *cx2; vector *nn, *pn;
	switch(mode) {
	case INT:
	case LGL:
	case REAL: /* assumes floats are also valid longs (touchy) */
		n = *(long *)name;
		l = n < 0 ? -n : n;
		l = l % hash_length; break;
	case CHAR:
		l = charmash(name) % hash_length; break;
	case DOUBLE:
		l = *(long *)name ^ *(long *)(name+sizeof(long));
		l = l % hash_length; break;
	case COMPLEX:
		l = *(long *)name;
		for(i = 1; i < 4; i++)
			l ^= *(long *)(name+i*sizeof(long));
		l = l % hash_length; break;
	default:
		l = emash((vector *)name, 0) % hash_length;
	}
	*pos =  l;
	p = *(hash_table+l);
	while(p) {
		switch(mode) {
		case CHAR: found = !strcmp(name,p->name); break;
		case INT:
		case LGL:
			found= *((long *)name) == *((long *)(p->name)); break;
		case REAL:
			found= *((float *)name) == *((float *)(p->name)); break;
		case DOUBLE:
			found= *((double *)name) == *((double *)(p->name)); break;
		case COMPLEX:
			cx1 = (complex *)name; cx2 = (complex *)(p->name);
			found = cx1->re == cx2->re && cx1->im == cx2->im; break;
		default:
			nn = (vector *)name; pn = (vector *)p->name;
			found = !expr_cmp(&nn,&pn);
		}
		if(found) {
			plast = p; break;
		}
		p = p->next;
	}
	if(found)
		*index = p->index;
	return(found);
}

/*
 * enter the item identified by name the hash table:  while nominally
 * name points to a string, it can actually point to any mode, provided
 * that the same mode is used when subsequent checks are made via the
 * hash() algorithm. NBB: since the pointer is saved in the table, the
 * data pointed to must remain unchanged as long as the hash table
 * exists
 */
void 
hash_enter(name, mode,  index, pos, hash_table, hash_length)
char *name; int mode; long index, pos;
x_h **hash_table;
long hash_length;
{
	x_h  *new, *old; long temp,temp_pos;
	if(pos < 0L) {
		if(hash(name,mode,&temp,&temp_pos,hash_table,hash_length)) {
			plast->index = index;
			return;
		}
		pos = temp_pos;
	}
	old = hash_table[pos];
	new = hash_table[pos] = (x_h *)S_alloc(1L, sizeof(x_h));
	new->next = old;
	new->name = name;
	new->index = index;
}

void 
un_hash(name, mode, hash_table, hash_length)
char *name; int mode;
x_h **hash_table;
long hash_length;
{
	x_h *p, *prev;
	long index, pos;
	if(!hash(name, mode, &index, &pos, hash_table, hash_length))
		return;
	p = *(hash_table + pos); prev = NULL;
	while(p) {
		if(name_eq(name,p->name)) {
			if(prev)
				prev->next = p->next;
			else
				hash_table[pos] = p->next;
			return;
		}
		prev = p;
		p = p->next;
	}
	Recover(encs1("System error: un_hash(): cant find \"%s\"",name),NULL_ENTRY);
}

unsigned 
charmash(p)
register char *p;
{
	register int result = 0;
	while(*p) {
		result <<= 1;
		result ^= *p++;
		if(result < 0)
			result = -result;
	}
	return(result);
}

static unsigned cmash2(p, result)
register char *p; int result;
{
	while(*p) {
		result <<= 1;
		result ^= *p++;
		if(result < 0)
			result = -result;
	}
	return(result);
}

static unsigned 
emash(arg, l)
vector *arg;
unsigned l;
{
	int mode;
	long n;

	if(VOID(arg))
		return(l);
if(check) {sanity(arg,"vector to be hashed");}
	mode = arg->mode;
	if(!atomic_type(mode) && NOT_RECURSIVE(mode) && mode != NAME)
		Recover(encs1("Hashing not defined for mode \"%s\"",
			token_name(mode)), NULL_ENTRY);
	l = cmash2(token_name(mode), l);
	if((n = arg->length) < 1)
		return(l);
	switch(mode) {
	case NAME:
	case SYSTEM:
		l = cmash2(arg->value.name, l);
		break;
	case LGL:
	case INT:
		while(n--) {
			sprintf(mbuf, "%ld", arg->value.Long[n]);
			l = cmash2(mbuf, l);
		}
		break;
	case REAL:
		while(n--) {
			sprintf(mbuf, "%g", arg->value.Float[n]);
			l = cmash2(mbuf, l);
		}
		break;
	case DOUBLE:
		while(n--) {
			sprintf(mbuf, "%g", arg->value.Double[n]);
			l = cmash2(mbuf, l);
		}
		break;
	case COMPLEX:
		while(n--) {
			sprintf(mbuf, "%g", arg->value.Complex[n].re);
			l = cmash2(mbuf, l);
			sprintf(mbuf, "%g", arg->value.Complex[n].im);
			l = cmash2(mbuf, l);
		}
		break;
	case CHAR:
		while(n--) 
			l = cmash2(arg->value.Char[n], l);
		break;
	default:
		while(n--)
			l = emash(arg->value.tree[n], l);
		break;
	}
	return(l);
}

/* next prime larger than or equal to argument */
void 
nprime(nn)
long *nn;
{
	int not_done;
	long np = *nn, i, ns;

	if (np > 3) {
		np = 2*(np/2)-1;
		do {
			np += 2;
			ns = sqrt((double)np) + .5;
			not_done = FALSE;
			for(i = 3; i <= ns; i += 2)
				if(np%i==0) {
					not_done = TRUE;
					break;
				}
		} while(not_done);
	}
	*nn =  np;
}

#ifdef ATT_UNIX
#include <sys/ioctl.h>
#include <termio.h>
static struct termio noecho;
#else
#ifdef Research
#include <sys/ttyio.h>
static struct sgttyb noecho;
#else
#include <sgtty.h>
static struct sgttyb noecho;
#endif
#endif
static long init = 0;

void 
echo_on()
{
	if(!init) return;
#ifdef ATT_UNIX
	noecho.c_lflag |= ECHO;
	ioctl(0, TCSETA, &noecho);
#else
	noecho.sg_flags |= ECHO;
	ioctl(0, TIOCSETP, &noecho);
#endif
}

void 
echo_off()
{
#ifdef ATT_UNIX
	if(!init++) ioctl(0, TCGETA, &noecho);
	noecho.c_lflag &= ~ECHO;
	ioctl(0,TCSETAF, &noecho);
#else
	if(!init++) ioctl(0, TIOCGETP, &noecho);
	noecho.sg_flags &= ~ECHO;
	ioctl(0, TIOCSETP, &noecho);
#endif
}

void 
flush_input(file)
FILE *file;
{
	int fd, zero = 0;
	UNUSED(zero);

	fd = fileno(file);
#ifdef Research
	ioctl(fd,TIOCFLUSH,NULL);
#else
#ifdef ATT_UNIX
	ioctl(fd,TCFLSH,2);
#else
	ioctl(fd,TIOCFLUSH,&zero);
#endif
#endif
}

static char mem_msg[] = "options(\"memory\") exceeded (more than %.2f megabytes)";
static char mem_buf[80];
static int mem_term_flag = 0;

/* a suitably bullet-proof termination when out of memory */
static void 
mem_terminate()
{
	if(mem_term_flag++ == 0)
		sprintf(mem_buf, mem_msg, max_memory/1e6);
	S_terminate(mem_buf);
}

char *Empty_string = "";
static struct s_vector init_vector ; static int v_init = FALSE;

vector *
New_vector()
{
	vector *v; long i;
	S_bucket *b;
	if(cur_bucket && (v = get_header(cur_bucket))) return(v);
	b = (S_bucket *)ALLOC(1,S_bucket);
	if(!v_init) { /* once only */
		init_vector.Type = ENTRY_TYPE;
		init_vector.name = Empty_string;
		init_vector.mode = MISSING;
		v_init = TRUE;
	}
	for(i= BUCKET_SIZE, v = b->vectors; i>0; i--, v++) *v = init_vector;
	if(vectors) Buckets[cur_frame] = (vector *)b;
	b->Type = BUCKET_TYPE;
	if(cur_bucket) {
if(check && cur_bucket->Type!=BUCKET_TYPE)
	Recover(enci2("Current vector bucket in frame %ld has bad Type (%ld)",
	  cur_frame,(long)cur_bucket->Type), NULL_ENTRY);

		b->prev = cur_bucket; cur_bucket->next = b;
	}
	b->top = 1; b->nfree = 0;
	cur_bucket = b;
	v =b->vectors; v->Type = ENTRY_TYPE;
	return(v);
}

static vector *
get_header(b)
S_bucket *b;
{
if(check && b->Type!=BUCKET_TYPE)
	Recover(enci2("Vector bucket in frame %ld has bad Type (%ld)",
	  cur_frame,(long)b->Type), NULL_ENTRY);
	if(b->top < BUCKET_SIZE) return(b->vectors + (b->top)++);
	else if(b->nfree>0) {
		vector *v; long i;
		for(i = b->top, v = b->vectors+i-1; i>0; i--,v--)
			if(v->Type == FREED_TYPE) {
				*v = init_vector;
				b->nfree--;
				return(v);
			}
		/* impossible */
		Recover("Internal error in allocating new vector",NULL_ENTRY);
	}
	else if(b->prev) return(get_header(b->prev)); /* should really do a move-to-front here*/
	return(NULL_ENTRY);
}


free_header(v)
vector *v;
{
	long i; S_bucket *b;
	for(b = cur_bucket; b; b = b->prev)
		if((i = v - b->vectors)>=0 && i < b->top ) {/* found */
			(b->nfree)++;
			v->Type = FREED_TYPE;
			break;
		}
}

static int
in_bucket(p, nframe)
vector *p; long nframe;
{
	S_bucket *b; long i;
	if(nframe == cur_frame) b = cur_bucket;
	else if(nframe >= vectors->length)return(FALSE);
	else b = (S_bucket *)Buckets[nframe];
	while(b) {
		i = p - b->vectors;
		if(i>=0 ) {
			if(i < b->top)return(TRUE);
			else if(i<BUCKET_SIZE) Recover(enci1("using a freed header in frame %ld",
				nframe),NULL_ENTRY);
		}
		b = b->prev;
	}
	return(FALSE);
}

int
bad_header(p)
vector *p;
{
	long nframe, n,nn;
	nframe = which_frame(p->x.frame);
	switch((int)nframe) {
	case UNKNOWN_FRAME:
		Warning("frame pointer in sanity check is not an active frame",NULL_ENTRY);
		break;
	case TO_FRAME0: nframe = FRAME0; goto check_it;
	case NO_FRAME: nframe = cur_frame;
	default:
	check_it: if(in_bucket(p,nframe))return(FALSE);
	}
	for(n = 0, nn = -EXTRA_FRAMES; n < vectors->length; n++, nn++)
		if(nn!=nframe && in_bucket(p,nn)) {
			if(nn <= Frames->length)return(FALSE);
			else Recover(enci1("using header from a cleared frame (%ld)",
				nn),NULL_ENTRY);
		}
	Warning("header in sanity check is not from bucket allocation",NULL_ENTRY);
	return((char *)p<min_alloc || (char *)p>max_alloc);
}

