#include <stdio.h>
#include "S.h"

char *S_calloc();

#define NULL 0

void fft(), fft2();

struct complex {
	double re;
	double im;
};
/* version with timing */
#ifdef TIMING
#include <sys/types.h>
#include <sys/times.h>
void fft(z, ntot, n, nspan, isn)
struct complex z[];
long *ntot, *n, *nspan, *isn;
{
	struct tms t1, t2;
	double x;

	times(&t1); x = t1.tms_utime + t1.tms_stime;
	fft2(z, (int)*ntot, (int)*n, (int)*nspan, -(int)*isn);
	times(&t2); x = t2.tms_utime + t2.tms_stime - x; x *= 1000.0 / 60.0;
	fprintf(stderr, "time = %g ms = %g ms/obs\n", x, x/(*ntot));
}
#else
/* version without timing */
void fft(z, ntot, n, nspan, isn)
struct complex z[];
long *ntot, *n, *nspan, *isn;
{
	fft2(z, (int)*ntot, (int)*n, (int)*nspan, -(int)*isn);
}
#endif

void fft2(z, ntot, n, nspan, isn)
struct complex z[];
int ntot, n, nspan, isn;
{
          /*
            multivariate complex Fourier transform computed
            in place using mixed-radix fast Fourier transform
            algorithm.

            comment: this program is not as efficient as the 
                     algorithm given in

                     reference: Singleton, R. C., "An Algol
                                Procedure for the Fast Fourier
                                Transform with Arbitrary Factors",
                                CACM, Algorithm 339, 1968, pp 776.

                     on which it is based.  However, it is more
                     general in the sense that it will compute
                     the inverse transform without modification.

            input: z = ntot dimensional complex vector containing 
                       the data.
                   ntot = number of data points.
                   n = dimension of the current variable
                   nspan = nspan/n is the spacing 
                           of consecutive data values
                           when indexing the current
                           variable.
                   isn = the sign of isn determines the
                         sign of the complex exponential,
                         and the magnitude of isn is
                         usually one.

            comment: The data are stored in array z[ntot],
                     following the usual arrange-
                     ment for indexing multivariate data in
                     a single dimensional array, e.g. z[i][j][k]
                     is stored as
                          z[i*n2*n3+j*n3+k],
                     for
                          i = 0, ..., n1-1
                          j = 0, ..., n2-1
                          k = 0, ..., n3-1.
                     The value for nspan for the lth variate
                     of a p-variate transform is
                          nspan = nl* ...*np
                     where
                          n = nl
                          ntot = n1*n2* ... *np.

            comment: A 3-variate transform with z[n1][n2][n3]
                     and z[n1][n2][n3] is computed by
                          fft(a, b, n1*n2*n3, n1, n1*n2*n3, 1);
                          fft(a, b, n1*n2*n3, n2, n2*n3, 1);
                          fft(a, b, n1*n2*n3, n3, n3, 1);
                     in any order.  For a single variable
                          ntot=n=nspan
                     and the transform returns
                          sum k=0 to ntot-1 {(z[k])*exp(i*2*pi*j*k/ntot)}
                     for 
                          j = 0, 1, ..., ntot-1.

            comment: When transforming data to the frequency
                     domain (isn = +1), fft yields
                           w(freq) = sum (k=0 to n-1) x(k)*exp(i*j*freq)
                     where freq represents one of the n
                     frequencies from 0 to 2*pi.
                     When transforming the Fourier coefficients
                     back to the time domain (isn = -1), fft
                     yields
                          n * z(j)
                     for j = 0, ..., n-1.
          */

          /* work variables */

     double rad, s72, c72, s120, radf, *at, *ck, *bt, *sk, sd, cd, c1, c2, c3,
            s1, s2, s3, akp, akm, ajp, ajm, bkp, bkm, bjp, bjm,
            aa, bb, ak, bk, aj, bj;
     double sin(), cos();
     int *nfac, inc, nt, ks, kspan, nn, jc, i, jf, m, j, jj, k, kt,
         *np, kk, k1, k2, k3, k4, kspnn, maxf;
     unsigned nvec;

#ifdef lint
	c2 = c3 = s2 = s3 = k3 = 0;
	NONEXISTENT(c2,c3,s2,s3,k3);
#endif

     if (n < 2)
          return;

     nfac = CALLOC(20, int);
     if (nfac == NULL) {
          fprintf(stderr, "\nerror 1\n");
          goto l43;
     }

     rad = 6.28318530717958647692528e00;               /* 2 * pi */
     s120 = .8660254037844386467e00;                   /* sqrt(3)/2 */
     s72 = rad / 5.0;
     c72 = cos(s72);
     s72 = sin(s72);
     inc = isn;

     if (isn < 0) {
          s72 = -s72;
          s120 = -s120;
          rad = -rad;
          inc = -inc;
     }
     nt = inc * ntot;
     ks = inc * nspan;
     kspan = ks;
     nn = nt - inc;
     jc = ks/n;
     radf = rad * jc * 0.5;
     jf = 0;
     nfac [0] = 1;
     k1 = 0;

          /* determining factors of n */

     for (m=0, k=n; (k/16) * 16 == k; k /= 16) {
          m++;
          k1++;
          nfac[m] = 4;
     }
     j = 2;
     jj = 4;
l:   while ((i = k/jj) * jj == k) {
          m++;
          nfac[m] = j;
          k = i;
     }
     if (j == 2)
          j = 3;
     else
          j += 2;
     jj = j*j;
     if (jj < k)
          goto l;

     kt = m;

     for (j=2; j<=k;) {
          while ((i = k/j) * j == k) {
               m++;
               nfac[m] = j;
               k = i;
          }
          if (j == 2)
               j = 3;
          else
               j += 2;
     }

     i = m - kt;

          /* sets maxf to the largest factor + 1 */

     if (nfac[kt] > nfac[m])
          maxf = (nfac[kt] > nfac[1]) ? nfac[kt]:nfac[1];
     else
          maxf = (nfac[m] > nfac[1]) ? nfac[m]:nfac[1];
     maxf++;

          /* get remaining parts of squared factors */

     for (j = kt; j >=1; j--) {
          m++;
          nfac[m] = nfac[j];
     }

          /* at the conclusion of the above steps
                 kt = number of squared factors
                 m = number of factors 
                 *nfac = vector of factors
                 maxf = largest factor
                 i = number of non-squared factors
          */

          /* setting up work arrays */

     nvec = maxf;
     at = CALLOC(nvec, double);
     ck = CALLOC(nvec, double);
     bt = CALLOC(nvec, double);
     sk = CALLOC(nvec, double);
     jj = 1;
     if (i > 1) {
          for (j=1; j <= i; j++)
               jj *= nfac[kt+j];
     }
     nvec = (jj>m+4*k1) ? (jj+1):(m+4*k1+2);
     np = CALLOC(nvec, int);

          /* error check */

          if (at == NULL || ck == NULL || bt == NULL || sk == NULL || 
               np == NULL) {
               fprintf(stderr, "\nerror 2\n");
               goto l42;
          }


          /* compute Fourier transform */

     i = 0;
l1:  sd = radf / kspan;
     cd = 2.0 * sin(sd) * sin(sd);
     sd = sin(sd * 2.0);
     kk = 0;
     i++;

          /* transform for factor of 2 */

     if (nfac[i] != 2)
          goto l6;
     kspan /= 2;
     k1 = kspan + 1;
l2:  k2 = kk + kspan;
     ak = z[k2].re;
     bk = z[k2].im;
     z[k2].re = z[kk].re - ak;
     z[k2].im = z[kk].im - bk;
     z[kk].re += ak;
     z[kk].im += bk;
     kk = k2 + kspan;
     if ( kk < nn)
          goto l2;
     kk -= nn;
     if (kk < jc)
          goto l2;
     if (kk >= kspan)
          goto l20; 
l3:  c1 = 1.0 - cd;
     s1 = sd;
l4:  k2 = kk + kspan;
     ak = z[kk].re - z[k2].re;
     bk = z[kk].im - z[k2].im;
     z[kk].re += z[k2].re;
     z[kk].im += z[k2].im;
     z[k2].re = c1*ak - s1*bk;
     z[k2].im = s1*ak + c1*bk;
     kk = k2 + kspan;
     if (kk < nt-1)
          goto l4;
     k2 = kk - nt;
     c1 = -c1;
     kk = k1 - k2 - 1;
     if ( kk > k2)
          goto l4;
     ak = c1 - (cd*c1 + sd*s1);
     s1 += (sd*c1-cd*s1);
     c1 = 2.0 - (ak*ak+s1*s1);
     s1 = c1*s1;
     c1 = c1*ak;
     kk += jc;
     if ( kk < k2)
          goto l4;
     k1 += 2*inc;
     kk = (k1 - kspan)/2 + jc;
     if (kk < 2*jc)
          goto l3;
     goto l1;

          /* transform for factor of 3 (optional code) */

l5:  k1 = kk + kspan;
     k2 = k1 + kspan;
     ak = z[kk].re;
     bk = z[kk].im;
     aj = z[k1].re + z[k2].re;
     bj = z[k1].im + z[k2].im;
     z[kk].re = ak + aj;
     z[kk].im = bk + bj;
     ak -= 0.5 * aj;
     bk -= 0.5 * bj;
     aj = (z[k1].re - z[k2].re) * s120;
     bj = (z[k1].im - z[k2].im) * s120;
     z[k1].re = ak - bj;
     z[k1].im = bk + aj;
     z[k2].re = ak + bj;
     z[k2].im = bk - aj;
     kk = k2 + kspan;
     if ( kk < nn-1)
          goto l5;
     kk -= nn;
     if (kk < kspan)
          goto l5;
     goto l16; 

          /* transform for factor of 4 */

l6:  if (nfac[i] != 4)
          goto l11;
     kspnn = kspan;
#ifdef lint
	/* apparently the value just assigned to kspnn is never used! */
	kspan = kspnn;
#endif
     kspan /= 4;
l7:  c1 = 1.0;
     s1 = 0.0;
l8:  k1 = kk + kspan;
     k2 = k1 + kspan;
     k3 = k2 + kspan;
     akp = z[kk].re + z[k2].re;
     akm = z[kk].re - z[k2].re;
     ajp = z[k1].re + z[k3].re;
     ajm = z[k1].re - z[k3].re;
     z[kk].re = akp + ajp;
     ajp = akp - ajp;
     bkp = z[kk].im + z[k2].im;
     bkm = z[kk].im - z[k2].im;
     bjp = z[k1].im + z[k3].im;
     bjm = z[k1].im - z[k3].im;
     z[kk].im = bkp + bjp;
     bjp = bkp - bjp;
     if (isn < 0) {
          akp = akm + bjm;
          akm -= bjm;
          bkp = bkm - ajm;
          bkm += ajm;
     }
     else {
          akp = akm - bjm;
          akm += bjm;
          bkp = bkm + ajm;
          bkm -= ajm;
     }
     if (s1 == 0.0) {             /*set up integer flag for zero */
          z[k1].re = akp;
          z[k1].im = bkp;
          z[k2].re = ajp;
          z[k2].im = bjp;
          z[k3].re = akm;
          z[k3].im = bkm;
     }
     else {
          z[k1].re = akp*c1 - bkp*s1;
          z[k1].im = akp*s1 + bkp*c1;
          z[k2].re = ajp*c2 - bjp*s2;
          z[k2].im = ajp*s2 + bjp*c2;
          z[k3].re = akm*c3 - bkm*s3;
          z[k3].im = akm*s3 + bkm*c3;
     }
     kk = k3 + kspan;
     if ( kk < nt)
          goto l8;
     c2 = c1 - (cd*c1 + sd*s1);
     s1 += (sd*c1 - cd*s1);
     c1 = 2.0 - (c2*c2 + s1*s1);
     s1 = c1*s1;
     c1 = c1*c2;
     c2 = c1*c1 - s1*s1;
     s2 = 2.0*c1*s1;
     c3 = c2*c1 - s2*s1;
     s3 = c2*s1 + s2*c1;
     kk -= (nt -jc);
     if (kk < kspan)
          goto l8;
     kk -= (kspan-inc);
     if (kk < jc)
          goto l7;
     if (kspan == jc)
          goto l20; 
     goto l1;

          /* transform for factor of 5 (optional code) */

l9:  c2 = c72*c72 - s72*s72;
     s2 = 2.0 * c72 * s72;
l10: k1 = kk + kspan;
     k2 = k1 + kspan;
     k3 = k2 + kspan;
     k4 = k3 + kspan;
     akp = z[k1].re + z[k4].re;
     akm = z[k1].re - z[k4].re;
     bkp = z[k1].im + z[k4].im;
     bkm = z[k1].im - z[k4].im;
     ajp = z[k2].re + z[k3].re;
     ajm = z[k2].re - z[k3].re;
     bjp = z[k2].im + z[k3].im;
     bjm = z[k2].im - z[k3].im;
     aa = z[kk].re;
     bb = z[kk].im;
     z[kk].re = aa + akp + ajp;
     z[kk].im = bb + bkp + bjp;
     ak = akp*c72 + ajp*c2 + aa;
     bk = bkp*c72 + bjp*c2 + bb;
     aj = akm*s72 + ajm*s2;
     bj = bkm*s72 + bjm*s2;
     z[k1].re = ak - bj;
     z[k4].re = ak + bj;
     z[k1].im = bk + aj;
     z[k4].im = bk - aj;
     ak = akp*c2 + ajp*c72 + aa;
     bk = bkp*c2 + bjp*c72 + bb;
     aj = akm*s2 - ajm*s72;
     bj = bkm*s2 - bjm*s72;
     z[k2].re = ak - bj;
     z[k3].re = ak + bj;
     z[k2].im = bk + aj;
     z[k3].im = bk - aj;
     kk = k4 + kspan;
     if ( kk < nn-1)
          goto l10;
     kk -= nn;
     if (kk < kspan)
          goto l10;
     goto l16;

          /* transform for odd factors */

l11: k = nfac[i];
     kspnn = kspan;
     kspan /= k;
     if (k == 3)
          goto l5;
     if (k == 5)
          goto l9;
     if (k == jf)
          goto l12;
     jf = k;
     s1 = rad / k;
     c1 = cos(s1);
     s1 = sin(s1);

          /* error check */

     if (jf >= maxf) {
          fprintf(stderr, "error in ck, sk, at, bt size\n");
          fprintf(stderr, "jf = %d  maxf = %d\n",jf,maxf);
          goto l42;
     }

     ck[jf] = 1.0;
     sk[jf] = 0.0;
     j = 1;
     do {
          ck[j] = ck[k]*c1 + sk[k]*s1;
          sk[j] = ck[k]*s1 - sk[k]*c1;
          k--;
          ck[k] = ck[j];
          sk[k] = -sk[j];
          j++;
     } while (j < k);
l12: k1 = kk;
     k2 = kk + kspnn;
     aa = z[kk].re;
     bb = z[kk].im;
     ak = aa;
     bk = bb;
     j = 1;
     k1 += kspan;
l13: k2 -= kspan;
     j++;
     at[j] = z[k1].re + z[k2].re;
     ak += at[j];
     bt[j] = z[k1].im + z[k2].im;
     bk += bt[j];
     j++;
     at[j] = z[k1].re - z[k2].re;
     bt[j] = z[k1].im - z[k2].im;
     k1 += kspan;
     if (k1 < k2)
          goto l13;
     z[kk].re = ak;
     z[kk].im = bk;
     k1 = kk;
     k2 = kk + kspnn;
     j = 1;
l14: k1 += kspan;
     k2 -= kspan;
     jj = j;
     ak = aa;
     bk = bb;
     aj = 0.0;
     bj = 0.0;
     k = 1;
l15: k++;
     ak += at[k]*ck[jj];
     bk += bt[k]*ck[jj];
     k++;
     aj += at[k]*sk[jj];
     bj += bt[k]*sk[jj];
     jj += j;
     if (jj > jf)
          jj -= jf;
     if (k < jf)
          goto l15;
     k = jf - j;
     z[k1].re = ak - bj;
     z[k1].im = bk + aj;
     z[k2].re = ak + bj;
     z[k2].im = bk - aj;
     j++;
     if (j < k)
          goto l14;
     kk += kspnn;
     if (kk < nn)
          goto l12;
     kk -= nn;
     if (kk < kspan)
          goto l12;

          /* multiplying by rotation factor (except for factors of 2 and 4) */

l16: if (i == m)
          goto l20;
     kk = jc;
l17: c2 = 1.0 - cd;
     s1 = sd;
l18: c1 = c2;
     s2 = s1;
     kk += kspan;
l19: ak = z[kk].re;
     z[kk].re = c2*ak - s2*z[kk].im;
     z[kk].im = s2*ak + c2*z[kk].im;
     kk += kspnn;
     if (kk < nt)
          goto l19;
     ak = s1*s2;
     s2 = s1*c2 + c1*s2;
     c2 = c1 * c2 - ak;
     kk -= (nt - kspan);
     if (kk < kspnn)
          goto l19;
     c2 = c1 - (cd*c1 + sd*s1);
     s1 += (sd*c1 - cd*s1);
     c1 = 2.0 - (c2*c2 + s1*s1);
     s1 = c1*s1;
     c2 = c1*c2;
     kk -= (kspnn - jc);
     if (kk < kspan)
          goto l18;
     kk -= (kspan - jc - inc);
     if (kk < 2*jc)
          goto l17;
     goto l1;

          /* permute results to normal order---done in two stages */

          /*permutation for square factors of n */

l20: np[1] = ks;
     if (kt == 0)
          goto l28;
     k = 2*kt + 1;
     if ( m < k)
          k--;
     j = 1;
     np[k+1] = jc;
     do {
          np[j+1] = np[j]/nfac[j];
          np[k] = np[k+1]*nfac[j];
          j++;
          k--;
     } while (j < k);
     k3 = np[k+1];
     kspan = np[2];
     kk = jc;
     k2 = kspan;
     j = 1;
     if (n != ntot)
          goto l24;

          /* permutation for single-variate transform (optional code) */

l21: do {
          ak = z[kk].re;
          z[kk].re = z[k2].re;
          z[k2].re = ak;
          bk = z[kk].im;
          z[kk].im = z[k2].im;
          z[k2].im = bk;
          kk += inc;
          k2 += kspan;
     } while (k2 < ks-1);
l22: k2 -= np[j];
     j++;
     k2 += np[j+1];
     if ( k2 >= np[j])
          goto l22;
     j=1;
l23: if (kk < k2)
          goto l21;
     kk += inc;
     k2 += kspan;
     if (k2 < ks-1)
          goto l23;
     if (kk < ks-1)
          goto l22;
     jc = k3;
     goto l28;

          /* permutation for multivariate transform */

l24: k = kk + jc;
l25: ak = z[kk].re;
     z[kk].re = z[k2].re;
     z[k2].re = ak;
     bk = z[kk].im;
     z[kk].im = z[k2].im;
     z[k2].im = bk;
     kk += inc;
     k2 += inc;
     if ( kk < k)
          goto l25;
     kk += ks - jc;
     k2 += ks - jc;
     if (kk < nt-1)
          goto l24;
     k2 -= nt - kspan;
     kk -= nt - jc;
     if (k2 < ks-1)
          goto l24;
l26: k2 -= np[j];
     j++;
     k2 += np[j+1];
     if (k2 >= np[j])
          goto l26;
     j = 1;
l27: if (kk < k2)
          goto l24;
     kk += jc;
     k2 += kspan;
     if (k2 < ks-1)
          goto l27;
     if (kk < ks-1)
          goto l26;
     jc = k3;
l28: if (2*kt+1 >= m)
          goto l42;
     kspnn = np[kt+1];

          /* permutation for square free factors of n */

     j = m - kt;
     nfac[j+1] = 1;
l29: nfac[j] = nfac[j] * nfac[j+1];
     j--;
     if (j != kt)
          goto l29;
     kt++;
     nn = nfac[kt] - 1;

          /* error check */

     if ( nn >= nvec) {
          fprintf(stderr, "error in np size\n");
          fprintf(stderr, "nn = %d  nvec = %d\n",nn, nvec);
          goto l42;
     }

     jj = j = 0;
     goto l32;
l30: jj -= k2;
     k2 = kk;
     k++;
     kk = nfac[k];
l31: jj += kk;
     if (jj >= k2)
          goto l30;
     np[j] = jj;
l32: k2 = nfac[kt];
     k = kt + 1;
     kk = nfac[k];
     j++;
     if (j <= nn)
          goto l31;

          /* determine the permutation cycles of length greater than one */

     j = 0;
     goto l34;
l33: k = kk;
     kk = np[k];
     np[k] = -kk;
     if (kk != j)
          goto l33;
     k3 = kk;
l34: j++;
     kk = np[j];
     if (kk < 0)
          goto l34;
     if (kk != j)
          goto l33;
     np[j] = -j;
     if (j != nn)
          goto l34;
     maxf = inc * maxf;

          /* reordering a and b according to the permutation cycles */

     goto l41;
l35: j--;
     if (np[j] < 0)
          goto l35;
     jj = jc;
l36: kspan = jj;
     if ( jj > maxf)
          kspan = maxf;
     jj -= kspan;
     k = np[j];
     kk = jc * k + i + jj - 1;
     k1 = kk + kspan;
     k2 = -1;
l37: k2++;
     at[k2] = z[k1].re;
     bt[k2] = z[k1].im;
     k1 -= inc;
     if (k1 != kk)
          goto l37;
l38: k1 = kk + kspan;
     k2 = k1 - jc * (k + np[k]);
     k = -np[k];
l39: z[k1].re = z[k2].re;
     z[k1].im = z[k2].im;
     k1 -= inc;
     k2 -= inc;
     if (k1 != kk)
          goto l39;
     kk = k2;
     if (k != j)
          goto l38;
     k1 = kk + kspan;
     k2 = -1;
l40: k2++;
     z[k1].re = at[k2];
     z[k1].im = bt[k2];
     k1 -= inc;
     if (k1 != kk)
          goto l40;
     if (jj != 0)
          goto l36;
     if (j != 1)
          goto l35;
l41: j = k3 + 1;
     nt -= kspnn;
     i = nt - inc + 1;
     if (nt >= 0)
          goto l35;

l42: free((char *) at);
     free((char *) ck);
     free((char *) bt);
     free((char *) sk);
     free((char *) np);
l43: free((char *) nfac);
}
