/*
 *     X Version 11 - S Graphics Device Driver
 *
 *     Copyright 1988 by the Massachusetts Institute of Technology
 *
 *     Permission to use, copy, modify, and distribute this
 *     software and its documentation for any purpose and without
 *     fee is hereby granted, provided that the above copyright
 *     notice appear in all copies and that both that copyright
 *     notice and this permission notice appear in supporting
 *     documentation, and that the name of M.I.T. not be used in
 *     advertising or publicity pertaining to distribution of the
 *     software without specific, written prior permission.
 *     M.I.T. makes no representations about the suitability of
 *     this software for any purpose.  It is provided "as is"
 *     without express or implied warranty.
 *
 *      Enhancements, improvements Copyright 1989 by Michael M. Meyer
 *      Permission to use, copy, modify and distribute is free granted
 *      to all.
 *      Other improvements : Allen McIntosh, Steve Eick, David Lubinsky
 */

#include <X11/X.h>
#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <X11/cursorfont.h>
#include <X11/Xutil.h>
#include <signal.h>
#include <stdio.h>
#include <signal.h>
#include <math.h>

#undef ignore_this
#undef Complex
#include "S.h"
#include "device.h"

/* X11 stuff */
       /* Font Bitmaps */

#define NFONTS 4

static Pixmap          nmap = None, rmap = None;
static Display         *display = NULL;
static Window          rootWindow, window;
static Cursor          cursor_readpen = None, cursor_normal = None;
static GC              xgc;
static int             screen;
static int             char_color = -1;
static int             pen_color = -1;
static Font            font,fonts[NFONTS];
static XFontStruct     *fontstruct;
static int             blackpixel, whitepixel;
int font_width,font_height,font_widths[NFONTS],font_heights[NFONTS],currfont;

       /* Colors */

#define MAX_COLORS     128

static char *color_names[MAX_COLORS];
static unsigned long color_cookies[MAX_COLORS];
static int n_colors = 2;

#define background_color       color_cookies[0]
#define foreground_color       color_cookies[1]

       /* Definitions for Shading Patterns */

#define Bitmap_width 16
#define Bitmap_height 16
typedef char Shade16[32];
static Shade16 Shades[] = {
#include "x11texture.h"
};

#define NSHADES        sizeof(Shades)/sizeof(Shade16)

Pixmap ShadePixmap[MAX_COLORS+1];

/* End X11 stuff */

#define DNAME x11
#include "disp_list.h"

static void readpen();
/* static void ColorFonts(); djl */
static void ColorShade();
static void FreeShade();
static void SetOp();
static int processOrdinaryEvent();
static void NewColor();
static void GetColors();
static void GetTextures();
static void BWColors();
static void GetNumColors();
static char *dupstr();

/*
 *     Tunable Defaults
 */

#define WINDOW_X_ORIGIN        0               /* default window upper left */
#define WINDOW_Y_ORIGIN        0
#define WINDOW_WIDTH   400
#define WINDOW_HEIGHT  400



static int windowWidth = WINDOW_WIDTH, windowHeight = WINDOW_HEIGHT;
static int trueWidth = WINDOW_WIDTH, trueHeight = WINDOW_HEIGHT;
static int ask;
static double pixelAspectRatio;
static double xMapFudge = 1.0;
static double yMapFudge = 1.0;
#define xUserToRaster(i)       xMapFudge*((i)*am(37)+am(36)+0.5)
#define yUserToRaster(i)       yMapFudge*(windowHeight-((i)*am(39)+am(38)+0.5))


vector *DNAME(iask,xgeom,xreverse,xdisplay,xcloseDisplay)
       long *iask;
       char **xgeom;     /* The X geometry spec */
       long *xreverse;
       char **xdisplay;  /* Name of display device */
       long *xcloseDisplay;    /* Force close of display first */
{
       device *d, *new_device();
       int alarmCatcher();
       double pixelWidth(), pixelHeight();
       int i;

       ask = *iask;

       signal(SIGALRM,alarmCatcher);
	d_DNAME.routines[DEV_menu] = NULL;	/* no graphical menus yet */
        set_device(new_device(&d_DNAME, 0L)->which);
       ALARM_NO;
       if(display == NULL || *xcloseDisplay) {
               if( *xcloseDisplay )
                       closeX11(FALSE);
               openX11(xgeom,xreverse,xdisplay);
       } else {
               XMapWindow(display,window);
       }

       for( i=0 ; i<40 ; i++ ) am(i) = 0.0;

       am(20) = 6.0;           /* character size in rasters */
       am(21) = 13.0;

       am(22) = 0.0;           /* display extents */
       am(23) = windowWidth;
       am(24) = 0.0;
       am(25) = windowHeight;

       am(26) = 0.5;           /* character addressing offsets */
       am(27) = 0.5;

       am(28) = pixelWidth();  /* raster size in inches */
       am(29) = pixelHeight();

       am(30) = X11;

       am(1) = 1.0;            /* variable size characters */
       am(31) = 1.0;           /* allow character rotation */

       F77_SUB(defltz)();
       ALARM_YES;
}
static void
setfont(f)
     int f;
{
  if (f < 0) f = 0;
  if (f >= NFONTS) f = NFONTS -1;
  font = fonts[f];
  font_width=font_widths[f];
  font_height=font_heights[f];
  XSetFont(display,xgc,font);
}    

/* Different Line Styles */

#define NUMD 9
#define D31   2
#define D3431 4
#define D44   2
#define D47   2
#define D123  3
#define D42   2
#define D1234 4
#define D414  3
#define D444  3

int dash_list_length[NUMD] = {
  D31, D3431, D44, D47, D123, D42, D1234, D414, D444};

unsigned char d31[D31] = {3,1} ;
unsigned char d3431[D3431] = {3,4,3,1};
unsigned char d44[D44] = {4,4};
unsigned char d47[D47] = {4,7};
unsigned char d123[D123] = {1,2,3};
unsigned char d42[D42] = {4,2};
unsigned char d1234[D1234] = {1,2,3,4};
unsigned char d414[D414] = {4,1,4};
unsigned char d444[D444] = {4,4,4};

unsigned char *dash_list[NUMD] = {
  d31, d3431, d44, d47, d123, d42, d1234, d414, d444};


int dash_offset= 0;


static void USRamodes(ii)
     int ii;
{
       int j;
       switch(ii) {
       case 8:
               j = ((int)am(8)-1)%10;
               if(j == 0) {
                       XSetLineAttributes(display,xgc,0,LineSolid,
                               CapButt,JoinMiter);
               } else {
                       XSetLineAttributes(display,xgc,0,LineOnOffDash,
                               CapButt,JoinMiter);
                       XSetDashes(display, xgc, dash_offset, dash_list[j-1],
                               dash_list_length[j-1]);
               }
               break;
       case 10:                /* col= */
               j = am(10);
               NewColor(j);
               break;
       case 18:
	       if (am(18) > 2) {
		 am(18)=2;
		 fprintf(stderr,"Maximum character expansion is 2\n");
	       }
	       if (am(18) < 0.5){
		 am(18)=0.5;
		 fprintf(stderr,"Minimum character expansion is 0.5\n");
	       }
	       setfont((int)(2*am(18)-0.5)); /* char expansion */
	       break;
#if 0
       case 9:
               fprintf(stderr,"am(9) is %d\n", (int)am(9));/* line width */
               break;
       case 15:
               fprintf(stderr,"am(15) is %d\n", (int)am(15));/* plot char */
               break;
       case 18:
               fprintf(stderr,"am(18) is %d\n", (int)am(18));/* char expansion
*/
               break;
#endif
    }
}

#define ROTATE (rrkey&1)
#define REVERSE        (rrkey&2)

static void USRtext(x,y,str,adj)
float *x;
float *y;
char *str;
float adj;
{
       int col;
       char *s;
       double srt, nm1;
       int i, ix, iy, ix0, iy0, ix1, iy1, inc, n, rrkey, length;

       processEvents();
       updateClipRegion();
       n = strlen(str);
       ix = xUserToRaster(*x);
       iy = yUserToRaster(*y);
       srt = am(14);
       col = am(10);
       rrkey = quadrant(srt);

/*       ColorFonts(col); djl */
       if( ! ROTATE ) {
	 length = n*font_width;
	 ix0 = ix-adj*length;
	 ix1 = ix0+length;
	 iy0 = iy + font_height/2;
	 iy1 = iy+ font_height/2;
	 rotate(&ix0,&iy0,&ix1,&iy1,ix,iy,srt);
       }
       else {
	 length = n*font_height;
	 iy0 = iy-adj*length;
	 iy1 = iy0+length;
	 ix0 = ix - font_width/2;
	 ix1 = ix - font_width/2;
	 rotate(&ix0,&iy0,&ix1,&iy1,ix,iy,srt-90.0);
       }

       if (srt == 0.0){
	 XDrawString(display,window,xgc,ix0,iy0,str,n);
       } else if( n<=1 ) {
	 drawchar(ix,iy,str[0],ROTATE);
       }
       else {
	 s = str;
	 inc = 1;
	 nm1 = n-1;
	 for( i=0 ; i<n ; i++ ) {
	   ix = ix0+(ix1-ix0)*(i/nm1);
	   iy = iy0+(iy1-iy0)*(i/nm1);
	   drawchar(ix,iy,*s,ROTATE);
	   s += inc;
	 }
       }
       flushX11();
}

static void USRmrks(xx, yy, n) /* THis is really the points command.  Bates
calls it marks */
     float *xx, *yy;
     int n;
{
       pntsX11(xx,yy,n);
}

static void USRlins(x,y,n)
float *x;
float *y;
int n;
{
       XPoint *points;
       int i, col, m;

       processEvents();
       updateClipRegion();
       col = am(10);
       NewColor(col);  /* not necessary, but prudent */
       if( n<=1 )
               return;
       points = (XPoint *)emalloc(n*sizeof(XPoint));
	m = 0;
	for( i=0 ; i<n ; i++ ) {
 		/* Server bug: multiple (?) dotted lines of zero length make a
 		 * complete mess of all dotted lines drawn thereafter.  Don't
 		 * allow drawing of any.
 		 */
 		points[m].x = xUserToRaster(x[i]);
 		points[m].y = yUserToRaster(y[i]);
 		if( m == 0 || points[m].x != points[m-1].x || points[m].y != points[m-1].y )
 			m += 1;
}
 	if( m == 1 ) {
 		/* oops - all lines had zero length.  We really should draw
 		 * something, so fake it */
 		points[1].x = points[0].x+1;
 		points[1].y = points[0].y;
 		m += 1;
 	}
XDrawLines(display,window,xgc,points,m,CoordModeOrigin);
free(points);
       flushX11();
}

static void USRsegs(x0,y0,x1,y1,n)
float *x0;
float *y0;
float *x1;
float *y1;
int n;
{
       int col, i;
       XSegment *segs;

       processEvents();
       updateClipRegion();
       col = am(10);
       NewColor(col);  /* not necessary, but prudent */
       if( n<1 )
               return;
	segs = (XSegment *)emalloc(n*sizeof(XSegment));
       for( i=0 ; i<n ; i++ ) {
 		segs[i].x1 = xUserToRaster(x0[i]);
 		segs[i].y1 = yUserToRaster(y0[i]);
 		segs[i].x2 = xUserToRaster(x1[i]);
 		segs[i].y2 = yUserToRaster(y1[i]);
	}
 	XDrawSegments(display,window,xgc,segs, n);
 	free(segs);
       flushX11();
}

static void USRpoly(x,y,n)
float *x;
float *y;
int n;
{
       XPoint *points;
       int i, col;

       processEvents();
       updateClipRegion();
       col = am(10);
       NewColor(col);  /* not necessary, but prudent */
       if( n<=1 )
               return;

       points = (XPoint *)emalloc(n*sizeof(XPoint));
       for( i=0 ; i<n ; i++ ) {
               points[i].x = xUserToRaster(x[i]);
               points[i].y = yUserToRaster(y[i]);
       }

       XFillPolygon(display,window,xgc,points,n,Nonconvex,
                       CoordModeOrigin);

       XDrawLines(display,window,xgc,points,n,CoordModeOrigin);
       XDrawLine(display,window,xgc,
               points[n-1].x,points[n-1].y,
               points[0].x,points[0].y);
       free(points);
       flushX11();
}

static void
NewColor(col)
       int col;
{
       if( col == pen_color )
/**/           return;
       if( col < 0 || col >= n_colors )
               col = 1;

       pen_color = col;
       XSetForeground(display,xgc,color_cookies[col]);
       if( ShadePixmap[col] == None ) {
               XSetFillStyle(display,xgc,FillSolid);
       } else {
               XSetTile(display,xgc,ShadePixmap[col]);
               XSetFillStyle(display,xgc,FillTiled);
       }
}


/* OTHER ROUTINES CALLED BY S
 *
 * flush() brings the output up to date
 * clear() prints the current page
 * wrap() wraps up the job
 * signalled() fixes up if interrupt or other signal occurs
 */

static void USRflush()
{
  flushX11();
}

static void 
USRclear(redraw)
int redraw;
{
  if( ask && !redraw) {
    Eprintf("GO? ");
    ALARM_YES;		/* in case of exposure while we wait */
    while( getchar()!='\n' );
    ALARM_NO;
  }
  clearX11();
}

static void USRamReset()
{
 grzReset();
}

static void USRwrap()
{
  closeX11(TRUE);
}

static void USRsignalled()
{
fprintf(stderr,"Signalled\n");
}


static void USRinput(x, y, n, nmax)
     float x[], y[];
     long *n, *nmax;
{
  readpen(x,y,n,nmax);
}

static vector *USRmenu(ent,arglist)
     vector *ent, *arglist;
{
fprintf(stderr,"Menu\n");
}

static void USRhook()
{
  fprintf(stderr,"Hook\n");
}

static void USRlength()
{
  fprintf(stderr,"Length\n");
}
/*
 *     X VERSION 11 ROUTINES
 *
 */

static openX11(xgeom,xreverse,xdisplay)
  char **xgeom;
  int *xreverse;
  char **xdisplay;
{
       char *option;
       int xrev2;
       int window_x=WINDOW_X_ORIGIN,
           window_y=WINDOW_Y_ORIGIN,
           window_width=WINDOW_WIDTH,
           window_height=WINDOW_HEIGHT;
       XSizeHints              xsize_hints;
       XSetWindowAttributes    attributes;
       XGCValues               values;
       XEvent                  event;
       Visual                  *visual;
       unsigned long           blackpixel, whitepixel;
       int screen_depth;
       int i, screen_width;

               /* open the default display */

       option = *xdisplay;
       if(strcmp(option,"")==0)
               option = NULL;
       if((display=XOpenDisplay(option))==NULL) {
               PROBLEM "Couldn't open X11 graphics window" RECOVER(S_void);
       }

       /*
        *      Default Screen and Root Window
        */

       screen = XDefaultScreen(display);
       rootWindow = XDefaultRootWindow(display);
       screen_width = DisplayWidth(display,screen);
       screen_depth = DisplayPlanes(display,screen);
       visual = DefaultVisual(display,screen);

       xrev2 = *xreverse;
       if (*xreverse == -1) {
        option = XGetDefault(display,"S","ReverseVideo");
       if( option == NULL )
          option = XGetDefault(display,"S","reversevideo");
       if( option == NULL )
               option = "missing!!";
        xrev2 = ((strcmp(option,"on")==0) || (strcmp(option,"yes")==0)
                 || (strcmp(option,"1")==0) || (strcmp(option,"true") == 0));
        }


       option = *xgeom;
       if ( option == NULL || strlen(option) == 0) {
               option=XGetDefault(display,"S","geometry");
               if(option == NULL)
                       option="";
       }

       if ( strlen(option) != 0)
        XParseGeometry(option,&window_x,&window_y,&window_width,&window_height);

       /*
        *      Try to figure out colors and textures.  Begin by finding
        *      out what white and black are, and assigning them to
        *      foreground and background.
        */

       blackpixel = BlackPixel(display,screen);
       whitepixel = WhitePixel(display,screen);

      if (xrev2){
       background_color = blackpixel;
       foreground_color = whitepixel;
       }
       else {
        background_color = whitepixel;
       foreground_color = blackpixel;
       }
       /* Find out how many "colors" the X options database says we have.
        *
        * Based on the screen depth and whatever "visual" says about the
        * screen, set up the mapping between the integers 0:n_colors-1
        * and pixel values.  We have to wait to figure out textures until
        * we get the window open.
        *
        * Also, decide on the logical op to use to paint things on the
        * screen.  This is easy in black and white - just use Xand or Xor,
        * depending on the background color.  In color, it's not so clear
        * what to do.  The "right" thing to do is Xcopy.  This can wipe
        * out pieces of lines and text when there is partial overlap.
        * Using rotated fonts for text solves the text problem; it's
        * not clear what to do about the line problem.
        *
        * Looking at visual->class is a hack recommended by the X
        * documentation - doing this right would be painful.
        */

       GetNumColors();
       if( screen_depth == 1) {
                       /* Monochrome - easy */
               SetOp(xrev2, whitepixel, blackpixel, &values);
               BWColors();
       } else
       switch(visual->class) {         /* THIS MAY BREAK SOMEDAY */
       case PseudoColor:
       case StaticColor:
       case DirectColor:
       case TrueColor:
               values.function = GXcopy;
               GetColors();
               break;
       case GrayScale:
       case StaticGray:
               SetOp(xrev2, whitepixel, blackpixel, &values);
               GetColors();
               break;
       default:
               /* HUH??? */
               values.function = GXcopy;
               BWColors();
               break;
       }


       /*
        *      Try to create a simple window.
        *      Want to know about exposures
        *      and window-resizes and locations
        */

       attributes.event_mask = ButtonPressMask
                             | ExposureMask
                             | StructureNotifyMask;
       attributes.background_pixel = background_color;
       attributes.border_pixel = blackpixel;

       if((window = XCreateWindow(display,rootWindow,
               window_x,window_y,
               window_width, window_height, 1,
               DefaultDepth(display,screen),
               InputOutput, visual,
               CWEventMask | CWBackPixel | CWBorderPixel, &attributes ))==0) {
                      PROBLEM "Can't Create X11 graphics window" RECOVER(S_void);
               }
       XChangeProperty(display,window,XA_WM_NAME,XA_STRING,
               8,PropModeReplace,"S Graphics",10);

       GetTextures();

       xsize_hints.width=window_width;
       xsize_hints.height=window_height;
       xsize_hints.x=window_x;xsize_hints.y=window_y;
       xsize_hints.flags=(PSize | PPosition);
       XSetNormalHints(display,window,&xsize_hints);

 /* Need two cursors */
       cursor_readpen = XCreateFontCursor(display,XC_crosshair);
       cursor_normal = XCreateFontCursor(display,XC_pencil);
       XDefineCursor(display,window,cursor_normal);

       values.plane_mask = AllPlanes;
       values.foreground = foreground_color;
       values.background = background_color;

               /* Get Graphics Context and Reset State */

       xgc = XCreateGC( display,
                       window,
                       GCFunction|GCPlaneMask|GCForeground|GCBackground,
                       &values);

               /* Load Default  Fonts */
       fonts[0] = XLoadFont(display,"6x10");
       fonts[1] = XLoadFont(display,"6x13");
       fonts[2] = XLoadFont(display,"8x13");
       fonts[3] = XLoadFont(display,"9x15");
       currfont = 1 ;
       font_widths[0] =6; font_heights[0]=10;
       font_widths[1] =6; font_heights[1]=13;
       font_widths[2] =8; font_heights[2]=13;
       font_widths[3] =9; font_heights[3]=15;
       setfont(currfont);

               /* Map The Window */

       XMapWindow(display, window);

       XNextEvent(display,&event);
       if( event.xany.type==Expose ) {
               while( event.xexpose.count )
                       XNextEvent(display,&event);
       }
       else if( event.type==ConfigureNotify ) {
               trueWidth = windowWidth = event.xconfigure.width;
               trueHeight = windowHeight = event.xconfigure.height;
       }

       XSelectInput(display,window,
                    ExposureMask|ButtonPressMask|StructureNotifyMask);
}

#ifdef ignore_this
/* Dont need this anymore */
static void
ColorFonts(col)
       int col;
{

       if( nmap != None ) {
               if( col < 0 || col >= n_colors || col == char_color ) {
/**/                   return;
       }

       /* If col is invalid when we get here, then there are no fonts
        * allocated, and we must fake something.
        */

       if( col < 0 || col >= n_colors )
               col = 1;
       }

       if( nmap != None ) {
               XFreePixmap(display,nmap);
               XFreePixmap(display,rmap);
       }
/*       nmap = XCreatePixmapFromBitmapData(display,window,
                       Font_n_bits,Font_n_width,Font_n_height,
                       color_cookies[col], background_color,
                       DefaultDepth(display,screen));
       rmap = XCreatePixmapFromBitmapData(display,window,
                       Font_r_bits,Font_r_width,Font_r_height,
                       color_cookies[col], background_color,
                       DefaultDepth(display,screen)); */
       
       char_color = col;
}
#endif
static void
ColorShade(i, texture)
       int i;
       int texture;
{
       int prev;
       if( i < 0 || i >= n_colors )
/**/           return;
       if( texture < 0 || texture >= NSHADES )
/**/           return;

       if( ShadePixmap[i] != None )
               FreeShade(i);

       ShadePixmap[i] = XCreatePixmapFromBitmapData(display,window,
                               Shades[texture],Bitmap_width,Bitmap_height,
                               color_cookies[i], background_color,
                               DefaultDepth(display,screen));

}

static void
FreeShade(i)
       int i;
{
       if( i < 0 || i >= n_colors || ShadePixmap[i] == None )
/**/           return;
       XFreePixmap(display, ShadePixmap[i]);
       ShadePixmap[i] = None;
}

static void
SetOp(rev, whitepixel, blackpixel, v)
       int rev;
       unsigned long whitepixel, blackpixel;
       XGCValues *v;
{
       /* AllPlanes instead of 1 here?? 1/0 is correct for DEC hardware */

       if( blackpixel == 1 && whitepixel == 0 ) {
               if( rev )
                       v->function = GXand;
               else
                       v->function = GXor;
       } else
       if( blackpixel == 0 && whitepixel == 1 ) {
               if( rev )
                       v->function = GXor;
               else
                       v->function = GXand;
       } else {
               /* HUH ??? */
               v->function = GXcopy;
       }
}

#define MM_PER_INCH 25.4

static double pixelWidth()
{
       double width, widthMM;
       width = DisplayWidth(display,screen);
       widthMM = DisplayWidthMM(display,screen);
       return (widthMM/width)/MM_PER_INCH;
}

static double pixelHeight()
{
       double height, heightMM;
       height = DisplayHeight(display,screen);
       heightMM = DisplayHeightMM(display,screen);
       return (heightMM/height)/MM_PER_INCH;
}

#define ROTATE (rrkey&1)
#define REVERSE        (rrkey&2)

static rotate(x0, y0, x1, y1, xc, yc, theta)
int *x0,*y0,*x1,*y1,xc,yc;
double theta;
{
       double cos(), sin(), sintheta, costheta;
       int x, y;

       costheta = cos( PI * theta / 180.0 );
       sintheta = sin( PI * theta / 180.0 );
       x = *x0-xc;
       y = *y0-yc;
       *x0 = xc+x*costheta-y*sintheta;
       *y0 = yc+y*costheta+x*sintheta;
       x = *x1-xc;
       y = *y1-yc;
       *x1 = xc+x*costheta-y*sintheta;
       *y1 = yc+y*costheta+x*sintheta;
}

static quadrant(srt)
float srt;
{
       int isrt = srt;
       while(isrt<-180) isrt+=360;
       while(isrt>=180) isrt-=360;
       if( -80<=isrt && isrt<=80 )
               return 0;
       if( 80<isrt && isrt<=100 )
               return 3;
       if( -100<isrt && isrt<-80 )
               return 1;
       return 2;
}

static pntsX11(x,y,n)
float *x;
float *y;
int n;
{
       int col, pch, i, ix, iy;
       long lpch, ln;
       XPoint *points;

       processEvents();
       updateClipRegion();
       col = am(10);
/*       ColorFonts(col); djl */

       pch = (long) am(15);
       if( pch<32 ) {
         lpch = (long) pch;
         ln = (long)n;
         F77_SUB(dmarkz)(x,y,&ln,&lpch);
       }
/* use pixel if pch==46 */
/* Steve Eick added this code 1/27/89 */
	else if( pch==46 ) {
		points=(XPoint *) calloc((unsigned)2*n, sizeof(XPoint));
		if(points==NULL) {
			fprintf(stderr," cannot allocat memory for points\n");
			exit(1);
			}
               for( i=0 ; i< (2*n) ; i = i+2 ) {
		 ix = xUserToRaster(x[i/2]);
		 iy = yUserToRaster(y[i/2]);
		 (points+i)->x = ix;
		 (points+i)->y = iy;
		 (points+i+1)->x = ix;
		 (points+i+1)->y = iy+1;
	       }
		XDrawPoints(display,window,xgc,points,2*n,CoordModeOrigin);
		free(points); /* return memory */
	}
       else {
               for( i=0 ; i<n ; i++ ) {
                       ix = xUserToRaster(x[i]);
                       iy = yUserToRaster(y[i]);
                       drawchar(ix,iy,pch,0);
               }
       }
       flushX11();
}

static drawchar(ix,iy,ich,rot)
int ix;
int iy;
int ich;
int rot;
{
  char s[2];
  s[0]=(char)ich;
  s[1]=(char)0;
  XDrawString(display,window,xgc,ix,iy,s,1);
  flushX11();
}


static clearX11() {
       XClearWindow(display,window);
       flushX11();
}


static flushX11() {
       XSync(display,0);
}


static
closeX11(unmap_only)
       int unmap_only;
{
  /* Try to clean up everything before we exit */
        int i;

       ALARM_NO;
       if( display == NULL )
/**/           return;
       if( unmap_only ) {
               XUnmapWindow(display,window);
               XSync(display,0);
       } else {
               for(i = 0; i < n_colors; i++ ) {
                       if( ShadePixmap[i] != None ) {
                               FreeShade(i);
                       }
                       if( color_names[i] != NULL ) {
                               free(color_names[i]);
                               color_names[i] = NULL;
                       }
               }
               if( nmap != None ) {
                       XFreePixmap(display,nmap);
                       XFreePixmap(display,rmap);
                       nmap = None;
                       rmap = None;
               }
               XCloseDisplay(display);
               display = NULL;
               pen_color = -1;
               char_color = -1;
               n_colors = 2;
       }
}


static void readpen(x,y,n,nxy)
float *x, *y;
long *n, *nxy;
{
       int     i;
       int     done;
       XEvent  event;

       /* Discard pending events (in case user fidgets with mouse).
        * This code used to raise the window, but this sometimes resulted in
        * the window not being re-drawn properly (a race condition?).  If
        * we force the user to raise the window, the problem seems to go
        * away (sigh).
        */

       /*XRaiseWindow(display,window);*/
       processEvents();
       XSync(display,1);

       XDefineCursor(display,window,cursor_readpen);  /* Give a crosshair
cursor */
       for( i=0, done=0 ; i<*nxy && !done ; ) {
               XNextEvent(display,&event);
               switch(event.xany.type) {
               case Expose:
               case ConfigureNotify:
                               /* Oops - user may have gone away & done
                                * something else.  Make no attempt to
                                * optimize redraws.
                                */
                       if( processOrdinaryEvent(&event))
                               redrawDisplayList();
                       break;
               case ButtonPress:
                       switch(event.xbutton.button) {
                       case Button1:
                       case Button2:
                           x[i] = ((event.xbutton.x-am(36))/am(37))/xMapFudge;
                           y[i] = ( (windowHeight-event.xbutton.y-am(38))
/am(39) ) / yMapFudge;
                           fprintf(stderr,"\07");
                           fflush(stderr);     /* BSD line buffers this */
                           i++;
                           break;
                       default:
                           done = 1;
                           break;
                       }
               }
       }

       *n = i;
       XDefineCursor(display,window,cursor_normal);  /*  Reset the cursor */
       flushX11();
}






long F77_COM(reshap);

static grzReset()
{
       long x0, x1, y0, y1;
       extern F77_SUB(zzdevz)();
       am(22) = x0 = 0;
       am(23) = x1 = windowWidth = trueWidth;
       am(24) = y0 = 0;
       am(25) = y1 = windowHeight = trueHeight;
       xMapFudge = 1.0;
       yMapFudge = 1.0;
       F77_COM(reshap) = 1;
       F77_SUB(zzdevz)(&x0,&x1,&y0,&y1);
       updateClipRegion();
}

static int alarmCatcher()
{
       ALARM_NO;
#ifndef Berkeley
       signal(SIGALRM,alarmCatcher);
#endif
       processEvents();
       ALARM_YES;
}

static processEvents()
{
       int flag=0;
       XEvent  event;

       while( XPending(display) ) {
               XNextEvent(display,&event);
               flag |= processOrdinaryEvent(&event);
       }
       if( flag )
               redrawDisplayList();
}

static int
processOrdinaryEvent(event)
       XEvent *event;
{
       int flag = 0;
       switch(event->xany.type) {
       case Expose:
               if( event->xexpose.count == 0 )
                       flag = 1;
               break;

       case ConfigureNotify:
               trueWidth = event->xconfigure.width;
               trueHeight = event->xconfigure.height;
               xMapFudge = ((double)trueWidth)/((double)windowWidth);
               yMapFudge = ((double)trueHeight)/((double)windowHeight);
               updateClipRegion();
               flag = 1;
               break;
       }
       return flag;
}

static updateClipRegion()
{
       XRectangle cliprect;
       double drw, drh;

       if( am(65)>0.5 ) {
               cliprect.x = 0;
               cliprect.width = trueWidth;
               cliprect.y = 0;
               cliprect.height = trueHeight;
       }
       else {
               cliprect.x = xUserToRaster(am(61));
               cliprect.width = xUserToRaster(am(62))-cliprect.x+1.0;
               cliprect.y = yUserToRaster(am(64));
               cliprect.height = yUserToRaster(am(63))-cliprect.y+1.0;
       }
       XSetClipRectangles(display,xgc,0,0,&cliprect,1,Unsorted);
}

static void
BWColors()
{
       int i;

       for(i=2; i<n_colors; i++ )
               color_cookies[i] = foreground_color;
}

static void
GetColors()
{
       char *option;
       int i;
       char buf[256];
       XColor xcol;
       Colormap cmap;

       cmap = DefaultColormap(display, screen);

       for( i = 0; i < n_colors; i++ ) {
               sprintf(buf, "color%d", i);
               option = XGetDefault(display, "S", buf);
               if( option == NULL ) {
                       if( i > 1 )
                               PROBLEM "No color given for %d", i WARNING(NULL_ENTRY);
       /**/            continue;
               }
               color_names[i] = dupstr(option);
               if( !XParseColor(display, cmap, option, &xcol) ) {
                       /* need a warning? */
                       if( i > 1 ) {
                               PROBLEM "Color %d was invalid", i WARNING(NULL_ENTRY);
                               color_cookies[i] = foreground_color;
                       }
       /**/            continue;
               }
               /*fprintf(stderr,"colour %s %d from ParseColor", option,
xcol.pixel);/*DEBUG*/
               if( !XAllocColor(display, cmap, &xcol) )
                       PROBLEM "Could not allocate color %d", i WARNING(NULL_ENTRY);
               color_cookies[i] = xcol.pixel;
               /*fprintf(stderr," %d from XAllocColor\n", xcol.pixel);
               /*fflush(stderr);/*DEBUG*/
       }
}

static void
GetTextures()
{
       char *option;
       int i;
       char buf[256];
       int texture;

       for( i = 0; i < n_colors; i++ ) {
               sprintf(buf, "texture%d", i);
               option = XGetDefault(display, "S", buf);
               if( option == NULL ) {
                       FreeShade(i);
       /**/            continue;
               }
               texture = atoi(option);
               if( texture < 0 || texture >= NSHADES ) {
                       PROBLEM "Texture %d out of range", i WARNING(NULL_ENTRY);
                       FreeShade(i);
       /**/            continue;
               }
               ColorShade(i, texture);
       }
}

static void
GetNumColors()
{
       char *option;

       option = XGetDefault(display, "S", "nColors");
       if( option == NULL )
               option = XGetDefault(display, "S", "ncolors");
       if( option == NULL ) {
               n_colors = 2;
/**/           return;
       }

       n_colors = atoi(option);
       if( n_colors <= 1 ) {
               PROBLEM "ncolors must be > 1" WARNING(NULL_ENTRY);
               n_colors = 2;
/**/           return;
       } else
       if( n_colors >= MAX_COLORS ) {
               PROBLEM "ncolors must be < %d", MAX_COLORS WARNING(NULL_ENTRY);
               n_colors = MAX_COLORS-1;
       }
}

static char *
dupstr(s)
       char *s;
{
       char *t;
       t = emalloc(strlen(s)+1);
       (void)strcpy(t, s);
       return t;
}
