#include <stdio.h>
#include "S.h"
#include "y.tab.h"
#include "options.h"

vector *do_lexlist(), *do_return(), *do_assign(), *do_fcall();
vector *do_op_list(), *do_lbrace(), *cmpx_op();
vector *alc1(), *alc2(), *alc3(), *alclist(), *alcf(), *alcuny(), *alcchar();
vector *alc_name(), *add_comment(), *mk_comment(), *append_el(), *append_data();
int do_parse(), clean_list(), mode_lookup();

static vector *special_funs(), *e_logical_value(), *e_long_value(), *alc_str();
static long n_tok_names = 0L;
static bad_tree(); static int add_else();
static void do_else();

/* codes for token types: defined as (LANGUAGE_TYPE +2 * NOT_RECURSIVE + 4*SPECIAL_STRUCTURE) */
int token_info[LAST_TOKEN-FIRST_TOKEN+2] = {
1 | 2 | 0,	/* NAME */
1 | 2 | 0,	/* STRING */
1 | 2 | 0,	/* LITERAL */
1 | 0 | 4,	/* COMPILED */
1 | 0 | 0,	/* LPAR */
1 | 2 | 0,	/* RPAR */
1 | 0 | 0,	/* LBRACK */
1 | 2 | 0,	/* RBRACK */
1 | 0 | 0,	/* LBRACE */
1 | 2 | 0,	/* RBRACE */
1 | 2 | 0,	/* COMMA */
1 | 2 | 0,	/* EQUAL */
1 | 2 | 0,	/* NOT */
1 | 2 | 0,	/* COLON */
1 | 2 | 0,	/* ADDOP */
1 | 2 | 0,	/* MULOP */
1 | 2 | 0,	/* LIST_SEP */
1 | 2 | 0,	/* UARROW */
1 | 2 | 0,	/* UMINUS */
1 | 2 | 0,	/* DOLLAR */
1 | 2 | 0,	/* LOGOP */
1 | 2 | 0,	/* ANDOR */
1 | 0 | 4,	/* LARROW */
1 | 2 | 0,	/* RARROW */
1 | 2 | 0,	/* SPOP */
1 | 2 | 0,	/* TBLANK */
1 | 0 | 4,	/* REPEAT */
1 | 0 | 4,	/* IF */
1 | 0 | 4,	/* ELSE */
1 | 2 | 0,	/* BREAK */
1 | 2 | 0,	/* SEMI */
1 | 2 | 0,	/* NEXT */
1 | 0 | 4,	/* WHILE */
1 | 0 | 4,	/* FOR */
1 | 2 | 0,	/* IN */
1 | 2 | 0,	/* REC_RETURN */
1 | 0 | 4,	/* RETURN */
1 | 0 | 4,	/* ARGUMENT */
1 | 2 | 0,	/* SYSTEM */
1 | 2 | 0,	/* END_OF_FILE */
1 | 0 | 0,	/* PARSE */
1 | 0 | 0,	/* SYS_FUN */
0 | 2 | 0,	/* MISSING */
1 | 0 | 4,	/* FUN_CALL */
0 | 0 | 4,	/* FUN_DEF */
1 | 2 | 0,	/* QUESTION */
1 | 2 | 0,	/* UNBALANCED */
1 | 0 | 4,	/* DOUBLE_LBRACK */
0 | 2 | 0,	/* UNKNOWN */
1 | 2 | 0,	/* DOUBLE_RBRACK */
1 | 2 | 0,	/* QUIT */
1 | 2 | 0,	/* CONTINUE */
1 | 0 | 0,	/* COMMENT_EXPR */
1 | 2 | 0,	/* ENTRY_TYPE */
1 | 0 | 4,	/* FLEX_CALL */
1 | 0 | 4,	/* DBLEARROW */
0 | 0 | 0,	/* GRAPHICS */
1 | 0 | 0,	/* ARG_LVALUE */
1 | 0 | 4,	/* INTERNAL */
1 | 0 | 4,	/* S_FUN_CALL */
1 | 0 | 4,	/* S_DATA */
1 | 0 | 0,	/* SIMILAR */
1 | 0 | 0,	/* COMMENT */
1 | 0 | 4,	/* LEFT_COMMENT */
1 | 0 | 4,	/* FRAME */
1 | 0 | 4,	/* LVALUE */
-1};


int 
do_parse()
{
	int parse_err;
	if(audit_file){ /* ensure statements bracketed by #~ */
		fputs("#~\n", audit_file);
		fflush(audit_file);	/* flush so audit process can read */
	}
	parse_err = yyparse();
	if(audit_file && yyin == stdin
		&& !parse_err && !VOID(S_ptree)
		&& S_ptree->mode != END_OF_FILE) 
			deparse(S_ptree, audit_file);
	/* yyerror will write statements with errors */
	return(parse_err);
}

vector *
do_return(ent)
vector *ent;
{
	long n;
	vector **children, *child;
	clean_list(ent);
	ent->mode = RETURN;
	if((n=ent->length)<2)return(ent);
	children = ent->value.tree;
	while(n--) { /* syntactic sugar to make return(a,...) return(a=a,..)*/
		child = *children++;
		if( child->mode == NAME ){
			if(child->name == NULL || *(child->name)=='\0')
				child->name = child->value.name;
		}
	}
	return(ent);
}

vector *
do_assign(which,assign_to,expr)
int which;
vector *assign_to, *expr;
{
	vector *ent;
	switch(assign_to->mode) {
	case CHAR: /* convert to name, and do as name */
		assign_to = alc_name(*(assign_to->value.Char));
	default: 
		ent = alcvec(which, 2L);
		ent->value.tree[0]=assign_to; ent->value.tree[1] = expr;
		break;
	}
	return(ent);
}

static vector *
special_funs(ent, fname)
vector *ent; char *fname; /* check for function calls that turn into special modes */
{
	vector *val, **from, **to, *temp;
	char *name; long n;
	vfun_ptr p;
	fun_ptr get_entry();
	if(*fname != '.')return(ent); /* all specials start with '.' */
	if(name_eq(fname,".Internal")){
		n = Nargs(ent); val = alcvec(INTERNAL,n);
		if(n<2)Recover("Second argument (the name of the C routine) missing",ent);
		from = ent->value.tree+1; to = val->value.tree;
		if((name = (*(from+1))->name)== NULL_STRING ||  *name=='\0')
			name = string_value(*(from+1));/* the entry name */
		p = (vfun_ptr)get_entry(c_symbol(name)); /* may be NULL if not found*/
		to[0] = from[0];
		temp = New_vector();
		temp->value.sys = p;/* should really be a new member of the
			/* union of values  */
		if(name)temp->name = name; to[1] = temp;
		if(n>2) to[2] = e_logical_value(from[2],ent);
		if(n>3) to[3] = e_long_value(from[3],ent);
			
	}
	else if(name_eq(fname,".S")) {
		/* .S(fname(...)), or .S(fname(...),"othername"), where
		/* othername is the name of the function whose
		/* interface routine is to be called	*/
		vector **children, *child;
		val = alcvec(S_FUN_CALL,2L);
		children = val->value.tree;
		children[0] = temp = Arg1(ent);
		switch(temp->mode) {
		case FLEX_CALL: temp = temp->value.tree[0]; /*get real call ...*/
		case FUN_CALL: temp = temp->value.tree[0]; break;
		default: Recover("invalid call to old-S function",temp);
		}
		if(Nargs(ent)>1) child = Arg2(ent);
		else child = temp;
		if(running_S)children[1] = get_S_entry(child);
		else children[1] = child;
	}
	else val=ent;
	return(val);
}

static vector *
e_long_value(ent, from)
vector *ent, *from;
{
	vector *value; long mode;
if(check) {
	sanity(ent,"vector arg to long_value");
}
	mode=ent->mode;
	if(!ent->length)Recover("No data to interpret as a number",from);
	if(mode==INT && !is_na(ent->value.Long))return(ent);
	if(LANGUAGE_TYPE(mode))return(ent);
	value = coevec(ent,INT,TRUE,PRECIOUS(ent));
	if(VOID(value) || is_na(value->value.Long))
		Recover("The index (4th argument) in a .Internal must be a number",from);
	return( value );
}
		
static vector *
e_logical_value(ent, from)
vector *ent, *from; /* used in making .Internals */
{
	vector *value; long mode;
if(check) {
	sanity(ent,"vector arg to e_logical_value in .Internal");
}
	mode=ent->mode;
	if(!ent->length)Recover("No data to interpret as logical value",from);
	if(mode==LGL && !is_na(ent->value.Long))return(ent);
	if(mode==NAME){
		char *name = ent->value.name;
		switch(*name++) {
		case 'T':
			if(!*name || !strcmp(name,"RUE"))return(blt_in_TRUE);
			break;
		case 'F':
			if(!*name || !strcmp(name,"ALSE"))return(blt_in_FALSE);
			break;
		}
	}
	if(LANGUAGE_TYPE(mode))return(ent);
	value = coevec(ent,LGL,TRUE,PRECIOUS(ent));
	if(VOID(value))
		Recover("Can't evaluate as a logical",from);
	if(is_na(value->value.Long))
		Recover("Missing value where logical needed",from);
	return(value );
}

static 
bad_tree(message,subtree)
char *message; vector *subtree;
{
	fprintf(stderr,"Error: %s in subexpression:\n",message);
	deparse(subtree,stderr);
}
#define DEFLT_LENGTH 8
vector *cons_frame; /* a special marker to make constants precious */

vector *alc1(mode, vector1)
int mode; vector *vector1;
{
	vector *a = alc_str(mode);
	*(a->value.tree) = vector1;
	a->length = 1;
	return(a);
}

static vector *
alc_str(mode)
int mode;
{
	vector *a;
	a = New_vector();
	a->value.tree = (vector **)S_alloc((long)DEFLT_LENGTH, sizeof(vector *));
	a->nalloc = DEFLT_LENGTH;
	a->mode = mode;
	return(a);
}

vector *alc2(mode,vector1,vector2)
int mode; vector *vector1, *vector2;
{
	vector *a, **e;
if(check){
	sanity(vector1,"first component to alc2");
	sanity(vector2,"second component to alc2");
}
	a=alc_str(mode);
	e = a->value.tree;
	*e = vector1;
	*(++e) = vector2;
	a->length = 2;
	return(a);
}

vector *alc3(mode,vector1,vector2,vector3)
int mode; vector *vector1, *vector2, *vector3;
{
	vector *a, **e;
if(check){
	sanity(vector1,"first component to alc3");
	sanity(vector2,"second component to alc3");
	sanity(vector3,"third component to alc3");
}
	a=alc_str(mode);
	e = a->value.tree;
	*e = vector1;
	*(++e) = vector2;
	*(++e) = vector3;
	a->length = 3;
	return(a);
}

vector *
append_el( current, which, new)
vector *current, *new; long which;
{
	vector **i, *j, *jj, *listfill;
	long n;
if(check){
	sanity(current,"current structure in append_el");
}
	if(VOID(current))
		*current= *alclist(0L);
	switch(current->mode) {
	case SYS_FUN:
	case BREAK:
	case NEXT:
	case SEMI:
	case NULL:
		Recover("Invalid mode to append new data",current);
		return(S_void);
	}
	if(which==NOARG)which=current->length;
	if(atomic_type(current->mode) && atomic_type(new->mode)){
		if(current->mode!=new->mode)new=coevec(new,current->mode,FALSE,PRECIOUS(new));
		return(append_data(current,which,new->length,(char *)new->value.Long));
		/* above is unsafe use of union */
	}
	if(atomic_type(current->mode)){
		j = alclist(2L); i=j->value.tree;
		if(PRECIOUS(current))j->x.frame = current->x.frame;
		if(PRECIOUS(new))new = copy_data(new,current->x.frame);
		else if(PRECIOUS(current))set_precious(new,current->x.frame);
		if(which){*i++ = current; *i=new;}
		else {*i++ = new; *i = current;}
		return(j);
	}
	n = (which>current->length ? which: current->length)+1;
	listfill = LANGUAGE_TYPE(current->mode) ? S_void : blt_in_NULL;
	if(current->nalloc < n ) {
		long oldlen = current->nalloc,nn;
		current->nalloc = n>oldlen?(n+oldlen+DEFLT_LENGTH):(oldlen*2);
		current->value.tree = ( vector **) S_realloc( (char *)current->value.tree,current->nalloc,oldlen,sizeof(vector *));
		nn = current->nalloc-1;
		while(nn>=current->length)
			*(current->value.tree + nn--) = listfill;
		}
	if(n>current->length+1){ /* fill in all but the last element of expanded obj. */
		long nn = n-current->length-1; vector *buf, *buf0;
		buf0 = buf = New_vector();
		*buf0 = *listfill; buf0->x.frame = current->x.frame;
		i = current->value.tree + current->length;
		while(nn--) {
			*i++ = buf;
			if(nn){buf = New_vector(); *buf = *buf0;}
		}
	}
	i = current->value.tree+which;
	if(PRECIOUS(new))j = copy_data(new,current->x.frame);
	else { if(PRECIOUS(current))set_precious(new,current->x.frame); j = new;}
	while( which++ < n){ jj= (*i); *(i++)=j; j=jj;  }
	current->length=n;
	return(current);
}

/*
 * Append (or insert) nnew items pointed to by newdata beginning
 * at the which'th position of current.  For example, use
 * which=current->length to append at the end and which=0
 * to insert before the beginning.
 */
vector *
append_data(current,which,nnew,newdata)
vector *current; long which, nnew; char *newdata;
{
	char **cold; long *lold; float *fold; double *dold; vector **vold;
	char **cout; long *lout; float *fout; double *dout; vector **vout;
	long newalloc,nold,n1,n2,nn,i; int mode;
	vector *new;
	complex *cxout, *cxold;
	if(!current)Recover("Can't append to null vector pointer",NULL_ENTRY);
	switch(current->mode) {
	case NULL: case MISSING:
		new = alcvec(LGL,0L);
		current->mode = LGL; current->value.Long  = new->value.Long;
		current->nalloc = new->nalloc; current->length =0;
		break;
	case BREAK: case NEXT: case NAME:
		Recover(encs1("Meaningless to append to mode \"%s\"",
		  token_name(current->mode)),NULL_ENTRY);
	}
	nold = current->length;
	/* n1 = number of old values before the insertion */
	/* nnew = number of insertion values */
	/* n2 = number of old values to be added after the insertion */
	/* nn = new length */
	n1=which>nold?nold:which; 
	n2=nold-n1; mode = current->mode;
	nn = which + nnew + n2;
	if(current->nalloc<nn){
		long oldlen =current->nalloc;
		newalloc=current->nalloc = nn>oldlen?(nn+oldlen+DEFLT_LENGTH):(oldlen*2);
	}
	else newalloc = 0;
	current->length = nn;
	switch(mode){
	case INT:
	case LGL:		
		lold = current->value.Long;
		if(newalloc) current->value.Long =
			(long *) S_alloc(newalloc,sizeof(long));
		lout = current->value.Long;
		if(newalloc && n1)
			MEMCPY(lout, lold, n1);
		if(n2) /* copy tail of old data before it's overwritten */
			MEMCPY(lout+which+nnew, lold+n1, n2);
		for(i=n1; i<which; i++)
			na_set(lout+i);
		MEMCPY(lout+which, newdata, nnew);
		break;
	case REAL:
		fold = current->value.Float;
		if(newalloc) current->value.Float =
			(float *)S_alloc(newalloc,sizeof(float));
		fout = current->value.Float;
		if(newalloc && n1)
			MEMCPY(fout, fold, n1);
		if(n2) /* copy tail of old data before it's overwritten */
			MEMCPY(fout+which+nnew, fold+n1, n2);
		for(i=n1; i<which; i++)
			na_set(fout+i);
		MEMCPY(fout+which, newdata, nnew);
		break;
	case DOUBLE:
		dold = current->value.Double;
		if(newalloc) current->value.Double =
			(double *) S_alloc(newalloc,sizeof(double));
		dout = current->value.Double;
		if(newalloc && n1)
			MEMCPY(dout, dold, n1);
		if(n2) /* copy tail of old data before it's overwritten */
			MEMCPY(dout+which+nnew, dold+n1, n2);
		for(i=n1; i<which; i++)
			na_set(dout+i);
		MEMCPY(dout+which, newdata, nnew);
		break;
	case COMPLEX:
		cxold = current->value.Complex;
		if(newalloc) current->value.Complex =
			(complex *) S_alloc(newalloc,sizeof(complex));
		cxout = current->value.Complex;
		if(newalloc && n1)
			MEMCPY(cxout, cxold, n1);
		if(n2) /* copy tail of old data before it's overwritten */
			MEMCPY(cxout+which+nnew, cxold+n1, n2);
		for(i=n1; i<which; i++)
			na_set(cxout+i);
		MEMCPY(cxout+which, newdata, nnew);
		break;
	case CHAR:
		cold = current->value.Char;
		if(newalloc) current->value.Char =
			(char **) S_alloc(newalloc,sizeof(char *));
		cout = current->value.Char;
		if(newalloc && n1)
			MEMCPY(cout, cold, n1);
		if(n2) /* copy tail of old data before it's overwritten */
			MEMCPY(cout+which+nnew, cold+n1, n2);
		for(i=n1; i<which; i++)
			cout[i] = "";
		MEMCPY(cout+which, newdata, nnew);
		break;
	default:
		vold = current->value.tree;
		if(newalloc) current->value.tree =
			(vector **) S_alloc(newalloc,sizeof(vector *));
		vout = current->value.tree;
		if(newalloc && n1)
			MEMCPY(vout, vold, n1);
		if(n2) /* copy tail of old data before it's overwritten */
			MEMCPY(vout+which+nnew, vold+n1, n2);
		for(i=n1; i<which; i++)
			vout[i] = blt_in_NULL;
		MEMCPY(vout+which, newdata, nnew);
		break;
	}
	return(current);
}


delete_el(ent, which)
vector *ent; long which;
{
	long mode; vector *data;
	data = coevec(ent,ANY,FALSE,FALSE);
	mode = ent->mode;
	if(!atomic_type(mode) && NOT_RECURSIVE(mode))return;
	if(!atomic_type(mode)) del_comp(data,which);
	else {
		long *l; float *f; double *d; complex *cx; char **c;
		long n = data->length;
	
		if(which < 1 || which > n )
			return;
		switch((int)mode) {
		case DOUBLE:
			for(d = data->value.Double+which-1; which < n; which++, d++)
				d[0] = d[1];
			break;
		case CHAR:
			for(c = data->value.Char+which-1; which < n; which++, c++)
				c[0] = c[1];
			break;
		case REAL:
			for(f = data->value.Float+which-1; which < n; which++, f++)
				f[0] = f[1];
			break;
		case COMPLEX:
			for(cx = data->value.Complex+which-1; which < n; which++, cx++)
				cx[0] = cx[1];
			break;
		case LGL: case INT:
			for(l = data->value.Long+which-1; which < n; which++, l++)
				l[0] = l[1];
			break;
		default:
			Recover(encs1("Unknown mode for delete_el: \"%s\"",
			  token_name((int)mode)),NULL_ENTRY);
		}
		data->length--;
	}
}

vector  *
do_fcall(ent, name)
vector *ent, *name;
{
	vector **args, *arg;
	long n; int flex;
if(check){
	sanity(ent,"argument structure in parse of function call");
	sanity(name,"function name in parse of function call");
}
	args = ent->value.tree; n = ent->length; flex = FALSE;
	while(n--){
		arg = *args++;
		if(arg->mode==NAME && name_eq("...",arg->value.name)){
			flex = TRUE;
			break;
		}
	}
	if(name->mode==CHAR)
		name = alc_name(*(name->value.Char));
	append_el(ent,0L,name);
	if(name->mode==NAME && *(name->value.name)=='.')
		ent = special_funs(ent,name->value.name);
	if(flex)ent = alc1(FLEX_CALL,ent);
	return(ent);
}


vector *
do_op_list(name,lhs,ent)
vector *ent, *lhs; char  *name;
{
	append_el(ent,0L,lhs);
	return(do_fcall(ent,alc_name(name)));
}

vector *
do_lbrace(ent)
vector *ent;
{
	long n; vector **els, *temp;
	els = ent->value.tree;
	for(n = 0; n<ent->length; n++)
		switch(els[n]->mode){
		case COMMENT_EXPR:
			temp = comment_out(els[n]);
			if(temp->mode!=ELSE)break;
			do_else(els,n-1,temp);
			del_comp(ent,n+1); n--;
			break;
		case ELSE: do_else(els,n-1,els[n]);
			del_comp(ent,n+1); n--;
		}
	return(ent);
}

static void
do_else(els,n,el_expr)
vector **els, *el_expr; long n;
{
/*	long i; int done;*/
/*	for(i=n; i>=0; i--) {*/
/*		vector *ei = els[i];*/
/*		done = add_else(ei,el_expr);*/
/*		if(done)return;*/
/*		switch(ei->mode) {*/
/*		case IF: continue;*/
/*		case COMMENT_EXPR:*/
/*			if(comment_out(ei)->mode == IF)continue;*/
/*		}*/
/*		break;*/
/*	}*/
	if(add_else(els[n],el_expr))return;
	fputs("Syntax error: \"else\" without preceding \"if\" in braced list ending ",stderr);
#ifdef YYDEBUG
	yyerror(NULL_STRING, NULL_STRING);
#else
	yyerror(NULL_STRING);
#endif
	Recover(NULL_STRING, el_expr);
}

static int
add_else(expr,el_expr)
vector *expr, *el_expr;
{
	int ok = 1;
	switch(expr->mode) {
	case IF:
		if(expr->length == 2) {
			int did_it;
			vector *e1 = expr->value.tree[1];
			did_it = add_else(e1,el_expr);
			if(!did_it)
				append_el(expr,2L,el_expr->value.tree[0]);
		}
		else ok = add_else(expr->value.tree[2],el_expr);
		break;
	case FOR:
		ok = add_else(expr->value.tree[2],el_expr);
		break;
	case REPEAT:
		ok = add_else(expr->value.tree[0],el_expr);
		break;
	case WHILE:
		ok = add_else(expr->value.tree[1],el_expr);
		break;
	case LARROW:
	case DBLEARROW:
		ok = add_else(expr->value.tree[1],el_expr);
		break;
	case COMMENT_EXPR:
		ok = add_else(comment_out(expr),el_expr);
		break;
	case FUN_DEF:
		ok = add_else(expr->value.tree[expr->length-1],el_expr);
		break;
	case FUN_CALL:
		{vector *fun = expr->value.tree[0];
		if(fun->mode == NAME && op_action(fun->value.name)){
			ok = add_else(expr->value.tree[expr->length-1],el_expr);
			break;
		} /* else, error */
		}
	default:
		ok = 0;
	}
	return(ok);
}

/* remove the single empty argument in null list */

clean_list(arglist)
vector *arglist;
{
if(check){
	sanity(arglist,"argument list in clean_list");
}
	if(arglist->length==1){
		vector *arg= *(arglist->value.tree);
		if( (arg->name==NULL || *(arg->name)=='\0') &&
		  arg->mode==MISSING)arglist->length=0;
	}
}

vector *
alcf(name, vector1)
char *name; vector *vector1;
{
	vector *a = alc_str(FUN_CALL);
if(check){
	if(a->nalloc<2)Recover("System error: alcf: not deflt length", NULL_ENTRY);
}
	if(name){*(a->value.tree) = alc_name(name); a->length=1;}
	if(vector1)*(a->value.tree+(a->length++)) = vector1;
	return(a);
}

/* allocate unary operator: do constant cases; set unary names */
vector *
alcuny(name, vector1)
char *name;
vector *vector1;
{
	if(name_eq(name, "+")){
		switch(vector1->mode) {
		case LGL:
		case INT:
		case REAL:
		case DOUBLE:
		case COMPLEX:
			return(vector1);
		}
	}
	else if(name_eq(name, "-")) {
		switch(vector1->mode) {
		case LGL:
		case INT:
			*(vector1->value.Long) = -*(vector1->value.Long);
			vector1->mode = INT;
			return(vector1);
		case REAL:
			*(vector1->value.Float) = -*(vector1->value.Float);
			return(vector1);
		case DOUBLE:
			*(vector1->value.Double) = -*(vector1->value.Double);
			return(vector1);
		case COMPLEX:
			vector1->value.Complex->re = -vector1->value.Complex->re;
			vector1->value.Complex->im = -vector1->value.Complex->im;
			return(vector1);
		}
	}
	return(alcf(name, vector1));
}

vector *
cmpx_op(e1,op,e2)
char *op; vector *e1, *e2;
{
	switch(e1->mode) {
	case LGL:
	case INT: e2->value.Complex->re = (double) (*(e1->value.Long));
		break;
	case REAL: e2->value.Complex->re = (double) (*(e1->value.Float));
		break;
	case DOUBLE:e2->value.Complex->re = *(e1->value.Double);
		break;
	default: return(NULL_ENTRY);
	}
	if(*op == '-') e2->value.Complex->im *= -1.;
	return(e2);
}

vector *
alcchar(name)
char *name;
{
	vector *a = New_vector();
	char **value = (char **)S_alloc(1L,sizeof(char *));
	*value = name;
	a->mode = CHAR; a->nalloc = a->length = 1; a->value.Char = value;
	a->x.frame = cons_frame;; /* don't clobber constant */
	return(a);
}

vector *
alc_name(name)
char *name;
{
	vector *a = New_vector();
	a->mode = NAME; a->nalloc = a->length = 1;
	a->value.name = name ? name : "";
	return(a);
}

vector *
add_comment(ent1,ent2)
vector *ent1, *ent2;
{
	vector *ent, **vals; char *name;
	if(!ent1)return(ent2);
	if(!ent2)return(ent1);
if(check){
	sanity(ent1,"first arg to add_comment");
	sanity(ent2,"second arg to add_comment");
}
	if(ent1->mode == COMMENT && ent2->mode == COMMENT){
		ent = ent1;
		while(ent->x.next)ent = ent->x.next;
		ent->x.next = ent2;
		return(ent1);
	}
	ent = alcvec(COMMENT_EXPR,2L); vals = ent->value.tree; name=NULL;
	if(ent2->mode != COMMENT && ent2->name)name = ent2->name;
	if(ent1->mode != COMMENT && ent1->name)name = ent1->name;
	vals[0] = ent1; vals[1] = ent2;
	if(name) ent->name =name;
	return(ent);
}

static char *tok_names[] = {
"name",
"string",
"literal",
"compiled",
"(",
")",
"[",
"]",
"{",
"}",
",",
"=",
"!",
":",
"addop",
"*/",
"<dummy>",
"^",
"-",
"$",
"logop",
"&|",
"<-",
"->",
"sp.op",
" ",
"repeat",
"if",
"else",
"break",
";",
"next",
"while",
"for",
"in",
"recursive.return",
"return",
"argument",
"system",
"end.of.file",
"expression",
"system.function",
"missing",
"call",
"function",
"?",
"unbalanced",
"[[",
"unknown",
"]]",
"quit",
"continue",
"comment.expression",
"vector",
"call(...)",
"<<-",
"graphics",
"arg.lvalue",
"internal",
"S.call",
"S.data",
"?",
"comment",
"comment(leftover)",
"frame",
"destination",
NULL };

/* look up the  mode, return a character representation */
char *
token_name(mode)
int mode;
{
	long n;
	if(n_tok_names == 0) { /* initialize */
		char **p = tok_names;
		while(*p++)n_tok_names++;
	}
	if((n=mode-FIRST_TOKEN)<0 || n>=n_tok_names) switch(mode) {
	case  LGL:
		return( "logical");
	case  INT:
		return( "integer");
	case  REAL:
		return( "single");
	case  DOUBLE:
		return( "numeric");
	case COMPLEX:
		return("complex");
	case  CHAR:
		return( "character");
	case  ANY:
		return( "any");
	case  LIST:
		return( "list");
	case  STRUCTURE:
		return( "structure");
	case NULL:
		return( "NULL");
	case DOLLAR:
		return("$");
	default:
		return(enci1("(token(%ld))", (long)mode));
	}
	else return(tok_names[n]);
}

/*
 * convert mode name to the
 * numeric internal equivalent.
 * Used by replace_fns() and As_vector()
 */
int 
mode_lookup(name)
char *name;
{
	char **p; long n;
	switch(*name) {
	case 'n':
		if(name_eq(name,"numeric"))return(DOUBLE);
		else if(name_eq(name, "null"))return(NULL);
		else if(name_eq(name,"name"))return(NAME);
		else if(name_eq(name,"next"))return(NEXT);
		break;
	case 'c':
		if(name_eq(name, "character"))return(CHAR);
		else if(name_eq(name,"complex"))return(COMPLEX);
		else if(name_eq(name,"call"))return(FUN_CALL);
		break;
	case 'l':
		if(name_eq(name, "list"))return(LIST);
		else if(name_eq(name, "logical"))return(LGL);
		break;
	case 'r':
		if(name_eq(name,"repeat"))return(REPEAT);
		else if(name_eq(name,"return"))return(RETURN);
		break;
	case 'i':
		if(name_eq(name, "integer"))return(INT);
		else if(name_eq(name,"if"))return(IF);
		break;
	case 'd':
		if(name_eq(name, "double"))return(DOUBLE);
		break;
	case 's':
		if(name_eq(name, "single"))return(REAL);
		else if(name_eq(name, "structure"))return(STRUCTURE);
		else if(name_eq(name,"system"))return(SYSTEM);
		break;
	case 'e':
		if(name_eq(name, "expression"))return(PARSE);
		else if(name_eq(name,"else"))return(ELSE);
		else if(name_eq(name,"end-of-file"))return(END_OF_FILE);
		else if(name_eq(name,"evaluation completed"))return(REC_RETURN);
		break;
	case 'N':
		if(name_eq(name, "NULL"))return(NULL);
		break;
	case 'f':
		if(name_eq(name,"function"))return(FUN_DEF);
		else if(name_eq(name,"function call"))return(FUN_CALL);
		else if(name_eq(name,"for"))return(FOR);
		break;
	case 'b':
		if(name_eq(name, "break"))return(BREAK);
		break;
	case 'w':
		if(name_eq(name, "while"))return(WHILE);
		break;
	case '<':
		if(name_eq(name,"<-"))return(LARROW);
		else if(name_eq(name,"<<-"))return(DBLEARROW);
		break;
	case '[':
		if(name_eq(name,"["))return(LBRACK);
		else if(name_eq(name,"[["))return(DOUBLE_LBRACK);
		break;
	case '{':
		if(name_eq(name,"{"))return(LBRACE);
		break;
	case 'a':
		if(name_eq(name,"any"))return(ANY);
		else if(name_eq(name,"argument"))return(ARGUMENT);
		break;
	case 'm':
		if(name_eq(name,"missing"))return(MISSING);
		break;
	}
	/* at this point,  look linearly in the modes list */
	p = tok_names; n=257;
	while(*p){if(name_eq(name,*p))return(n); n++; p++;}
	return(UNKNOWN);
}

vector *
mk_comment(a,b)
vector *a, *b;
{
	int c1,c2; vector *ca,*cb,*cf;
	if(VOID(a))return(b);
	if(VOID(b))return(a);
	c1 = a->mode==COMMENT;
	c2 = b->mode==COMMENT;
	if(c1 && c2) {
		ca = *(a->value.tree);
		cb = *(b->value.tree);
		if(ca->mode !=CHAR ) {
			Warning("Invalid comment list",a);
			return(b);
		}		
		if(cb->mode !=CHAR ) {
			Warning("Invalid comment list",b);
			return(a);
		}
		cf = alcvec(LIST,2L);
		*(cf->value.tree) = ca;		
		*(cf->value.tree+1) = cb;
		*(a->value.tree) = combine(cf,FALSE);
		return(a);
	}
	cf = alcvec(COMMENT_EXPR,2L);
	*(cf->value.tree) = a; *(cf->value.tree+1) = b;
	return(cf);		
}

