#include <stdio.h>
#include <math.h>
#include "S.h"
#include "y.tab.h"
#include "options.h"

void pratom(), prmatrix(), prts();

static vector *incr_matrix();
static double frac();
static int lenitem(), min(), max(), round(), numstat();
static void prmatrix2(), pritem(), prnum(), zero();
static char *prcitem();

static char buf[100];
static int quote;
struct numsize {
	int sign, nsignif;
	int nleft, nright, nexp;
	char pmode, width;
};

#define MAXEQ(a,b)	a = max(a,b);
#define FASTLOG(n)	n>999?4:(n>99?3:2)
#define SLOWLOG(n)	((n)?(int)(1+floor(log10(fabs((double)(n))))+((n)<0)):1)

void
pratom(X, Value, Quote)
vector **X, **Value;
long *Quote;
{
	vector *x = *X, *val = *Value;
	long n;
	int doprint = val->length == 0;
	int ll, pl, start = 0, maxw = 0, i, perline, nline, toprint, im = 0;
	char *s;
	static struct numsize ns[2];

	if(x->mode == STRUCTURE)
		x = xact_comp(x, ".Data");
	if(x == NULL_ENTRY)
		return;
	n = x->length;
	if(n <= 0)
		return;
	quote = *Quote != 0;
	zero(ns, 2);
	window_size(&ll, &pl);
	if(!doprint) {
		for(i = 0; i < n; i++)
			maxw = max(maxw, lenitem(x, i, ns));
		s = S_alloc(n, maxw+1);
		for(i = 0; i < n; i++, s += maxw+1) {
			pritem(x, i, maxw, ns, s);
			val->value.Char[i] = s;
		}
		return;
	}
	MEANINGFUL(perline);
	for(i = 0; i < n; i++) {
		sprintf(buf, "[%d] ", i+1);
		im = strlen(buf);	/* length of index marker */
		maxw = min(ll-im, max(maxw, lenitem(x, i, ns)));
		perline = (ll - im + 1)/(maxw + 1);	/* items per line */
		nline = (i - start + 1) / perline;	/* complete lines */
		if(doprint && nline >= pl) {		/* have a page */
			toprint = pl * perline;		/* # items to print */
			while(toprint--) {
				if(toprint % perline == perline - 1) {
					sprintf(buf, "[%d] ", start+1);
					printf("%*s", im, buf);
				}
				pritem(x, start++, maxw, ns, (char *)0);
				printf("%c", toprint % perline ? ' ' : '\n');
			}
			i = start;
			maxw = 0;
			zero(ns, 2);
		}
	}
	toprint = n - start;
	for(i = 0; i < toprint; i++) {
		if(i % perline == 0) {
			sprintf(buf, "[%d] ", start+1);
			printf("%*s", im, buf);
		}
		pritem(x, start++, maxw, ns, (char *)0);
		if((i == toprint - 1) || (i % perline == perline - 1))
			putchar('\n');
		else
			putchar(' ');
	}
	fflush(stdout);
}

void
prmatrix(X, Rowlab, Collab, Quote)
vector **X;
char **Rowlab, **Collab;
long *Quote;
{
	vector *x, *dim, *find_comp();
	int ll, pl, nrow, ncol, r;

	quote = *Quote != 0;
	x = find_comp(*X, ".Data");
	dim = find_comp(*X, ".Dim");
	nrow = dim->value.Long[0]; ncol = dim->value.Long[1];
	if(nrow <= 0 || ncol <= 0) return;
	window_size(&ll, &pl);
	pl = max(pl,2);	/* at least one line per page */
	for(r=0; r<nrow; r += pl-1)
		prmatrix2(incr_matrix(x,r), min(pl-1,nrow-r), ncol, nrow, Rowlab+r, Collab, ll);
	fflush(stdout);
}

static void
prmatrix2(x, nrow, ncol, spacing, rowlab, collab, ll)
vector *x;
int nrow, ncol, spacing, ll;
char **rowlab, **collab;
{
	int r, c, *colwid, im = 0, allwid, remaining;
	struct numsize *ns;

	ns = CALLOC(2*ncol, struct numsize);
	colwid = CALLOC(ncol, int);
	for(r = 0; r < nrow; r++)
		im = max(im, strlen(rowlab[r]));
	allwid = im + 1;
	for(c = 0; c < ncol; c++) {
		colwid[c] = max(1,strlen(collab[c]));
		for(r = 0; r < nrow; r++)
			colwid[c] = max(colwid[c], lenitem(x, c*spacing + r, ns+2*c));
		allwid += colwid[c] + 1;
		if(allwid >= ll) break;
	}
	if(remaining = ncol - c) {
		ncol = c;
		if(ncol == 0) { /* first column too wide !!! */
			ncol = 1;
			im = min(im, ll/2-1);
			colwid[0] = max(ll-im-1, colwid[0]);
			remaining--;
		}
	}
	printf("%*s ", im, "");	/* col labels */
	for(c = 0; c < ncol; c++)
		printf("%*s ", colwid[c], collab[c]);
	printf("\n");
	for(r = 0; r < nrow; r++){
		printf("%*s ", im, rowlab[r]);
		for(c = 0; c < ncol; c++) {
			pritem(x, c*spacing + r, colwid[c], ns+2*c, (char *)0);
			printf("%c", c < ncol-1 ? ' ' : '\n');
		}
	}

	free((char *)ns);
	free((char *)colwid);

	if(remaining) {	/* put out remaining cols */
		printf("\n"); /* how about a new page? */
		prmatrix2(incr_matrix(x,ncol*spacing), nrow, remaining, spacing, rowlab, collab+ncol, ll);
	}
	free_header(x);
}

static char *month[] = {
	"Jan", "Feb", "Mar", "Apr", "May", "Jun",
	"Jul", "Aug", "Sep", "Oct", "Nov", "Dec"
};

void
prts(X, Quote)
vector **X;
long *Quote;
{
	vector *x, *tsp;
	int start, end, freq, n, empty, thisline, ncycle, nline;
	int ll, pl, maxw, i, j, k, kstart, kend, perline, im;
	double frag;
	static struct numsize ns[2];

	quote = *Quote != 0;
	x = find_comp(*X, ".Data");
	n = x->length;
	tsp = find_comp(*X, ".Tsp");
	start = floor(tsp->value.Double[0]);
	end = floor(tsp->value.Double[1]);
	freq = round(tsp->value.Double[2]);
	frag = frac(tsp->value.Double[0]);
	window_size(&ll, &pl);

	/* size of row labels, including ":" */
	im = 1;
	MAXEQ(im, SLOWLOG(start))
	MAXEQ(im, SLOWLOG(end))
	im++;

	/* size of column labels and data */
	zero(ns, 2);
	switch(freq) {
		case 12: maxw = 3; break;
		case 4: maxw = 2; break;
		default: maxw = SLOWLOG(freq); break;
	}
	for(i = 0; i < n; i++)
		MAXEQ(maxw, lenitem(x, i, ns))

	/* items per line -- partial cycle or exact number of cycles */
	perline = (ll - im) / (maxw + 1);
	if(freq >= 4) {
		if(perline >= freq)
			perline = freq;
	} else if(perline < n)
		perline = max(1, (perline/freq)*freq);

	/* initial empty spots and cycles per line */
	empty = round(frag*freq);
	ncycle = max(1, perline/freq);

	/* remove potential initial blank */
	if(ncycle > 1) {
		im = 1;
		MAXEQ(im, SLOWLOG(start))
		MAXEQ(im, SLOWLOG(start+((end-start)/ncycle)*ncycle))
		im++;
	}

	/* print, beginning at the start of a cycle */
	for(i = 0; i < freq; i += perline) {
		nline = 0;
		for(j = start; j <= end; j += ncycle) {
			thisline = min(n+empty, min(perline, ncycle*freq-i));
			if(freq > 1 && nline%pl == 0) {
				printf("%*s", im, "");
				for(k = 0; k < thisline; k++)
					switch(freq) {
					case 12: 
						printf(" %*s", maxw, month[i+k]);
						break;
					case 4:
						printf(" %*dQ", maxw-1, i+k+1);
						break;
					default:
						printf(" %*d", maxw, 1+(i+k)%freq);						break;
					}
				putchar('\n');
				nline++;
			}
			printf("%*d:", im-1, j);
			kstart = i + (j-start)*freq - empty;
			kend = min(n, kstart + thisline);
			for(k = kstart; k < kend; k++) {
				putchar(' ');
				if(k < 0)
					printf("%*s", maxw, "");
				else
					pritem(x, k, maxw, ns, (char *)0);
			}
			putchar('\n');
			nline++;
		}
	}
	fflush(stdout);
}

static vector *
incr_matrix(x, l)
vector *x;
int  l;
{
	vector *xx = New_vector();
	*xx = *x; x = xx;
	switch(x->mode) {
	case INT:
	case LGL: (x->value.Long) += l; break;
	case REAL: (x->value.Float) += l; break;
	case DOUBLE: (x->value.Double) += l; break;
	case CHAR: (x->value.Char) += l; break;
	case COMPLEX: (x->value.Complex) += l; break;
	default: if(NOT_RECURSIVE(x->mode))
		PROBLEM "System error: invalid mode in prmatrix" RECOVER(x);
		(x->value.tree) += l; break;
	}
	return(x);
}

static int
lenitem(x, i, stat)
vector *x;
int i;
struct numsize *stat;
{
	buf[0] = '\0';
	switch(x->mode) {
	case LGL:
		if(is_na(&x->value.Long[i])) return(2); /* strlen("NA"); */
		else return(1);	/* strlen("T") */
	case INT:
		if(is_na(&x->value.Long[i])) return(2);
		else {
			sprintf(buf, "%ld", x->value.Long[i]);
			return(strlen(buf));
		}
	case REAL:
		if(is_na(&x->value.Float[i])) return(2);
		else return(numstat(x->value.Float[i], (int)n_digits, stat));
	case DOUBLE:
		if(is_na(&x->value.Double[i])) return(2);
		else return(numstat(x->value.Double[i], (int)n_digits, stat));
	case COMPLEX:
		if(is_na(&x->value.Complex[i])) return(2);
		else return(numstat(x->value.Complex[i].re, (int)n_digits, &stat[0]) + 1 + 
			numstat(fabs(x->value.Complex[i].im), (int)n_digits, &stat[1]) + 1);
	case CHAR:
		return(unlex_len(x->value.Char[i])+2*quote);
	}
	return(0);
}

static void
pritem(x, i, field, stat, string)
vector *x;
int i, field;
struct numsize *stat;
char *string;
{
	char *s = string ? string : buf, *t;

	switch(x->mode) {
	case LGL:
		if(is_na(&x->value.Long[i])) sprintf(s, "%*s", field, "NA");
		else sprintf(s, "%*s", field, x->value.Long[i] ? "T" : "F");
		break;
	case INT:
		if(is_na(&x->value.Long[i])) sprintf(s, "%*s", field, "NA");
		else sprintf(s, "%*ld", field, x->value.Long[i]);
		break;
	case REAL:
		if(is_na(&x->value.Float[i])) sprintf(s, "%*s", field, "NA");
		else prnum(x->value.Float[i], field, stat, s);
		break;
	case DOUBLE:
		if(is_na(&x->value.Double[i])) sprintf(s, "%*s", field, "NA");
		else prnum(x->value.Double[i], field, stat, s);
		break;
	case COMPLEX:
		if(is_na(&x->value.Complex[i])) sprintf(s, "%*s", field, "NA");
		else {
			t = s;
			prnum(x->value.Complex[i].re, stat[0].width, &stat[0], t);
			t += strlen(t);
			*t++ = x->value.Complex[i].im>=0 ? '+' : '-';
			prnum(fabs(x->value.Complex[i].im), stat[1].width, &stat[1], t);
			t += strlen(t);
			*t++ = 'i';
			*t = 0;
		}
		break;
	case CHAR:
		s = prcitem(field, x->value.Char[i], string);
		break;
	}
	if(!string)
		printf("%s", s);
}

static void
prnum(x, field, stat, s)
double x;
int field;
struct numsize *stat;
char *s;
{
	if(stat->pmode == 'f')
		sprintf(s, "%*.*f", field, stat->nright, x);
	else
		sprintf(s, "%*.*e", field, stat->nsignif-1, x);
}

/*
 * Print a string, with suitable escapes.
 * Must use the same algorithm as do_unlex()
 * so that unlex_len() is right.
 */
static char *
prcitem(field, s, to)
int field;
char *s, *to;
{
	static char *cbuf;
	static int cbuflen = 0;
	int n = strlen(s), c, len, qlen = 2*(quote && to == 0);
	char *begin;

	if(field < n)
		field = n + qlen;
	if(to == 0) {
		if(cbuflen < field+1) {
			if(cbuflen && cbuf != buf)
				free(cbuf);
			cbuf = S_calloc(field+1, 1);
			cbuflen = field+1;
		}
		to = cbuf;
	}
	begin = to;
	len = field - unlex_len(s) - qlen;
	if(qlen)
		*to++ = '"';
	while(c = (*s++ & 0x7f))
		switch(c) {
		case '"':
		case '\\':
			*to++ = '\\'; *to++ = c; break;
		case '\n':
			*to++ = '\\'; *to++ = 'n'; break;
		case '\r':
			*to++ = '\\'; *to++ = 'r'; break;
		case '\t':
			*to++ = '\\'; *to++ = 't'; break;
		case '\b':
			*to++ = '\\'; *to++ = 'b'; break;
		default:
			if(c < 0x20) {
				*to++ = '\\'; *to++ = '0';
				*to++ = '0' + c/8; *to++ = '0' + c%8;
			} else
				*to++ = c;
		}
	if(qlen)
		*to++ = '"';
	while(len-- > 0)
		*to++ = ' ';
	*to = 0;
	return(begin);
}

static int
numstat(x, ndigit, stat)
double x;
int ndigit;
struct numsize *stat;
{
	char *ecvt(), *s, *t;
	int decpt, sign, e, ns, nf, ne;

	s = ecvt(x, ndigit, &decpt, &sign);
	t = s + strlen(s);
	while(t > s && *--t == '0')
		;
	if(t == s && *t == '0')
		decpt = 1;
	ns = t - s + 1;
	e = abs(decpt - 1);
	MAXEQ(stat->sign, sign != 0);
	MAXEQ(stat->nsignif, ns);
	MAXEQ(stat->nleft, max(0, decpt));
	MAXEQ(stat->nright, ns - decpt);
	MAXEQ(stat->nexp, FASTLOG(e));
	nf = stat->sign + max(stat->nleft,1) + (stat->nright>0) + stat->nright;
	ne = stat->sign + stat->nsignif + (stat->nsignif>1) + 2 + stat->nexp;
	stat->pmode = nf <= ne ? 'f' : 'e';
	stat->width = min(nf, ne); /* see $P/rdtfmt.r for more sophistication */
	return(stat->width);
}

static void
zero(ns, n)
struct numsize *ns;
{
	while(n--) {
		ns->sign = ns->nsignif = 0;
		ns->nleft = ns->nright = ns->nexp = 0;
		ns++;
	}
}

static double
frac(x)
double x;
{
	return(x - floor(x));
}

static int
round(x)
double x;
{
	return((int)(x + 0.5));
}

static int
max(a, b)
int a, b;
{
	return(a > b ? a : b);
}

static int
min(a, b)
int a, b;
{
	return(a > b ? b : a);
}
