#include <stdio.h>
#include <signal.h>
#include <setjmp.h>
#include "S.h"

#define WAITING 1
#define DOING 2
int state = WAITING;
long task_id = 0L;
#define PATTERN "\001\001\001\001"

jmp_buf run_jmp;

FILE *ret_file, *cmd_file;
char *cmd_buf;
char *END_BUF = NULL;
main(argc,argv)
int argc; char *argv[];
{
	int fd,i,c; extern catch_int();
	char *p, *last_line; unsigned n;
#ifdef lint
	NONEXISTENT(argc);
#endif
	if(sscanf(argv[1],"%ld",&fd)<1){
		fputs("runit exiting: no return file argument\n",stderr);
		exit(1);
	}
	if((ret_file =fdopen(fd,"w"))==NULL) {
		fprintf(stderr,"runit exiting: can't get a file pointer for fd %d\n",fd);
		exit(1);
	}
	if(sscanf(argv[2],"%ld",&fd)<1){
		fputs("runit exiting: no return file argument\n",stderr);
		exit(1);
	}
	if((cmd_file =fdopen(fd,"r"))==NULL) {
		fprintf(stderr,"runit exiting: can't get a file pointer for fd %d\n",fd);
		exit(1);
	}
	if(!END_BUF) { /* first time */
		cmd_buf = calloc(BUFSIZ,1);
		END_BUF  = cmd_buf + BUFSIZ;
	}
#ifdef ATT_UNIX
	for(i=2; i<20; i++)signal(i,catch_int);
#else
	for(i=2; i<20; i++)
		if(i!=SIGTSTP && i!=SIGCONT) signal(i,catch_int);
#endif
	setjmp(run_jmp);
#ifdef lint
	last_line = 0; NONEXISTENT(last_line);
	p = 0; NONEXISTENT(p);
#endif
	for(;;) switch(state) {
	case WAITING:
		  signal(SIGINT,SIG_IGN);
		  for(;;) {
		  if((c=getc(cmd_file))== EOF)exit(1);
		  if(c!='\001' || getc(cmd_file)!='\001'|| getc(cmd_file)!='\001'|| getc(cmd_file)!='\001') continue;
		  if(fscanf(cmd_file,"%ld",&n)<1 || n<=task_id){
			  fputs("runit: error in communication\n",stderr);
			  exit(1);
		  }
		  task_id = n;
		  signal(SIGINT,catch_int);
		  state = DOING; p = last_line = cmd_buf;
		  break; /* out of inner for */
		}
		break;
	case DOING: for(;;) {
		if((c = *p++ = getc(cmd_file))=='\001' &&
		 (c = *p++ = getc(cmd_file))=='\001' &&
		 (c = *p++ = getc(cmd_file))=='\001' &&
		 (c = *p++ = getc(cmd_file))=='\001') { /* end marker */
			if(fscanf(cmd_file,"%ld",&n)<1 || n!=task_id) {
			  fputs("runit: error in communication\n",stderr);
			  exit(1);
			}
			if(last_line > cmd_buf){
				*last_line = '\0';
				i=system(cmd_buf);
				fputs(PATTERN,ret_file);
				fprintf(ret_file," %ld %ld\n",task_id,i);
				fflush(ret_file);
			}
			signal(SIGINT,SIG_IGN);
			state = WAITING;
			break; /* out of  inner for */
		}
		else if(p >= END_BUF) {
			n = END_BUF-cmd_buf;
			if((cmd_buf = Realloc(cmd_buf,2*n))==NULL) {
				fputs("runit exiting: Can't get any more buffer space\n",stderr);
				exit(1);
			}
			p = cmd_buf + n;
			END_BUF = cmd_buf+2*n;
		}
		if(c=='\n')last_line = p-1;
	  	}
		break;
	default:
		fprintf(stderr,"Invalid run state: %d\n");
		exit(1);
	}	
}

catch_int(i)
int i;
{
#ifdef ATT_UNIX
	if(i>=2 && i<=20)signal(i,catch_int);
#else
	if(i>=2 && i<=20 && i!=SIGTSTP && i!=SIGCONT) signal(i,catch_int);
#endif
	fputs(PATTERN,ret_file);
	fprintf(ret_file," %ld %ld\n",task_id,-i); /* signal error to caller*/
	state = WAITING;
	longjmp(run_jmp,i);
}

