;; Be suspicious of reply-to fields.  Idiot list-maintainters insist
;; on directing all replies back to the list, causing personal messages
;; to be distributed by mistake.  This queries about all reply-to lines.
;; Copyright (C) 1998 Ken D. Olum
;; May be redistributed under the terms of the GNU public license.

(require 'rmail)

(defvar rmail-query-reply-to t
  "*Non-nil means query before using reply-to line")

;;This replaces rmail-reply from rmail.el
(defun rmail-reply (just-sender)
  "Reply to the current message.
Normally include CC: to all other recipients of original message;
prefix argument means ignore them.  While composing the reply,
use \\[mail-yank-original] to yank the original message into it."
  (interactive "P")
  (let (from reply-to cc subject date to message-id resent-reply-to
	     (msgnum rmail-current-message)
	     (rmail-buffer (current-buffer)))
    (save-excursion
      (save-restriction
	(widen)
	(goto-char (rmail-msgbeg rmail-current-message))
	(forward-line 1)
	(if (= (following-char) ?0)
	    (narrow-to-region
	     (progn (forward-line 2)
		    (point))
	     (progn (search-forward "\n\n" (rmail-msgend rmail-current-message)
				    'move)
		    (point)))
	  (narrow-to-region (point)
			    (progn (search-forward "\n*** EOOH ***\n")
				   (beginning-of-line) (point))))
	(setq resent-reply-to (mail-fetch-field "resent-reply-to" t)
	      from (mail-fetch-field "from")
	      reply-to (or resent-reply-to
			   (mail-fetch-field "reply-to" nil t)
			   from)
	      cc (cond (just-sender nil)
		       (resent-reply-to (mail-fetch-field "resent-cc" t))
		       (t (mail-fetch-field "cc" nil t)))
	      subject (or (and resent-reply-to
			       (mail-fetch-field "resent-subject" t))
			  (mail-fetch-field "subject"))
	      date (or (and resent-reply-to
			    (mail-fetch-field "resent-date" t))
		       (mail-fetch-field "date"))
	      to (cond (resent-reply-to
			(or (mail-fetch-field "resent-to" t)) "")
		       ((mail-fetch-field "to" nil t))
		       ;((mail-fetch-field "apparently-to")) ack gag barf
		       (t ""))
	      message-id (cond (resent-reply-to
				(mail-fetch-field "resent-message-id" t))
			       ((mail-fetch-field "message-id"))))))
    (and (stringp subject)
	 (setq subject
	       (concat rmail-reply-prefix
		       (if (string-match rmail-reply-regexp subject)
			   (substring subject (match-end 0))
			 subject))))
    ;;Be suspicious of reply-to lines
    (setq reply-to (mail-strip-quoted-names reply-to))
    (if (and rmail-query-reply-to
	     (not (eq reply-to from)))		;If different fields used
	(let ((strip-from (mail-strip-quoted-names from)))
	  ;;Only ask if actual text is different.
	  (unless (string-equal (downcase reply-to) (downcase strip-from))
	    (if (y-or-n-p (format "Reply to %s? " reply-to))
		nil			;Already set
	      (setq reply-to strip-from))) ;Doesn't want it.  Use from
	  ))
    (rmail-start-mail nil
      reply-to
      subject
      (rmail-make-in-reply-to-field from date message-id)
      (if just-sender
	  nil
	(let* ((cc-list (rmail-dont-reply-to
			  (mail-strip-quoted-names
			    (if (null cc) to (concat to ", " cc))))))
	  (if (string= cc-list "") nil cc-list)))
      (current-buffer)
      (list (list '(lambda ()
		     (let ((msgnum rmail-send-actions-rmail-msg-number))
		       (save-excursion
			 (set-buffer rmail-send-actions-rmail-buffer)
			 (if msgnum
			     (rmail-set-attribute "answered" t msgnum))))))))
    ;; We keep the rmail buffer and message number in these 
    ;; buffer-local vars in the sendmail buffer,
    ;; so that rmail-only-expunge can relocate the message number.
    (make-local-variable 'rmail-send-actions-rmail-buffer)
    (make-local-variable 'rmail-send-actions-rmail-msg-number)
    (setq rmail-send-actions-rmail-buffer rmail-buffer)
    (setq rmail-send-actions-rmail-msg-number msgnum)))

(provide 'rmail-query-reply-to)
