/*
 * KCLL -  Ken and Chee's Limey Lisp  
 * All Rights to the code and any products created with this code is 
 * hereby granted. 
 *
 * I.E. You can do whatever the hell you want with this code. 
 * The only restriction is that this copyright notice not be modified.
 */

#include <ctype.h>
#include "cons.h"
#include "stream.h"
#include "read.h"
#include "cont.h"
#include "vector.h"

LLTag llcons_t;

enum aord_e { 
LLSET_CAR,
LLSET_CDR,
};
LLCons *llread_cons(stream)
     LLStream *stream;
{
  LLCons *first, *prev, *this;
  char c;

  prev = first = NULL;
  for(;;) {
    c = llread_nonspace(stream);
    if (c == ')')
      if (first) {
	llccdr(prev) = NIL;
	return(first);
      } else
	return((LLCons *) NIL);
    if (c == '.')
      if (first)
	if ((llccdr(prev) = llread_obj(stream)) == NULL)
	  llerror(LLBAD_LIST);
	else {
	  c = llread_nonspace(stream);
	  if (c == ')')
	    return(first);
	  else
	    llerror(LLBAD_LIST);
	}
      else
	llerror(LLBAD_LIST);
    llunread_stream(stream, (unsigned char)c);
    this = (LLCons *) llmake_obj(llcons_t);
    if ((llccar(this) = llread_obj(stream)) == NULL)
      llerror(LLEND_OF_STREAM);
    if (first)
      llccdr(prev) = (LLObj *) this;
    else
      first = this;
    prev = this;
  }
}

void touch_cons(cons)
     LLCons *cons;
{
  lltouch_obj(llccar(cons));
  lltouch_obj(llccdr(cons));
}
 
void print_cons(cons, stream)
     LLCons *cons;
     LLStream *stream;
{
  llstrprintf(stream,"(");
  while (!null(cons)) {
    llprint_obj(cons->a, stream);
    cons = (LLCons *) cons->d;
    if (null(cons));
    else if (llis_cons(cons)) 
      llstrprintf(stream, " ");
    else {
      llstrprintf(stream," . ");
      llprint_obj((LLObj *) cons, stream);
      cons = (LLCons *) NIL;
    }
  }
  llstrprintf(stream,")");
}


LLCons *_llcmake_cons(a, d)
     LLObj *a, *d;
{
  LLCons *c;

  c = (LLCons *) llmake_obj(llcons_t);
  llccar(c) = a;
  llccdr(c) = d;
  return c;
}

void llcons()
{
  LLObj *obj1;
  LLObj *obj2;
  
  obj1 = llnextarg();
  obj2 = llnextarg();
  lllastarg();
  llpusharg(llcmake_cons(obj1, obj2)); 
}

static void set_consbang(type )
int type;
{
  LLCons *cons; 
  LLObj *obj; 
  
  cons = (LLCons *)llnextcheckedarg(llcons_t); 
  obj = llnextarg();
  lllastarg(); 
  switch (type ) {
  case LLSET_CAR :
    llccar(cons) = obj;
    break; 
  case LLSET_CDR :
    llccdr(cons) = obj;
    break; 
  }
  llpusharg(cons); 
}

void llset_cdrbang() {  set_consbang(LLSET_CDR); }
void llset_carbang() {  set_consbang(LLSET_CAR); }

void llcar() {
  LLCons *cons; 
  cons = (LLCons *)llnextcheckedarg(llcons_t); 
  lllastarg(); 
  llpusharg(llccar(cons));
}
void llcdr() {
  LLCons *cons; 
  cons = (LLCons *)llnextcheckedarg(llcons_t); 
  lllastarg(); 
  llpusharg(llccdr(cons));
}

void lllist() 
{
  LLCons *first, *prev ;
  
  if(!llargc) {
    llpusharg(NIL);
    return;
  } 
  prev = first = llcmake_cons(llnextarg(), NIL) ;
  while (llargc) { 
     llccdr(prev) = (LLObj *)llcmake_cons(llnextarg(), NIL) ;
     prev = (LLCons *)llccdr(prev);
  }
  llpusharg(first); 
}

void lllength()
{
  LLObj *obj;
  int retval; 
  obj = llnextarg();
  if((retval = llclength(obj))== -1) { 
    llerror(LLTYPE_ERROR);
  } else { 
    llpusharg(lldouble_to_num((double)retval));
  }
}

void llinit_cons()
{
  llcons_t = lladd_obj_td (sizeof(LLCons), "Cons",
			   0, touch_cons, print_cons, 0);
  /* Note: the read method for cons cells
     is called from read_obj (read.c) */
  
  llregister_cfunc(llcons, "cons");
  llregister_cfunc(llcar, "car");
  llregister_cfunc(llcdr, "cdr");
  llregister_cfunc(llset_carbang, "set-car!"); 
  llregister_cfunc(llset_cdrbang, "set-cdr!"); 
  llregister_cfunc(lllist, "list");
  llregister_cfunc(lllength, "length");
}  

/* Return length if argument is a "proper list" 
   (either NIL, or a cons cell who's cdr is a proper list,
   or a list with more than 10000 elements (circular...?))
   or -1 if it is not.
*/

#define MAX_LIST_LENGTH 10000

int llclength(obj)
     LLObj *obj;
{
  int count = 0;
  while (obj != NIL && count++ < MAX_LIST_LENGTH) {
    if (llis_cons(obj))
      obj = llccdr(obj);
    else
      return -1;
  }
  return count;
}

