/*
 * KCLL -  Ken and Chee's Limey Lisp  
 * All Rights to the code and any products created with this code is 
 * hereby granted. 
 *
 * I.E. You can do whatever the hell you want with this code. 
 * The only restriction is that this copyright notice not be modified.
 */

#ifndef _CONT_INC
#define _CONT_INC

#include "obj.h"
#include "vector.h"
#include "string.h"
#include "env.h"

typedef struct llcont_s {
  LLIS_OBJECT;
  LLString *bytecode;		/* Bytecode being run */
  LLVector *objects;		/* Objects vector for bytecode */
  unsigned char *pc;		/* Pointer into bytecode array */
  LLEnv *env;			/* Environment to run bytecode in */
  int argc;			/* # parameters for next procedure */
  LLObj **argbase;		/* Bottom of the argument stack */
  LLObj **argptr;		/* Current stack pointer */
  LLObj **argtop;		/* Top of allocated space */
  struct llcont_s *retaddr;	/* SCHEME parent of this continuation 
				   (NIL if continuation is created in C) */ 
} LLCont;

extern LLTag llcont_t;

/* Current continuation.  If NIL, then go out of scheme (i.e.,
   read-eval-print loop or whatever top-level C functions are 
   in control. */
extern LLCont *llcur_cont;
extern LLCont *lltop_cont;

#define llis_cont(obj) (llobj_tag(obj) == llcont_t)

#define llargc (llcur_cont->argc)
#define llargptr (llcur_cont->argptr)
#define llargbase (llcur_cont->argbase)
#define llargtop (llcur_cont->argtop)
#define llmoreargs() (llargc > 0) 
#define llargcount(i) if(llargc < i) llerror(LLTOO_FEW_ARGS); else if(llargc > i) llerror(LLTOO_MANY_ARGS)
#define lllastarg()  ((llargc > 0) ? (llerror(LLTOO_MANY_ARGS), 0) : 1)
#define llnextarg()  ((llargc > 0) ? llargc--, llpoparg() : (llerror(LLTOO_FEW_ARGS), NIL))
#define llpoparg()   ((llargptr > llargbase) ? *(--llargptr) : (llerror(LLEMPTY_STACK), NIL))
#define llpusharg(arg)  ((llcheck_arg_space()), (*(llargptr++) = ((LLObj *)(arg))))
#define llpeekarg()  (llargptr[-1])
#define llnextcheckedarg(type) ((lltypecheck(llpeekarg(), type)) ? llnextarg() : 0)
#define llcheck_arg_space() ((llargptr >= llargtop) ? (llcmake_arg_space(), 0) : 0)

#define llcreenter_cont(c) (llcur_cont = (c))

LLCont *llcmake_child_cont();
void llccall_with_current_continuation();
void llinit_cont();
 
#endif
