/*
 * KCLL -  Ken and Chee's Limey Lisp  
 * All Rights to the code and any products created with this code is 
 * hereby granted. 
 *
 * I.E. You can do whatever the hell you want with this code. 
 * The only restriction is that this copyright notice not be modified.
 */
/*
  Support for LLObjects

  lladd_obj_td (

*/

#include "obj.h"
#include "stream.h"
#include "mem.h"

#define TD_CHUNK 1000		/* size of realloc incremental chunks */

LLTag llnum_tds = 0;		/* Number of tag descriptors so far allocated */
LLObj_td *object_tds[MAX_TDS];	/* Array of allocated object descriptors */
LLTag llnull_t;			/* Tag for NIL --- byt you should */
				/* just use the variable NIL! */
LLObj *NIL;			/* Magic NIL object */
LLObj *T;			/* Magic NIL object */

/* Default handlers for: freeing, touching, printing, and reading */

/*ARGSUSED*/
void default_free(obj)
     LLObj *obj;
{
}

/*ARGSUSED*/
void default_touch(obj)
     LLObj *obj;
{
}

/*ARGSUSED*/
int default_compare(cmptype, o1, o2)
     LLCompare cmptype; 
     LLObj *o1, *o2;
{
  return(o1 == o2);
}

/*ARGSUSED*/
void default_print(obj, stream)
     LLObj *obj;
     LLStream *stream;
{
  LLTag tag;

  llstrprintf(stream,"<");
  tag = llobj_tag(obj);
  if (tag & 0x8000) {
    llstrprintf(stream,"Touched ");
    tag &= 0x7FFF;
  }
  if (tag >= llnum_tds) 
    llstrprintf(stream, "%d-object", tag);
  else
    llstrprintf(stream, "%s", object_tds[tag]->name);
  llstrprintf(stream," %08X>", obj); 
}

/*ARGSUSED*/
LLObj *default_read(stream)
     LLStream *stream;
{
  return NULL;
}

LLTag lladd_obj_td (size, name,  freefunc, touchfunc, printfunc, readfunc)
     int size;
     char *name;
     void (*freefunc)();	
     void (*touchfunc)();	
     void (*printfunc)();	
     LLObj *(*readfunc)();	
{
  LLObj_td *td;

  if (llnum_tds == MAX_TDS) 
    llerror(LLTOO_MANY_TDS);
  td = object_tds[llnum_tds] = (LLObj_td *) malloc(sizeof(LLObj_td));
  td->size = size;
  td->name = name;
  td->freefunc = (freefunc ? freefunc : default_free);
  td->touchfunc = (touchfunc ? touchfunc : default_touch);
  td->printfunc = (printfunc ? printfunc : default_print);
  td->readfunc = (readfunc ? readfunc : default_read);
  td->comparefunc = default_compare; /* by default all comparisons are eq */
  return(llnum_tds++);
}

#if 0
static void touch_obj_td (td)
     LLObj_td *td;
{
  if (td->name)			/* If this type has a name... */
    lltouch_obj(td);	/* touch it! */
}
#endif

void print_null (obj, stream)
     LLObj *obj;
     LLStream *stream;
{
  if (obj == NIL)
    llstrprintf (stream, "nil");
  else
    llstrprintf (stream, "<NULL object %08X>", obj);
}

llregister_compare_function(objtype, func)
     LLTag objtype;
     int (*func)();
     
{
  object_tds[objtype]->comparefunc = func;
}

void llprint_obj (o, stream)
     LLObj *o;
     LLStream *stream;
{
  object_tds[llobj_tag_value((LLObj *)o)]->printfunc(o, stream);
}

LLObj *llcompare (compmethod, o1, o2)
     LLCompare compmethod;
     LLObj *o1, *o2;
{
  if (llobj_tag(o1) != llobj_tag(o2))
    return LLFALSE;
  else 
    if (object_tds[llobj_tag((LLObj *)o1)]->comparefunc(compmethod,o1,o2))
      return T;
    else
      return LLFALSE;
}
 
void llinit_obj()
{
  llnull_t = lladd_obj_td (sizeof(LLObj), "Null", /* size of NIL obj isn't 0 */
			   0, 0, print_null, 0);
  NIL = llmake_obj(llnull_t);
}

int lltypecheck(obj, type)
     LLObj* obj;
     int type;
{
#define lltypecheck(obj, type) ((llobj_tag(obj) == type) ? 1 : (llerror(LLTYPE_ERROR), 0))

  if( llobj_tag(obj) == type ) 
    return 1;
  else 
    return lltype_error(object_tds[llobj_tag(obj)], 
			object_tds[type]);
}
