#include "mysccs.h"
SCCSID("@(#)errors.c   %E%   SAP   %I%")

static char * this_File GNU_UNUSED = __FILE__;

/************************************************************************/
/* $Id: errors.c,v 1.3 1998/11/27 15:24:59 d019080 Exp $
 ************************************************************************/
/*
 *  (C) Copyright 1998  SAP AG Walldorf
 *
 * Author:  Martin Rex
 * 
 * SAP AG DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL SAP AG BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL
 * DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
 * PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THIS SOFTWARE.
 */

#include "gsstest.h"


static gss_OID_desc  sapntlm_mech_oid = { 10, "\053\006\001\004\001\205\066\002\001\002"     };
static gss_OID_desc  sapntlm_nt_oid   = { 11, "\053\006\001\004\001\205\066\002\001\002\001" };


/*
 * error_tests()
 *
 *
 */
int
error_tests( DLL_GSSFP_T * p_gssfp )
{
   int    rc = 0;

   XVEB((V_SHOW, "====================\nTesting gss_display_status() major_status translations ...\n----------\n"));
   rc += errors_with_display_status( p_gssfp );

   ignore_name_for_statistics = TRUE;

   XVEB((V_SHOW, "====================\nTesting error handling of name management functions ...\n----------\n"));
   rc += errors_with_names( p_gssfp );

   XVEB((V_SHOW, "====================\nTesting error handling of credential management functions ...\n----------\n"));
   rc += errors_with_creds( p_gssfp, p_gssfp );

   XVEB((V_SHOW, "====================\nTesting error handling of context establishment funcions ...\n----------\n"));
   rc += errors_with_contexts( p_gssfp, p_gssfp );

   ignore_name_for_statistics = FALSE;

   return(rc);

} /* error_tests() */


/*************************************************************************/
/*************************************************************************/
/**									**/
/**	    Test of gss_display_status() output                         **/
/**									**/
/*************************************************************************/
/*************************************************************************/

#define DSPNAME_TEST_ENTRY(x)	 { (OM_uint32) (x), #x }
#define DSPNAME_TEST_FINAL       { 0, 0 }

static struct dspname_test_s dspname_test_routine[] = {
	 DSPNAME_TEST_ENTRY(GSS_S_COMPLETE),
	 DSPNAME_TEST_ENTRY(GSS_S_BAD_MECH),
	 DSPNAME_TEST_ENTRY(GSS_S_BAD_NAME),
	 DSPNAME_TEST_ENTRY(GSS_S_BAD_NAMETYPE),
	 DSPNAME_TEST_ENTRY(GSS_S_BAD_BINDINGS),
	 DSPNAME_TEST_ENTRY(GSS_S_BAD_STATUS),
	 DSPNAME_TEST_ENTRY(GSS_S_BAD_MIC),
	 DSPNAME_TEST_ENTRY(GSS_S_NO_CRED),
	 DSPNAME_TEST_ENTRY(GSS_S_NO_CONTEXT),
	 DSPNAME_TEST_ENTRY(GSS_S_DEFECTIVE_TOKEN),
	 DSPNAME_TEST_ENTRY(GSS_S_DEFECTIVE_CREDENTIAL),
	 DSPNAME_TEST_ENTRY(GSS_S_CREDENTIALS_EXPIRED),
	 DSPNAME_TEST_ENTRY(GSS_S_CONTEXT_EXPIRED),
	 DSPNAME_TEST_ENTRY(GSS_S_FAILURE),
	 DSPNAME_TEST_ENTRY(GSS_S_BAD_QOP),
	 DSPNAME_TEST_ENTRY(GSS_S_UNAUTHORIZED),
	 DSPNAME_TEST_ENTRY(GSS_S_UNAVAILABLE),
	 DSPNAME_TEST_ENTRY(GSS_S_DUPLICATE_ELEMENT),
	 DSPNAME_TEST_ENTRY(GSS_S_NAME_NOT_MN),
	 DSPNAME_TEST_FINAL
};

static struct dspname_test_s dspname_test_info[] = {
	 
	 DSPNAME_TEST_ENTRY(GSS_S_CONTINUE_NEEDED),
	 DSPNAME_TEST_ENTRY(GSS_S_DUPLICATE_TOKEN),
	 DSPNAME_TEST_ENTRY(GSS_S_OLD_TOKEN),
	 DSPNAME_TEST_ENTRY(GSS_S_UNSEQ_TOKEN),
	 DSPNAME_TEST_ENTRY(GSS_S_GAP_TOKEN),
	 DSPNAME_TEST_FINAL
};

static struct dspname_test_s dspname_test_calling[] = {
	 DSPNAME_TEST_ENTRY(GSS_S_CALL_INACCESSIBLE_READ),
	 DSPNAME_TEST_ENTRY(GSS_S_CALL_INACCESSIBLE_WRITE),
	 DSPNAME_TEST_ENTRY(GSS_S_CALL_BAD_STRUCTURE),
	 DSPNAME_TEST_FINAL
};

static struct dspname_test_s dspname_test_combined[] = {
	 DSPNAME_TEST_ENTRY((GSS_S_FAILURE|GSS_S_DUPLICATE_TOKEN)),
	 DSPNAME_TEST_ENTRY((GSS_S_FAILURE|GSS_S_OLD_TOKEN)),
	 DSPNAME_TEST_ENTRY((GSS_S_FAILURE|GSS_S_UNSEQ_TOKEN)),
	 DSPNAME_TEST_ENTRY((GSS_S_FAILURE|GSS_S_GAP_TOKEN)),
	 DSPNAME_TEST_ENTRY((GSS_S_CALL_INACCESSIBLE_READ|GSS_S_BAD_NAME)),
	 DSPNAME_TEST_ENTRY((GSS_S_CALL_INACCESSIBLE_WRITE|GSS_S_DEFECTIVE_CREDENTIAL)),
	 DSPNAME_TEST_ENTRY((GSS_S_CALL_BAD_STRUCTURE|GSS_S_BAD_BINDINGS)),
	 DSPNAME_TEST_FINAL
};

static struct dspname_test_s dspname_test_mean[] = {
	 DSPNAME_TEST_ENTRY((GSS_S_CALL_INACCESSIBLE_READ|GSS_S_DEFECTIVE_TOKEN|GSS_S_DUPLICATE_TOKEN)),
	 DSPNAME_TEST_ENTRY((GSS_S_CALL_INACCESSIBLE_READ|GSS_S_DEFECTIVE_TOKEN|GSS_S_DUPLICATE_TOKEN|GSS_S_CONTINUE_NEEDED)),
	 DSPNAME_TEST_ENTRY((GSS_S_CONTINUE_NEEDED|GSS_S_DUPLICATE_TOKEN|GSS_S_UNSEQ_TOKEN)),
	 DSPNAME_TEST_ENTRY((0xfffffffful)),
	 DSPNAME_TEST_ENTRY((0x04130020ul)),
	 DSPNAME_TEST_ENTRY((0x10200800ul)),
	 DSPNAME_TEST_FINAL
};

#define MAX_MESSAGE_LINES   8
/*
 * test_display_status()
 *
 *
 */
int
test_display_status( int                      p_trclevel,      DLL_GSSFP_T   * p_gssfp,
		     struct dspname_test_s  * p_test_liste,    Ulong         * pp_maxlines,
		     Ulong		    * pp_min_linelen,  Ulong	     * pp_max_linelen,
		     Ulong		    * pp_sum_linelen,  Ulong	     * pp_counter )
{
   char			  * this_Call GNU_UNUSED = "test_display_status";
   struct dspname_test_s  * test;
   char                   * lptr;
   gss_buffer_desc          message[MAX_MESSAGE_LINES];
   OM_uint32		    maj_stat;
   OM_uint32		    context;
   int			    line;
   int			    i;
   int			    plen;
   int			    rc        = 0;

   for( test = p_test_liste; test->error_name!=NULL ; test++ ) {
      context = 0;
      if ( p_trclevel==1 ) {
	 XVEB((V_OK, p_trclevel, "  %-39.200s =>\n", test->error_name ));
      } else {
	 XVEB((V_OK, p_trclevel, "  gss_display_status(GSS_C_GSS_CODE, %.200s) returns\n",
		    test->error_name ));
      }

      line = 0;

      do {

	 message[line].value  = NULL;
	 message[line].length = 0;
	 rc += display_status( verbose_level, p_gssfp, test->status_value,
			       GSS_C_GSS_CODE, GSS_C_NO_OID, &context,
			       &(message[line]), &maj_stat );

	 if ( message[line].value!=NULL && message[line].length>0 ) {
	    if ( pp_counter!=NULL ) { (*pp_counter)++; }
	    if ( pp_sum_linelen!=NULL ) { (*pp_sum_linelen) += message[line].length; }
	    if ( pp_min_linelen!=NULL
	         && ((*pp_min_linelen)==0 || message[line].length<(*pp_min_linelen)) ) {
	       (*pp_min_linelen) = message[line].length;
	    }
	    if ( pp_max_linelen!=NULL && message[line].length > (*pp_max_linelen) ) {
	       /* memorize new maximum line length */
	       (*pp_max_linelen) = message[line].length;
	    }

	    line++;
	 }

      } while ( GSS_ERROR(maj_stat)==GSS_S_COMPLETE && context!=0 && line<MAX_MESSAGE_LINES);

      for ( i=0 ; i<line ; i++ ) {

	 if ( i+1==line ) {
	    lptr = "  ________" "__________" "__________";
	 } else {
	    lptr = "          " "          " "          ";
	 }

	 plen = (message[i].length<48) ? 28 : (message[i].length>72) ? 6 : 76 - message[i].length;

	 XVEB((V_OK, p_trclevel, "%.*s\"%.*s\"\n", plen, lptr,
		       (int)(message[i].length), (char *)(message[i].value) ));
         rc += release_buffer( p_gssfp, &(message[i]) );
      }

      if ( pp_maxlines!=NULL && (Ulong)line>(*pp_maxlines) ) {
	 (*pp_maxlines) = (Ulong)line;
      }

   }

   return(rc);
   
} /* test_display_status() */




/*
 * errors_with_display_status()
 *
 *
 */
int
errors_with_display_status( DLL_GSSFP_T  * p_gssfp )
{
   int    rc  = 0;
   int    rci = 0;

   XVEB((V_TEST, "Testing gss_display_status() for routine errors:\n"));
   rci = test_display_status( verbose_level+1, p_gssfp, &(dspname_test_routine[0]),
			      &(p_gssfp->dspstat_one_max_lines),
			      &(p_gssfp->dspstat_one_min_linelen),
			      &(p_gssfp->dspstat_one_max_linelen),
			      &(p_gssfp->dspstat_one_sum_linelen),
			      &(p_gssfp->dspstat_one_counter) );
   XVEB((V_RESULT, rci, 0, NULL ));
   rc += rci;

   XVEB((V_TEST, "Testing gss_display_status() for informational status:\n"));
   rci = test_display_status( verbose_level+1, p_gssfp, &(dspname_test_info[0]),
			      &(p_gssfp->dspstat_one_max_lines),
			      &(p_gssfp->dspstat_one_min_linelen),
			      &(p_gssfp->dspstat_one_max_linelen),
			      &(p_gssfp->dspstat_one_sum_linelen),
			      &(p_gssfp->dspstat_one_counter) );
   XVEB((V_RESULT, rci, 0, NULL ));
   rc += rci;

   XVEB((V_TEST, "Testing gss_display_status() for calling errors:\n"));
   rci = test_display_status( verbose_level+1, p_gssfp, &(dspname_test_calling[0]),
			      &(p_gssfp->dspstat_one_max_lines),
			      &(p_gssfp->dspstat_one_min_linelen),
			      &(p_gssfp->dspstat_one_max_linelen),
			      &(p_gssfp->dspstat_one_sum_linelen),
			      &(p_gssfp->dspstat_one_counter) );
   XVEB((V_RESULT, rci, 0, NULL ));
   rc += rci;


   XVEB((V_TEST, "Testing gss_display_status() for status value combinations:\n"));
   rci = test_display_status( verbose_level+1, p_gssfp, &(dspname_test_combined[0]),
			      &(p_gssfp->dspstat_two_max_lines),
			      &(p_gssfp->dspstat_two_min_linelen),
			      &(p_gssfp->dspstat_two_max_linelen),
			      &(p_gssfp->dspstat_two_sum_linelen),
			      &(p_gssfp->dspstat_two_counter) );
   XVEB((V_RESULT, rci, 0, NULL ));
   rc += rci;

   XVEB((V_TEST, "Testing gss_display_status() for mean/invalid value combinations:\n"));
   rci = test_display_status( verbose_level+1, p_gssfp, &(dspname_test_mean[0]), NULL, NULL, NULL, NULL, NULL );
   XVEB((V_RESULT, rci, 0, NULL ));
   rc += rci;

   return(rc);

} /* errors_with_display_status() */


char  * bad_target_name = 0;

struct bad_name_list_s {
   int     name_ok;
   int     ini_cred_ok;
   int	   acc_cred_ok;
   char  * name;
} bad_name_list[] = {
   { 0, 0, 0, "XXXXXXXX"		  },
   { 0, 0, 0, "CBA/ZYX"			  },
   { 0, 0, 0, "CBA\\ZYX"		  },
   { 0, 0, 0, "CBA@ZYX"			  },
   { 0, 0, 0, "CBA@"                      },
   { 0, 0, 0, "XY\tZ"			  },
   { 0, 0, 0, "AB C"			  },
   { 0, 0, 0, "A B C\tD"		  },
   { 0, 0, 0, "A@B@C@X"			  },
   { 0, 0, 0, "A@@@@@@Z"		  },
   { 0, 0, 0, "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX" },
   { 0, 0, 0, "a,b,c,d"			  },
   { 0, 0, 0, "A/B/C/D"			  },
   { 0, 0, 0, "D\\C\\B\\A"		  },
   { 0, 0, 0, "CN=A1,OU=B  ,O  = C,     C   =ES" },
   { 0, 0, 0, "CN=A2, OU=C, O=D, C=ES"	  },
   { 0, 0, 0, "CN=A2, OU=C, O=D, C=ES,"	  },
   { 0, 0, 0, "C=ES, O=C,   OU = B,CN=A3" },
   { 0, 0, 0, "OU=H, C=ES, CN=A4, O=J"	  },
   { 0, 0, 0, "CN=A5; OU=Y; O=X; C=ES"	  },
   { 0, 0, 0, "CN=A5; OU=Y; O=X; C=ES;"	  },
   { 0, 0, 0, "CN = A6 , OU=T;O =U, C= ES" },
   { 0, 0, 0, "CN=A7,, OU=Z,O=Y,, ,C=ES"  },
   { 0, 0, 0, "CN=A8;; OU=T;O=S;; ;C=ES"  },
   { 0, 0, 0, "/CN=A8/OU=D/O=E/C=ES/"     },
   { 0, 0, 0, "/C=ES/O=F/OU=E/CN=A9/"     },
   { 0, 0, 0, "/OU=E/C=ES/CN=A10/O=G/"    },
   { 0, 0, 0, "/PRMD=ZYZ/ADMD=WWWYX/C=ES/"},
   { 0, 0, 0, "A:B%C/D\\E+F-G@H"          },
   { 0, 0, 0, "A@B:C%D/E\\F+G-H"	  },
   { 0, 0, 0, "@"                         },
   { 0, 0, 0, "/"                         },
   { 0, 0, 0, "/@"                        },
   { 0, 0, 0, ""			  },
   { 0, 0, 0, 0				  }
};


/*
 * errors_with_names()
 *
 *
 */
int
errors_with_names( DLL_GSSFP_T   * p_gssfp )
{
   char             * this_Call GNU_UNUSED = "errors_with_names";
   char             * bad_name;
   gss_name_t         name1     = GSS_C_NO_NAME;
   gss_name_t         name2     = GSS_C_NO_NAME;
   gss_name_t	      name3     = GSS_C_NO_NAME;
   OM_uint32	      maj_stat;
   int		      i;
   int		      rci       = 0;
   int                rc        = 0;

   XVEB((V_TEST, "Feeding gss_import_name() with a mech_oid nametype\n"));
   rci = import_and_canonicalize( verbose_level, p_gssfp,
				  p_gssfp->acceptor, p_gssfp->acceptor_len,
				  &sapntlm_mech_oid, &name1, &maj_stat );
   if ( maj_stat==GSS_S_BAD_NAMETYPE ) {
      rci = (rci>0) ? rci - 1 : rci;
   } else {
      rci++;
      XVEB((V_ERR, "gss_import_name() FAILED to return GSS_S_BAD_NAMETYPE!\n" ));
   }
   XVEB((V_RESULT, rci, 0, NULL ));
   rc += rci;

   for( i = 0 ; (bad_name = (bad_name_list[i].name))!=0 ; i++ ) {
      bad_name_list[i].name_ok = FALSE;
      XVEB((V_TEST, "Feeding gss_import_name() with garbage: \"%s\"\n", bad_name ));
      rci = import_and_canonicalize( verbose_level, p_gssfp,
				     bad_name, strlen(bad_name),
				     (p_gssfp->can_nametype), &name2, &maj_stat );
      if ( maj_stat==GSS_S_COMPLETE ) {
	 if ( strlen(bad_name)==0 ) {
	    XVEB((V_SHOW, "HUH?!  Empty name accepted? This looks suspicious!\n"));
	 }
	 bad_name_list[i].name_ok = TRUE;
	 rci += name_transform_xp( verbose_level, p_gssfp, name2, &name3, &maj_stat );
	 rci += print_name( 1, p_gssfp, "parses to", (name3!=GSS_C_NO_NAME) ? name3 : name2, NULL, &maj_stat );
	 if ( bad_target_name==NULL ) {
	    bad_target_name = bad_name;
	 }
      } else if ( maj_stat==GSS_S_BAD_NAME ) {
	 rci = (rci>0) ? rci - 1 : rci;
      } else {
	 XVEB((V_ERR, "gss_import_name() didn't return GSS_S_BAD_NAME!\n" ));
      }
      rci += release_name( p_gssfp, &name2 );
      rci += release_name( p_gssfp, &name3 );

      XVEB((V_RESULT, rci, 0, NULL ));
   }

   rc += release_name( p_gssfp, &name1 );
   rc += release_name( p_gssfp, &name2 );

   return(rc);

}/* errors_with_names() */




/*
 * errors_with_creds()
 *
 *
 */
int
errors_with_creds( DLL_GSSFP_T   * p_gssfp_ini,   DLL_GSSFP_T   * p_gssfp_acc )
{
   char             * this_Call GNU_UNUSED = "errors_with_creds";
   char		    * bad_name;
   gss_name_t         ini_name   = GSS_C_NO_NAME;
   gss_name_t	      acc_name   = GSS_C_NO_NAME;
   gss_name_t	      ini_name_i = GSS_C_NO_NAME;
   gss_name_t	      acc_name_i = GSS_C_NO_NAME;
   gss_OID_set_desc   mech_set;
   gss_cred_id_t      ini_cred  = GSS_C_NO_CREDENTIAL;
   gss_cred_id_t      acc_cred	= GSS_C_NO_CREDENTIAL;
   gss_cred_usage_t   usage;
   OM_uint32	      lifetime;
   OM_uint32	      maj_stat;
   int		      i;
   int		      rc        = 0;
   int		      rci       = 0;

   mech_set.elements = &sapntlm_nt_oid;
   mech_set.count    = 1;

   /****************************************************************/
   /* Testing gss_acquire_cred(initiator) for GSS_S_BAD_MECH       */
   /****************************************************************/
   XVEB((V_TEST, "Feeding gss_acquire_cred(INITIATE) with a single nametype-OID mech_set\n"));
   rci = acquire_cred( verbose_level, p_gssfp_ini, GSS_C_INITIATE, GSS_C_NO_NAME,
			&mech_set, &ini_cred, NULL, 0, &maj_stat );

   if ( maj_stat==GSS_S_BAD_MECH ) {
      rci = (rci>0) ? rci - 1 : rci;
   } else { 
      rci++;
      XVEB((V_ERR, "gss_acquire_cred(INITIATE) failed to return GSS_S_BAD_MECH!\n"));
   } 
   XVEB((V_RESULT, rci, 0, NULL ));
   rc += rci;

   rc += release_cred( p_gssfp_ini, &ini_cred );


   /****************************************************************/
   /* Testing gss_acquire_cred(acceptor) for GSS_S_BAD_MECH        */
   /****************************************************************/
   if ( p_gssfp_acc->acc_name!=GSS_C_NO_NAME ) {
      XVEB((V_TEST, "Feeding gss_acquire_cred(ACCEPT) with a single nametype-OID mech_set\n"));
      rci = acquire_cred( verbose_level, p_gssfp_acc, GSS_C_ACCEPT, (p_gssfp_acc->acc_name),
			  &mech_set, &acc_cred, NULL, 0, &maj_stat );

      if ( maj_stat==GSS_S_BAD_MECH ) {
	 rci = (rci>0) ? rci - 1 : rci;
      } else { 
	 rci++;
	 XVEB((V_ERR, "gss_acquire_cred(ACCEPT) failed to return GSS_S_BAD_MECH!\n"));
      } 
      XVEB((V_RESULT, rci, 0, NULL ));
      rc += rci;

   } /* gss_fp->acc_name!=GSS_C_NO_NAME */


   rc += release_cred( p_gssfp_acc, &acc_cred );


   if ( bad_target_name==NULL ) {

      XVEB((V_SHOW, "  Sorry, I don't have a bad target name for this test!\n"));
      rc++;

   } else {

      for ( i=0 ; bad_name_list[i].name!=NULL ; i++ ) {

	 bad_name_list[i].ini_cred_ok = FALSE;

	 if ( bad_name_list[i].name_ok == FALSE )
	    continue;

	 bad_name = bad_name_list[i].name;
	 /***************************************************************************/
	 /* Testing gss_acquire_cred() for GSS_S_NO_CRED                            */
	 /* (this may cause a GSS_S_BAD_NAME by gss_import_name() already)          */
	 /***************************************************************************/
	 XVEB((V_TEST, "Feeding gss_acquire_cred(INITIATE) with owner name \"%.128s\"\n", bad_name));
	 rci = import_name(verbose_level, p_gssfp_ini, bad_name, strlen(bad_name),
			   (p_gssfp_ini->can_nametype), &ini_name, &maj_stat);
	 if ( ini_name!=GSS_C_NO_NAME ) {
	    rci += acquire_cred( verbose_level, p_gssfp_ini, GSS_C_INITIATE, ini_name,
				 GSS_C_NO_OID_SET, &ini_cred, NULL, 0, &maj_stat );
	    if ( maj_stat==GSS_S_COMPLETE ) {
	       XVEB((V_SHOW, "  Hmmm ... gss_acquire_cred(INITIATE) happily accepted name \"%.128s\"\n",
		             bad_name ));
	       if ( ini_cred!=GSS_C_NO_CREDENTIAL ) {
		  bad_name_list[i].ini_cred_ok = TRUE;
		  rci += inquire_cred( verbose_level, p_gssfp_ini, ini_cred, CTX_INITIATOR,
				       &ini_name_i, &lifetime, &usage, NULL, &maj_stat );
		  if ( ini_name_i!=GSS_C_NO_NAME ) {
		     rci += print_name( 1, p_gssfp_ini, "cred owner resolves to", ini_name_i, NULL, &maj_stat );
		     rci += release_name( p_gssfp_ini, &ini_name_i );
		  }
	       }
	    } else if ( maj_stat==GSS_S_NO_CRED ) {
	       rci = (rci>0) ? rci - 1 : rci;
	    } else if ( maj_stat==GSS_S_FAILURE ) {
	       rci = (rci>0) ? rci - 1 : rci;
	       /* XVEB((V_SHOW, "  maybe GSS_S_NO_CRED would be more appropriate here?\n")); */
	    } else {
	       rci++;
	       XVEB((V_ERR, "gss_acquire_cred(INITIATE) failed to return a fatal error!\n"));
	    }

	 } else {

	    XVEB((V_ERR, "gss_import_name() FAILED? But it worked the first time!\n"));
	    rci++;

	 }

	 rci += release_name( p_gssfp_ini, &ini_name );
	 rci += release_cred( p_gssfp_ini, &ini_cred );

	 XVEB((V_RESULT, rci, 0, NULL ));
	 rc += rci;

      }

   } /* bad_target_name!=NULL */


   if ( bad_target_name==NULL ) {

      XVEB((V_SHOW, "  Sorry, I don't have a bad target name for this test!\n"));
      rc++;

   } else {

      for ( i=0 ; bad_name_list[i].name!=NULL ; i++ ) {

	 bad_name_list[i].acc_cred_ok = FALSE;

	 if ( bad_name_list[i].name_ok == FALSE )
	    continue;

	 bad_name = bad_name_list[i].name;
	 /***************************************************************************/
	 /* Testing gss_acquire_cred() for GSS_S_NO_CRED                            */
	 /* (this may cause a GSS_S_BAD_NAME by gss_import_name() already)          */
	 /***************************************************************************/
	 XVEB((V_TEST, "Feeding gss_acquire_cred(ACCEPT) with owner name \"%.128s\"\n",
		       bad_name ));
	 rci = import_name(verbose_level, p_gssfp_acc, bad_name, strlen(bad_name),
			   (p_gssfp_acc->can_nametype), &acc_name, &maj_stat);
	 if ( acc_name!=GSS_C_NO_NAME ) {
	    rci += acquire_cred( verbose_level, p_gssfp_acc, GSS_C_ACCEPT, acc_name,
				 GSS_C_NO_OID_SET, &acc_cred, NULL, 0, &maj_stat );
	    if ( maj_stat==GSS_S_COMPLETE ) {
	       XVEB((V_SHOW, "  Hmmm ... gss_acquire_cred() happily accepted name \"%.128s\"\n",
			     bad_name ));
	       if ( acc_cred!=GSS_C_NO_CREDENTIAL ) {
		  bad_name_list[i].acc_cred_ok = TRUE;
		  rci += inquire_cred( verbose_level, p_gssfp_acc, acc_cred, CTX_ACCEPTOR,
				       &acc_name_i, &lifetime, &usage, NULL, &maj_stat );
		  if ( acc_name_i!=GSS_C_NO_NAME ) {
		     rci += print_name( 1, p_gssfp_acc, "cred owner resolves to", acc_name_i, NULL, &maj_stat );
		     rci += release_name( p_gssfp_acc, &acc_name_i );
		  }
	       }

	    } else if ( maj_stat==GSS_S_NO_CRED ) {
	       rci = (rci>0) ? rci - 1 : rci;
	    } else if ( maj_stat==GSS_S_FAILURE ) {
	       rci = (rci>0) ? rci - 1 : rci;
	       /* XVEB((V_SHOW, "  maybe GSS_S_NO_CRED would be more appropriate here?\n")); */
	    } else {
	       rci++;
	       XVEB((V_ERR, "gss_acquire_cred(ACCEPT) failed to return a fatal error!\n"));
	    }

	 } else {

	    XVEB((V_ERR, "gss_import_name() FAILED? But it worked the first time!\n"));
	    rci++;

	 }

	 rci += release_name( p_gssfp_acc, &acc_name );
	 rci += release_cred( p_gssfp_acc, &acc_cred );

	 XVEB((V_RESULT, rci, 0, NULL ));
	 rc += rci;

      }

   }

   rc += release_name( p_gssfp_acc, &acc_name   );
   rc += release_name( p_gssfp_acc, &acc_name_i );
   rc += release_name( p_gssfp_ini, &ini_name   );
   rc += release_name( p_gssfp_ini, &ini_name_i );
   rc += release_cred( p_gssfp_ini, &ini_cred   );
   rc += release_cred( p_gssfp_acc, &acc_cred   );

   return(rc);

} /* errors_with_creds() */




/*
 * errors_with_contexts()
 *
 *
 */
int
errors_with_contexts( DLL_GSSFP_T   * p_gssfp_ini, DLL_GSSFP_T   * p_gssfp_acc )
{
   char             * this_Call GNU_UNUSED = "errors_with_contexts";
   gss_name_t	      ini_target_name = GSS_C_NO_NAME;
   struct ctx_desc  * x_acc	      = NULL;
   struct ctx_desc  * x_ini           = NULL;
   char		    * bad_name;
   OM_uint32	      maj_stat;
   int		      match;
   int		      i;
   int		      rci	      = 0;
   int		      rc	      = 0;

   if ( p_gssfp_ini->acceptor!=NULL  &&  p_gssfp_ini->acceptor_len>0 ) {

      rci = import_name( verbose_level, p_gssfp_ini,
			 p_gssfp_ini->acceptor, p_gssfp_ini->acceptor_len,
			 p_gssfp_ini->can_nametype, &ini_target_name, &maj_stat );

      if ( ini_target_name!=GSS_C_NO_NAME
	   &&  p_gssfp_ini->ini_name!=GSS_C_NO_NAME ) {

	 rci = compare_names( verbose_level, p_gssfp_ini, ini_target_name,
			      (p_gssfp_ini->ini_name), &match, &maj_stat );

	 if ( maj_stat==GSS_S_COMPLETE  &&  match==FALSE ) {

	    XVEB((V_TEST, "Testing context establishment with target name \"%.*s\"\n",
			  (int)p_gssfp_ini->initiator_len, p_gssfp_ini->initiator ));

	    rci = sap_establish_context( verbose_level, SNC_CONTEXT_FLAGS, GSS_C_INDEFINITE,
					 p_gssfp_ini, p_gssfp_acc, &x_ini, &x_acc,
				         SNC_SIMPLE_CRED, SNC_GSSNAMED_CRED,
				         p_gssfp_ini->initiator, p_gssfp_ini->initiator_len,
					 &maj_stat );
	    if ( GSS_ERROR(maj_stat)!=GSS_S_COMPLETE ) {
	       /* rci = (rci>0) ? rci-1 : rci ; */
	    }

	    rci += release_ctx_desc( &x_ini );
	    rci += release_ctx_desc( &x_acc );

	    XVEB((V_RESULT, rci, 0, NULL ));
	    rc += rci;

	 } /* initiator name different from acceptor name */

      } /* have target and initiator name */

      rci += release_name( p_gssfp_ini, &ini_target_name );

   }


   if ( bad_target_name==NULL ) {

      XVEB((V_SHOW, "  Sorry, I don't have BAD target names for further test!\n"));
      rc++;

   } else {

      for ( i=0 ; bad_name_list[i].name!=NULL ; i++ ) {

	 if ( (bad_name_list[i].name_ok)==FALSE )
	    continue;

	 bad_name = bad_name_list[i].name;

	 XVEB((V_TEST, "Testing context establishment with target name \"%.128s\"\n",
		       bad_name ));

	 rci = sap_establish_context( verbose_level, SNC_CONTEXT_FLAGS, GSS_C_INDEFINITE,
				      p_gssfp_ini, p_gssfp_acc, &x_ini, &x_acc,
				      SNC_SIMPLE_CRED, SNC_GSSNAMED_CRED,
				      bad_name, strlen(bad_name), &maj_stat );

	 if ( GSS_ERROR(maj_stat)!=GSS_S_COMPLETE ) {
	   /*  rci = (rci>0) ? rci-1 : rci ; */
	 }

	 rci += release_ctx_desc( &x_ini );
	 rci += release_ctx_desc( &x_acc );

	 XVEB((V_RESULT, rci, 0, NULL ));
	 rc += rci;

      }


      for ( i=0 ; bad_name_list[i].name!=NULL ; i++ ) {

	 if ( (bad_name_list[i].ini_cred_ok)==FALSE )
	    continue;

	 bad_name = bad_name_list[i].name;

	 XVEB((V_TEST, "Testing context establishment with initiator cred for \"%.128s\"\n",
		       bad_name ));

	 rci = sap_establish_context( verbose_level, SNC_CONTEXT_FLAGS, GSS_C_INDEFINITE,
				      p_gssfp_ini, p_gssfp_acc, &x_ini, &x_acc,
				      SNC_MISNAMED_CRED, SNC_GSSNAMED_CRED,
				      (p_gssfp_ini->acceptor), (p_gssfp_ini->acceptor_len), &maj_stat );

	 if ( GSS_ERROR(maj_stat)!=GSS_S_COMPLETE ) {
	   /*  rci = (rci>0) ? rci-1 : rci ; */
	 }

	 rci += release_ctx_desc( &x_ini );
	 rci += release_ctx_desc( &x_acc );

	 XVEB((V_RESULT, rci, 0, NULL ));
	 rc += rci;

      }


      for ( i=0 ; bad_name_list[i].name!=NULL ; i++ ) {

	 if ( (bad_name_list[i].acc_cred_ok)==FALSE )
	    continue;

	 bad_name = bad_name_list[i].name;

	 XVEB((V_TEST, "Testing context establishment with acceptor cred for \"%.128s\"\n",
		       bad_name ));

	 rci = sap_establish_context( verbose_level, SNC_CONTEXT_FLAGS, GSS_C_INDEFINITE,
				      p_gssfp_ini, p_gssfp_acc, &x_ini, &x_acc,
				      SNC_SIMPLE_CRED, SNC_MISNAMED_CRED,
				      (p_gssfp_ini->acceptor), (p_gssfp_ini->acceptor_len), &maj_stat );

	 if ( GSS_ERROR(maj_stat)!=GSS_S_COMPLETE ) {
	   /*  rci = (rci>0) ? rci-1 : rci ; */
	 }

	 rci += release_ctx_desc( &x_ini );
	 rci += release_ctx_desc( &x_acc );

	 XVEB((V_RESULT, rci, 0, NULL ));
	 rc += rci;

      }

   }


   return(rc);

} /* errors_with_contexts() */
