/*
 * Decompiled with CFR 0.152.
 */
package html.engine;

import html.engine.HtmlEngineListener;
import html.parser.ParserException;
import html.tags.HtmlParser;
import java.net.URL;
import java.util.Properties;
import java.util.Vector;

public class HtmlEngine {
    static final int PARSER_PRIORITY = 4;
    HtmlParser parser;
    private Thread parseThread = null;
    Vector listeners = new Vector(1, 1);
    static String file = null;
    static String globaldtd = System.getProperty("dtd", "loose");
    static boolean gui = true;
    static boolean audio = true;
    static boolean debug = false;
    static Properties sysProps = System.getProperties();

    public void launch() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            HtmlEngineListener l = (HtmlEngineListener)this.listeners.elementAt(i);
            l.initialize(this);
        }
        this.openDocument(file);
    }

    public void openDocument(String name) {
        URL url;
        try {
            url = new URL(null, name);
        }
        catch (Exception x) {
            x.printStackTrace();
            return;
        }
        this.openDocument(url);
    }

    public void openDocument(URL url) {
        try {
            this.parser = new HtmlParser(null, globaldtd, "" + url);
        }
        catch (ParserException e) {
            e.printStackTrace();
            return;
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            HtmlEngineListener l = (HtmlEngineListener)this.listeners.elementAt(i);
            l.openDocument(url, this.parser);
        }
        this.parseThread = new Thread(this.parser);
        this.parseThread.setPriority(4);
        this.parseThread.start();
    }

    public synchronized void terminate() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            HtmlEngineListener l = (HtmlEngineListener)this.listeners.elementAt(i);
            l.terminate();
        }
        System.exit(0);
    }

    private static void parseArgs(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("-tree")) continue;
            if (args[i].startsWith("-nogui")) {
                gui = false;
                continue;
            }
            if (args[i].startsWith("-noaudio")) {
                audio = false;
                continue;
            }
            if (args[i].equals("-v")) {
                sysProps.put("html.parser.DTDParser.verbose", "true");
                sysProps.put("html.tags.verbose", "true");
                continue;
            }
            if (args[i].startsWith("-debug")) {
                debug = true;
                continue;
            }
            if (args[i].startsWith("-dp")) {
                sysProps.put("html.parser.debug", "true");
                continue;
            }
            if (args[i].startsWith("-dC")) {
                sysProps.put("CSS.StyleSheet.debug", "true");
                continue;
            }
            if (args[i].startsWith("-dS")) {
                System.out.println("speech should be debugged");
                sysProps.put("speech.debug", "true");
                continue;
            }
            if (args[i].startsWith("-d")) {
                sysProps.put("html.parser.debug", "true");
                sysProps.put("html.aural.debug", "true");
                sysProps.put("html.tree.debug", "true");
                sysProps.put("html.tags.debug", "true");
                sysProps.put("speech.debug", "true");
                sysProps.put("CSS.StyleSheet.debug", "true");
                continue;
            }
            if (args[i].startsWith("-dtd")) {
                globaldtd = args[++i];
                continue;
            }
            file = args[i];
            if (file.indexOf(58) != -1) continue;
            file = "file://" + System.getProperty("user.dir") + "/" + file;
        }
    }

    public void addEngineListener(HtmlEngineListener listener) {
        this.listeners.addElement(listener);
    }

    public void removeEngineListener(HtmlEngineListener listener) {
        this.listeners.removeElement(listener);
        this.listeners.trimToSize();
    }
}

