/*
 * Decompiled with CFR 0.152.
 */
package html.tags;

import html.tags.HtmlStreamListener;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;

class HtmlInputStream
extends FilterInputStream {
    Vector listeners = new Vector();
    int lines = 0;
    int bytes = 0;

    public HtmlInputStream(InputStream in) {
        super(in);
    }

    public int read() throws IOException {
        int c = super.read();
        if (c == 10) {
            ++this.lines;
        }
        if (c != -1) {
            ++this.bytes;
            this.notifyActivity();
        }
        return c;
    }

    public int read(byte[] b) throws IOException {
        int c = super.read(b);
        for (int i = 0; i < c; ++i) {
            if (b[i] != 10) continue;
            ++this.lines;
        }
        if (c != -1) {
            this.bytes += c;
            this.notifyActivity();
        }
        return c;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int c = super.read(b, off, len);
        for (int i = 0; i < c; ++i) {
            if (b[i + off] != 10) continue;
            ++this.lines;
        }
        if (c != -1) {
            this.bytes += c;
            this.notifyActivity();
        }
        return c;
    }

    public void addHtmlStreamListener(HtmlStreamListener l) {
        this.listeners.addElement(l);
    }

    public void removeHtmlStreamListener(HtmlStreamListener l) {
        this.listeners.removeElement(l);
    }

    protected void notifyActivity() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            HtmlStreamListener l = (HtmlStreamListener)this.listeners.elementAt(i);
            l.notifyActivity(this.lines, this.bytes);
        }
    }
}

