/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigadm.editors;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.w3c.jigadm.RemoteResourceWrapper;
import org.w3c.jigadm.editors.AttributeEditor;
import org.w3c.jigsaw.admin.RemoteAccessException;
import org.w3c.jigsaw.admin.RemoteResource;
import org.w3c.tools.codec.Base64Encoder;
import org.w3c.tools.resources.Attribute;
import org.w3c.tools.sorter.Comparable;
import org.w3c.tools.sorter.Sorter;
import org.w3c.tools.widgets.AnswerListener;
import org.w3c.tools.widgets.BorderPanel;
import org.w3c.tools.widgets.ClosableFrame;
import org.w3c.tools.widgets.MessagePopup;
import org.w3c.tools.widgets.PasswordPopup;
import org.w3c.tools.widgets.QuestionPopup;
import org.w3c.www.protocol.http.proxy.Rule;
import org.w3c.www.protocol.http.proxy.RuleNode;
import org.w3c.www.protocol.http.proxy.RuleParser;
import org.w3c.www.protocol.http.proxy.RuleParserException;

public class DispatcherRulesEditor
extends AttributeEditor {
    private DispatcherComponent widget = null;
    protected String origs = "";

    public void clearChanged() {
        this.origs = this.widget.getRulesLocation();
    }

    protected void createComponent(String string) {
        this.widget = new DispatcherComponent(this, string);
    }

    public Component getComponent() {
        return this.widget;
    }

    public Object getValue() {
        return this.widget.getRulesLocation();
    }

    public boolean hasChanged() {
        return this.origs.equals(this.widget.getRulesLocation()) ^ true;
    }

    public void initialize(RemoteResourceWrapper remoteResourceWrapper, Attribute attribute, Object object, Properties properties) throws RemoteAccessException {
        RemoteResource remoteResource = remoteResourceWrapper.getResource();
        if (object == null) {
            String string = null;
            string = (String)remoteResource.getValue(attribute.getName());
            if (string == null && attribute.getDefault() != null) {
                string = attribute.getDefault().toString();
            }
            if (string != null) {
                this.origs = string;
            }
        } else {
            this.origs = object.toString();
        }
        this.createComponent(this.origs);
    }

    public void resetChanges() {
        this.widget.setRulesLocation(this.origs);
    }

    public void setValue(Object object) {
        this.widget.setRulesLocation(object.toString());
    }

    class RulesEditorFrame
    extends ClosableFrame
    implements ActionListener,
    ItemListener,
    AnswerListener {
        protected Label location = null;
        protected List lrules = null;
        protected TextField thost = null;
        protected TextField trule = null;
        protected Choice crule = null;
        protected Choice cargs = null;
        protected TextField targs = null;
        protected Button removeB = null;
        protected Button addB = null;
        protected Button replaceB = null;
        protected QuestionPopup exitAnyway = null;
        protected Hashtable hargs = null;
        protected RulesEditor editor = null;
        protected int selected = -1;
        protected boolean modified = false;

        RulesEditorFrame(RulesEditor rulesEditor) {
            super("Proxy Dispatcher Rules Editor");
            this.editor = rulesEditor;
            this.lrules = new List(20, false);
            this.lrules.setBackground(Color.white);
            this.lrules.addItemListener(this);
            this.createRulesChoice();
            this.createArgsChoice();
            this.update();
            EditorMenu editorMenu = new EditorMenu(this);
            this.setMenuBar(editorMenu);
            BorderPanel borderPanel = new BorderPanel(4, 5);
            borderPanel.setLayout(new BorderLayout());
            borderPanel.add(this.lrules);
            this.thost = new TextField(20);
            this.trule = new TextField(15);
            this.trule.setEditable(false);
            BorderPanel borderPanel2 = new BorderPanel(3, 2);
            borderPanel2.setLayout(new GridLayout(1, 1));
            borderPanel2.add(this.trule);
            this.targs = new TextField(30);
            Panel panel = new Panel();
            panel.add(new Label("Host: "));
            Panel panel2 = new Panel(new BorderLayout());
            panel2.add((Component)new Label("Rule: "), "West");
            panel2.add((Component)this.crule, "Center");
            Panel panel3 = new Panel(new BorderLayout());
            panel3.add((Component)new Label("Args: "), "West");
            panel3.add((Component)this.cargs, "Center");
            BorderPanel borderPanel3 = new BorderPanel(3, 2);
            borderPanel3.setLayout(new GridLayout(2, 1));
            borderPanel3.add(panel);
            borderPanel3.add(this.thost);
            BorderPanel borderPanel4 = new BorderPanel(3, 2);
            borderPanel4.setLayout(new GridLayout(2, 1));
            borderPanel4.add(panel2);
            borderPanel4.add(this.trule);
            BorderPanel borderPanel5 = new BorderPanel(3, 2);
            borderPanel5.setLayout(new GridLayout(2, 1));
            borderPanel5.add(panel3);
            borderPanel5.add(this.targs);
            BorderPanel borderPanel6 = new BorderPanel(4, 5);
            borderPanel6.setLayout(new GridLayout(1, 3));
            borderPanel6.add(borderPanel3);
            borderPanel6.add(borderPanel4);
            borderPanel6.add(borderPanel5);
            this.addB = new Button("Add Rule");
            this.addB.setActionCommand("add");
            this.addB.addActionListener(this);
            this.replaceB = new Button("Replace Rule");
            this.replaceB.setActionCommand("replace");
            this.replaceB.addActionListener(this);
            this.removeB = new Button("Remove Rule");
            this.removeB.setActionCommand("remove");
            this.removeB.addActionListener(this);
            Panel panel4 = new Panel(new GridLayout(1, 3));
            panel4.add(this.addB);
            panel4.add(this.replaceB);
            panel4.add(this.removeB);
            this.location = new Label("Rules location: " + rulesEditor.component.getRulesLocation());
            BorderPanel borderPanel7 = new BorderPanel(1, 1);
            borderPanel7.setLayout(new FlowLayout());
            borderPanel7.add(this.location);
            BorderPanel borderPanel8 = new BorderPanel(4, 5);
            borderPanel8.setLayout(new GridLayout(2, 1));
            borderPanel8.add(panel4);
            borderPanel8.add(borderPanel7);
            Panel panel5 = new Panel(new BorderLayout());
            panel5.add((Component)borderPanel, "Center");
            panel5.add((Component)borderPanel6, "South");
            this.add((Component)panel5, "Center");
            this.add((Component)borderPanel8, "South");
            ((Component)this).setSize(800, 600);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("add")) {
                this.add();
            } else if (string.equals("remove")) {
                this.remove();
            } else if (string.equals("replace")) {
                this.replace();
            } else if (string.equals("save")) {
                this.save();
            } else if (string.equals("dismiss")) {
                this.quit();
            }
        }

        protected void add() {
            Rule rule = null;
            try {
                String[] stringArray = this.getTokens();
                if (stringArray != null) {
                    rule = this.editor.addRule(stringArray);
                }
            }
            catch (RuleParserException ruleParserException) {
                this.error(ruleParserException);
            }
            if (rule != null) {
                this.lrules.addItem(rule.toString());
                this.updateArgsList(rule.getRuleArgs());
                this.setModified(true);
            }
        }

        protected void close() {
            this.quit();
        }

        protected void createArgsChoice() {
            this.cargs = new Choice();
            this.hargs = new Hashtable(10);
            this.cargs.addItemListener(this);
        }

        protected void createRulesChoice() {
            this.crule = new Choice();
            String[] stringArray = Rule.getRulesName();
            int n = 0;
            while (n < stringArray.length) {
                this.crule.add(stringArray[n]);
                ++n;
            }
            this.crule.addItemListener(this);
        }

        protected void error(Exception exception) {
            this.error(exception.getMessage());
        }

        protected void error(String string) {
            new MessagePopup("Error: " + string).show();
        }

        protected void error(String string, Exception exception) {
            this.error(String.valueOf(string) + ": " + exception.getMessage());
        }

        protected String getAuthFromDialog() {
            PasswordPopup passwordPopup = new PasswordPopup();
            Frame frame = new Frame("Authorization required");
            ((Component)frame).setBackground(Color.lightGray);
            ((Component)frame).setSize(new Dimension(300, 200));
            frame.setLayout(new BorderLayout());
            frame.add("Center", passwordPopup);
            frame.show();
            passwordPopup.init();
            while (!passwordPopup.waitForCompletion()) {
            }
            ((Component)frame).setVisible(false);
            if (passwordPopup.canceled()) {
                return null;
            }
            Base64Encoder base64Encoder = new Base64Encoder(String.valueOf(passwordPopup.getUserName()) + ":" + passwordPopup.getPassword());
            frame.dispose();
            return base64Encoder.processString();
        }

        protected boolean getModified() {
            return this.modified;
        }

        protected String[] getTokens() {
            Object[] objectArray;
            String string = this.trule.getText();
            String string2 = this.thost.getText();
            if (string == null || string.length() == 0) {
                this.error("You must specify a rule");
                return null;
            }
            if (string2 == null || string2.length() == 0) {
                this.error("You must specify a host");
                return null;
            }
            Vector<String> vector = new Vector<String>(3);
            vector.addElement(string2);
            vector.addElement(string);
            String string3 = this.targs.getText();
            if (string3 != null) {
                objectArray = new StringTokenizer(string3);
                while (objectArray.hasMoreTokens()) {
                    vector.addElement(objectArray.nextToken());
                }
            }
            objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            Object object = itemEvent.getSource();
            if (object == this.lrules) {
                this.selected = (Integer)itemEvent.getItem();
                this.showRule(this.selected);
            } else if (object == this.crule) {
                String string = (String)itemEvent.getItem();
                this.trule.setText(string);
                if (string.equals("direct") || string.equals("forbid")) {
                    this.targs.setEditable(false);
                    this.targs.setText("");
                } else {
                    this.targs.setEditable(true);
                }
            } else if (object == this.cargs) {
                String string = (String)itemEvent.getItem();
                if (this.targs.isEditable()) {
                    this.targs.setText(string);
                }
            }
        }

        protected void msg(String string) {
            new MessagePopup(string).show();
        }

        protected void msg(String string, String string2) {
            this.msg(String.valueOf(string) + ": " + string2);
        }

        public void questionAnswered(Object object, int n) {
            if (object == this.exitAnyway) {
                ((Component)this.exitAnyway).setVisible(false);
                if (n == 1) {
                    ((Component)this).setVisible(false);
                }
            }
        }

        protected void quit() {
            if (this.getModified()) {
                if (this.exitAnyway == null) {
                    this.exitAnyway = new QuestionPopup((Frame)this, "Rules Modified, Quit anyway?");
                    this.exitAnyway.registerAnswerListener(this);
                }
                this.exitAnyway.show();
            } else {
                ((Component)this).setVisible(false);
            }
        }

        protected void remove() {
            if (this.selected != -1) {
                this.editor.removeRule(this.selected);
                this.lrules.remove(this.selected);
                this.setModified(true);
            } else {
                this.error("No rule selected");
            }
        }

        protected void replace() {
            if (this.selected == -1) {
                this.error("No rule selected");
                return;
            }
            Rule rule = null;
            try {
                String[] stringArray = this.getTokens();
                if (stringArray != null) {
                    rule = this.editor.replaceRule(stringArray, this.selected);
                }
            }
            catch (RuleParserException ruleParserException) {
                this.error(ruleParserException);
            }
            if (rule != null) {
                this.lrules.replaceItem(rule.toString(), this.selected);
                this.setModified(true);
            }
        }

        protected void save() {
            this.editor.save();
            this.setModified(false);
        }

        protected void setModified(boolean bl) {
            this.modified = bl;
        }

        protected void showRule(int n) {
            Rule rule = this.editor.getRule(n);
            this.thost.setText(rule.getHost());
            this.trule.setText(rule.getRuleName());
            String string = rule.getRuleArgs();
            if (string != null) {
                this.targs.setText(string);
                this.targs.setEditable(true);
            } else {
                this.targs.setEditable(false);
                this.targs.setText("");
            }
        }

        protected void update() {
            int n = this.editor.getSize();
            Rule rule = null;
            this.setModified(false);
            this.selected = -1;
            if (this.lrules != null) {
                this.lrules.removeAll();
                int n2 = 0;
                while (n2 < n) {
                    rule = this.editor.getRule(n2);
                    this.lrules.addItem(rule.toString(), n2);
                    this.updateArgsList(rule.getRuleArgs());
                    ++n2;
                }
            }
            if (this.location != null) {
                this.location.setText("Rules location: " + this.editor.component.getRulesLocation());
            }
        }

        protected void updateArgsList(String string) {
            if (string != null && this.hargs.get(string) == null) {
                this.hargs.put(string, Boolean.TRUE);
                this.cargs.add(string);
            }
        }

        class EditorMenu
        extends MenuBar
        implements ActionListener {
            RulesEditorFrame frame = null;

            EditorMenu(RulesEditorFrame rulesEditorFrame2) {
                this.frame = rulesEditorFrame2;
                Menu menu = new Menu("File");
                this.add(menu);
                MenuItem menuItem = new MenuItem("Save Rules");
                menuItem.setActionCommand("save");
                menuItem.addActionListener(this);
                menu.add(menuItem);
                MenuItem menuItem2 = new MenuItem("Quit");
                menuItem2.setActionCommand("quit");
                menuItem2.addActionListener(this);
                menu.add(menuItem2);
                Menu menu2 = new Menu("Rule");
                this.add(menu2);
                MenuItem menuItem3 = new MenuItem("Add Rule");
                menuItem3.setActionCommand("add");
                menuItem3.addActionListener(this);
                menu2.add(menuItem3);
                MenuItem menuItem4 = new MenuItem("Replace Rule");
                menuItem4.setActionCommand("replace");
                menuItem4.addActionListener(this);
                menu2.add(menuItem4);
                MenuItem menuItem5 = new MenuItem("Remove Rule");
                menuItem5.setActionCommand("remove");
                menuItem5.addActionListener(this);
                menu2.add(menuItem5);
            }

            public void actionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                if (string.equals("save")) {
                    this.frame.save();
                } else if (string.equals("quit")) {
                    this.frame.quit();
                } else if (string.equals("add")) {
                    this.frame.add();
                } else if (string.equals("replace")) {
                    this.frame.replace();
                } else if (string.equals("remove")) {
                    this.frame.remove();
                }
            }
        }
    }

    class RulesEditor {
        protected URL rulesUrl = null;
        protected File rulesFile = null;
        protected RulesEditorFrame gui = null;
        protected HttpURLConnection con = null;
        protected String auth = null;
        protected DispatcherComponent component = null;
        protected Vector rules = null;

        RulesEditor(DispatcherComponent dispatcherComponent, File file) {
            this.component = dispatcherComponent;
            this.rulesFile = file;
            this.parse();
            DispatcherRulesEditor dispatcherRulesEditor2 = DispatcherRulesEditor.this;
            dispatcherRulesEditor2.getClass();
            this.gui = dispatcherRulesEditor2.new RulesEditorFrame(this);
        }

        RulesEditor(DispatcherComponent dispatcherComponent, URL uRL) {
            this.component = dispatcherComponent;
            this.rulesUrl = uRL;
            this.parse();
            DispatcherRulesEditor dispatcherRulesEditor2 = DispatcherRulesEditor.this;
            dispatcherRulesEditor2.getClass();
            this.gui = dispatcherRulesEditor2.new RulesEditorFrame(this);
        }

        protected Rule addRule(String[] stringArray) throws RuleParserException {
            Rule rule = null;
            rule = Rule.createRule(stringArray, 1, stringArray.length);
            if (rule != null) {
                if (this.rules == null) {
                    this.rules = new Vector(10);
                }
                this.rules.addElement(rule);
            }
            return rule;
        }

        protected boolean closeRulesOutputStream(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.flush();
            dataOutputStream.close();
            if (this.rulesUrl != null && this.con != null) {
                ((URLConnection)this.con).getHeaderField(0);
                int n = this.con.getResponseCode();
                switch (n) {
                    case 401: {
                        String string = this.gui.getAuthFromDialog();
                        if (string == null) {
                            return true;
                        }
                        this.setAuthorization(string);
                        return false;
                    }
                    case 200: 
                    case 201: 
                    case 204: {
                        this.gui.msg("Proxy dispatcher rules saved.");
                        return true;
                    }
                }
                this.gui.msg("HTTP error", this.con.getResponseMessage());
                return true;
            }
            this.gui.msg("Proxy dispatcher rules saved.");
            return true;
        }

        protected void collectRules(RuleNode ruleNode, Vector vector) {
            Hashtable hashtable = ruleNode.getChildren();
            if (hashtable != null) {
                Enumeration enumeration = hashtable.keys();
                while (enumeration.hasMoreElements()) {
                    RuleNode ruleNode2 = (RuleNode)hashtable.get((String)enumeration.nextElement());
                    Rule rule = ruleNode2.getRule();
                    if (rule != null) {
                        vector.addElement(rule);
                    }
                    this.collectRules(ruleNode2, vector);
                }
            }
        }

        protected Vector generateRuleVector(RuleNode ruleNode) {
            Vector<Object> vector = new Vector<Object>(20);
            this.collectRules(ruleNode, vector);
            Object[] objectArray = new Rule[vector.size()];
            vector.copyInto(objectArray);
            objectArray = (Rule[])Sorter.sortComparableArray((Comparable[])objectArray, true);
            int n = 0;
            while (n < objectArray.length) {
                vector.setElementAt(objectArray[n], n);
                ++n;
            }
            return vector;
        }

        protected String getAuthorization() {
            return this.auth;
        }

        protected Rule getRule(int n) {
            return (Rule)this.rules.elementAt(n);
        }

        protected InputStream getRulesInputStream() throws IOException {
            InputStream inputStream = null;
            if (this.rulesUrl != null) {
                inputStream = this.rulesUrl.openStream();
            } else if (this.rulesFile.exists()) {
                inputStream = new BufferedInputStream(new FileInputStream(this.rulesFile));
            }
            return inputStream;
        }

        protected DataOutputStream getRulesOutputStream() throws IOException {
            DataOutputStream dataOutputStream = null;
            if (this.rulesUrl != null) {
                this.con = (HttpURLConnection)this.rulesUrl.openConnection();
                this.con.setRequestMethod("PUT");
                this.con.setRequestProperty("content-type", "text/plain");
                if (this.hasAuthorization()) {
                    this.con.setRequestProperty("Authorization", "Basic " + this.getAuthorization());
                }
                this.con.setDoOutput(true);
                this.con.setDoInput(true);
                this.con.setAllowUserInteraction(true);
                dataOutputStream = new DataOutputStream(this.con.getOutputStream());
            } else {
                dataOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this.rulesFile)));
            }
            return dataOutputStream;
        }

        protected int getSize() {
            if (this.rules == null) {
                return 0;
            }
            return this.rules.size();
        }

        protected boolean hasAuthorization() {
            return this.auth != null;
        }

        protected void parse() {
            InputStream inputStream = null;
            try {
                inputStream = this.getRulesInputStream();
            }
            catch (Exception exception) {
                this.gui.error("Unable to open input stream");
                return;
            }
            try {
                if (inputStream != null) {
                    RuleParser ruleParser = new RuleParser(inputStream);
                    RuleNode ruleNode = ruleParser.parse();
                    this.rules = this.generateRuleVector(ruleNode);
                } else {
                    this.rules = new Vector();
                }
            }
            catch (Exception exception) {
                this.gui.error("Rules parser error", exception);
            }
        }

        protected void removeRule(int n) {
            this.rules.removeElementAt(n);
        }

        protected Rule replaceRule(String[] stringArray, int n) throws RuleParserException {
            Rule rule = null;
            rule = Rule.createRule(stringArray, 1, stringArray.length);
            if (rule != null) {
                if (this.rules == null) {
                    this.rules = new Vector(10);
                }
                this.rules.setElementAt(rule, n);
            }
            return rule;
        }

        protected void save() {
            new Saver(this).start();
        }

        protected void saveRules() {
            DataOutputStream dataOutputStream = null;
            try {
                do {
                    dataOutputStream = this.getRulesOutputStream();
                    if (this.rules == null) continue;
                    dataOutputStream.writeBytes("#\n# Generated by proxy dispatcher rules editor.\n#\n");
                    int n = 0;
                    while (n < this.rules.size()) {
                        ((Rule)this.rules.elementAt(n)).writeRule(dataOutputStream);
                        ++n;
                    }
                } while (!this.closeRulesOutputStream(dataOutputStream));
            }
            catch (Exception exception) {
                this.gui.error("Unable to save rules", exception);
            }
        }

        protected void setAuthorization(String string) {
            this.auth = string;
        }

        protected void setFile(File file) {
            this.rulesUrl = null;
            this.rulesFile = file;
            this.parse();
        }

        protected void setURL(URL uRL) {
            this.rulesFile = null;
            this.rulesUrl = uRL;
            this.parse();
        }

        public void show() {
            this.gui.update();
            this.gui.show();
        }

        class Saver
        extends Thread {
            RulesEditor editor = null;

            Saver(RulesEditor rulesEditor2) {
                this.editor = rulesEditor2;
            }

            public void run() {
                this.editor.saveRules();
            }
        }
    }

    class DispatcherComponent
    extends BorderPanel
    implements ActionListener {
        protected RulesEditor reditor = null;
        protected TextField locationEd = null;
        protected DispatcherRulesEditor editor = null;

        DispatcherComponent(DispatcherRulesEditor dispatcherRulesEditor2, String string) {
            super(3, 2);
            this.editor = dispatcherRulesEditor2;
            this.locationEd = new TextField(20);
            if (string != null) {
                this.locationEd.setText(string);
            }
            Button button = new Button("Edit Rules");
            button.setActionCommand("edit");
            button.addActionListener(this);
            this.setLayout(new BorderLayout());
            this.add((Component)this.locationEd, "Center");
            this.add((Component)button, "East");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string;
            String string2 = actionEvent.getActionCommand();
            if (string2 != null && (string = this.getRulesLocation()) != null && string.length() > 0) {
                try {
                    URL uRL = new URL(string);
                    if (uRL.getProtocol().equalsIgnoreCase("file")) {
                        File file = new File(uRL.getFile());
                        if (this.reditor == null) {
                            this.reditor = new RulesEditor(this, file);
                        } else {
                            this.reditor.setFile(file);
                        }
                    } else if (this.reditor == null) {
                        this.reditor = new RulesEditor(this, uRL);
                    } else {
                        this.reditor.setURL(uRL);
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    File file = new File(string);
                    if (this.reditor == null) {
                        this.reditor = new RulesEditor(this, file);
                    }
                    this.reditor.setFile(file);
                }
                this.reditor.show();
            }
        }

        public String getRulesLocation() {
            return this.locationEd.getText();
        }

        public void setRulesLocation(String string) {
            this.locationEd.setText(string);
        }
    }
}

