/*
 * Decompiled with CFR 0.152.
 */
package html.parser;

import html.parser.ContentModel;
import html.parser.Element;

public class ContentModelState {
    ContentModel model;
    long value;
    ContentModelState next;

    public ContentModelState(ContentModel model) {
        this(model, null, 0L);
    }

    ContentModelState(Object content, ContentModelState next) {
        this(content, next, 0L);
    }

    ContentModelState(Object content, ContentModelState next, long value) {
        this.model = (ContentModel)content;
        this.next = next;
        this.value = value;
    }

    public boolean terminate() {
        switch (this.model.type) {
            case 43: {
                if (this.value == 0L && !this.model.empty()) {
                    return false;
                }
            }
            case 42: 
            case 63: {
                return this.next == null || this.next.terminate();
            }
            case 124: {
                ContentModel m = (ContentModel)this.model.content;
                while (m != null) {
                    if (m.empty()) {
                        return this.next == null || this.next.terminate();
                    }
                    m = m.next;
                }
                return false;
            }
            case 38: {
                ContentModel m = (ContentModel)this.model.content;
                int i = 0;
                while (m != null) {
                    if ((this.value & 1L << i) == 0L && !m.empty()) {
                        return false;
                    }
                    ++i;
                    m = m.next;
                }
                return this.next == null || this.next.terminate();
            }
            case 44: {
                ContentModel m = (ContentModel)this.model.content;
                int i = 0;
                while ((long)i < this.value) {
                    ++i;
                    m = m.next;
                }
                while (m != null && m.empty()) {
                    m = m.next;
                }
                if (m != null) {
                    return false;
                }
                return this.next == null || this.next.terminate();
            }
        }
        return false;
    }

    public Element first() {
        switch (this.model.type) {
            case 38: 
            case 42: 
            case 63: 
            case 124: {
                return null;
            }
            case 43: {
                return this.model.first();
            }
            case 44: {
                ContentModel m = (ContentModel)this.model.content;
                int i = 0;
                while ((long)i < this.value) {
                    ++i;
                    m = m.next;
                }
                return m.first();
            }
        }
        return this.model.first();
    }

    public ContentModelState advance(Object token) throws Exception {
        switch (this.model.type) {
            case 43: {
                if (this.model.first(token)) {
                    return new ContentModelState(this.model.content, new ContentModelState(this.model, this.next, this.value + 1L)).advance(token);
                }
                if (this.value == 0L) break;
                return this.next.advance(token);
            }
            case 42: {
                if (this.model.first(token)) {
                    return new ContentModelState(this.model.content, this).advance(token);
                }
                return this.next.advance(token);
            }
            case 63: {
                if (this.model.first(token)) {
                    return new ContentModelState(this.model.content, this.next).advance(token);
                }
                return this.next.advance(token);
            }
            case 124: {
                ContentModel m = (ContentModel)this.model.content;
                while (m != null) {
                    if (m.first(token)) {
                        return new ContentModelState(m, this.next).advance(token);
                    }
                    m = m.next;
                }
                break;
            }
            case 44: {
                ContentModel m = (ContentModel)this.model.content;
                int i = 0;
                while ((long)i < this.value) {
                    ++i;
                    m = m.next;
                }
                if (!m.first(token) && !m.empty()) break;
                if (m.next == null) {
                    return new ContentModelState(m, this.next).advance(token);
                }
                return new ContentModelState(m, new ContentModelState(this.model, this.next, this.value + 1L)).advance(token);
            }
            case 38: {
                ContentModel m = (ContentModel)this.model.content;
                boolean complete = true;
                int i = 0;
                while (m != null) {
                    if ((this.value & 1L << i) == 0L) {
                        if (m.first(token)) {
                            return new ContentModelState(m, new ContentModelState(this.model, this.next, this.value | 1L << i)).advance(token);
                        }
                        if (!m.empty()) {
                            complete = false;
                        }
                    }
                    ++i;
                    m = m.next;
                }
                if (!complete) break;
                return this.next.advance(token);
            }
            default: {
                if (this.model.content != token) break;
                return this.next;
            }
        }
        throw new Exception("invalid token: " + token);
    }
}

