/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.css1;

import org.w3c.css.parser.CssPrinterStyle;
import org.w3c.css.parser.CssSelectors;
import org.w3c.css.parser.CssStyle;
import org.w3c.css.properties.css1.Css1Style;
import org.w3c.css.properties.css1.CssBackgroundAttachment;
import org.w3c.css.properties.css1.CssBackgroundColor;
import org.w3c.css.properties.css1.CssBackgroundConstants;
import org.w3c.css.properties.css1.CssBackgroundImage;
import org.w3c.css.properties.css1.CssBackgroundPosition;
import org.w3c.css.properties.css1.CssBackgroundRepeat;
import org.w3c.css.properties.css1.CssProperty;
import org.w3c.css.properties.css3.CssBackgroundSize;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssOperator;
import org.w3c.css.values.CssValue;

public class CssBackground
extends CssProperty
implements CssOperator,
CssBackgroundConstants {
    CssBackgroundColor color;
    CssBackgroundImage image;
    CssBackgroundRepeat repeat;
    CssBackgroundAttachment attachment;
    CssBackgroundPosition position;
    CssBackgroundSize size;
    boolean sizedefined;
    boolean same;

    public CssBackground() {
    }

    public CssBackground(ApplContext ac, CssExpression expression) throws InvalidParamException {
        this(ac, expression, false);
    }

    public CssBackground(ApplContext ac, CssExpression expression, boolean check2) throws InvalidParamException {
        boolean manyValues;
        CssValue val = expression.getValue();
        char op = ' ';
        boolean find = true;
        this.setByUser();
        if (check2 && expression.getCount() > 6) {
            throw new InvalidParamException("unrecognize", ac);
        }
        boolean bl = manyValues = expression.getCount() > 1;
        while (find) {
            find = false;
            val = expression.getValue();
            op = expression.getOperator();
            if (val == null) break;
            if (manyValues && val != null && val.equals(inherit)) {
                throw new InvalidParamException("unrecognize", null, null, ac);
            }
            if (this.color == null) {
                try {
                    this.color = new CssBackgroundColor(ac, expression);
                    find = true;
                }
                catch (InvalidParamException e) {
                    // empty catch block
                }
            }
            if (!find && this.image == null) {
                try {
                    this.image = new CssBackgroundImage(ac, expression);
                    find = true;
                }
                catch (InvalidParamException e) {
                    // empty catch block
                }
            }
            if (!find && this.repeat == null) {
                try {
                    this.repeat = new CssBackgroundRepeat(ac, expression);
                    find = true;
                }
                catch (InvalidParamException e) {
                    // empty catch block
                }
            }
            if (!find && this.attachment == null) {
                try {
                    this.attachment = new CssBackgroundAttachment(ac, expression);
                    find = true;
                }
                catch (InvalidParamException e) {
                    // empty catch block
                }
            }
            if (!find && this.position == null) {
                try {
                    this.position = new CssBackgroundPosition(ac, expression);
                    find = true;
                }
                catch (InvalidParamException e) {
                    // empty catch block
                }
            }
            if (op != ' ') {
                if (op != '/') {
                    throw new InvalidParamException("operator", new Character(op).toString(), ac);
                }
                this.size = new CssBackgroundSize(ac, expression);
                this.sizedefined = true;
                break;
            }
            if (!check2 || find || val == null) continue;
            throw new InvalidParamException("unrecognize", ac);
        }
    }

    public Object get() {
        return this.color;
    }

    public final CssValue getColor() {
        if (this.color == null) {
            return null;
        }
        return this.color.getColor();
    }

    public String getPropertyName() {
        return "background";
    }

    public String toString() {
        String ret = "";
        if (this.color != null) {
            ret = ret + this.color;
        }
        if (this.image != null) {
            if (ret != null) {
                ret = ret + " ";
            }
            ret = ret + this.image;
        }
        if (this.repeat != null) {
            if (ret != null) {
                ret = ret + " ";
            }
            ret = ret + this.repeat;
        }
        if (this.attachment != null) {
            if (ret != null) {
                ret = ret + " ";
            }
            ret = ret + this.attachment;
        }
        if (this.position != null) {
            if (ret != null) {
                ret = ret + " ";
            }
            ret = ret + this.position;
        }
        if (this.sizedefined) {
            ret = ret + "/";
            ret = ret + this.size;
        }
        return ret;
    }

    public void setImportant() {
        if (this.color != null) {
            this.color.important = true;
        }
        if (this.image != null) {
            this.image.important = true;
        }
        if (this.repeat != null) {
            this.repeat.important = true;
        }
        if (this.attachment != null) {
            this.attachment.important = true;
        }
        if (this.position != null) {
            this.position.important = true;
        }
    }

    public boolean getImportant() {
        return !(this.color != null && !this.color.important || this.image != null && !this.image.important || this.repeat != null && !this.repeat.important || this.attachment != null && !this.attachment.important || this.position != null && !this.position.important);
    }

    public void print(CssPrinterStyle printer) {
        if (!(this.color == null || this.image == null || this.repeat == null || this.attachment == null || this.position == null || !this.getImportant() && (this.image.important || this.color.important || this.repeat.important || this.attachment.important || this.position.important))) {
            if (this.color.byUser || this.image.byUser || this.repeat.byUser || this.attachment.byUser || this.position.byUser) {
                printer.print(this);
            }
        } else {
            if (this.color != null) {
                this.color.print(printer);
            }
            if (this.image != null) {
                this.image.print(printer);
            }
            if (this.repeat != null) {
                this.repeat.print(printer);
            }
            if (this.attachment != null) {
                this.attachment.print(printer);
            }
            if (this.position != null) {
                this.position.print(printer);
            }
        }
    }

    public void setSelectors(CssSelectors selector) {
        super.setSelectors(selector);
        if (this.color != null) {
            this.color.setSelectors(selector);
        }
        if (this.image != null) {
            this.image.setSelectors(selector);
        }
        if (this.repeat != null) {
            this.repeat.setSelectors(selector);
        }
        if (this.attachment != null) {
            this.attachment.setSelectors(selector);
        }
        if (this.position != null) {
            this.position.setSelectors(selector);
        }
    }

    public void addToStyle(ApplContext ac, CssStyle style) {
        ((Css1Style)style).cssBackground.same = this.same;
        ((Css1Style)style).cssBackground.byUser = this.byUser;
        if (this.color != null) {
            this.color.addToStyle(ac, style);
        }
        if (this.image != null) {
            this.image.addToStyle(ac, style);
        }
        if (this.repeat != null) {
            this.repeat.addToStyle(ac, style);
        }
        if (this.attachment != null) {
            this.attachment.addToStyle(ac, style);
        }
        if (this.position != null) {
            this.position.addToStyle(ac, style);
        }
    }

    public CssProperty getPropertyInStyle(CssStyle style, boolean resolve) {
        if (resolve) {
            return ((Css1Style)style).getBackground();
        }
        return ((Css1Style)style).cssBackground;
    }

    public boolean equals(CssProperty property) {
        return false;
    }

    public void setInfo(int line, String source) {
        super.setInfo(line, source);
        if (this.color != null) {
            this.color.setInfo(line, source);
        }
        if (this.image != null) {
            this.image.setInfo(line, source);
        }
        if (this.repeat != null) {
            this.repeat.setInfo(line, source);
        }
        if (this.attachment != null) {
            this.attachment.setInfo(line, source);
        }
        if (this.position != null) {
            this.position.setInfo(line, source);
        }
    }
}

