/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.util;

import java.io.InputStream;
import java.net.URL;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.w3c.css.util.Utf8Properties;

public class Messages {
    public Utf8Properties properties;
    private static Hashtable languages;

    public Messages(String lang) {
        if (lang != null) {
            StringTokenizer lanTok = new StringTokenizer(lang, ",");
            int maxTok = lanTok.countTokens();
            String[] slang = new String[maxTok];
            float[] qlang = new float[maxTok];
            block0: while (lanTok.hasMoreTokens()) {
                String l = lanTok.nextToken().trim().toLowerCase();
                int qualsep = l.indexOf(59);
                float qval = 1.0f;
                if (qualsep != -1) {
                    String p = l.substring(qualsep + 1);
                    l = l.substring(0, qualsep);
                    if (p.startsWith("q=")) {
                        qval = Float.parseFloat(p.substring(2));
                    }
                }
                for (int i = 0; i < maxTok; ++i) {
                    if (slang[i] == null) {
                        slang[i] = l;
                        qlang[i] = qval;
                        continue block0;
                    }
                    if (!(qval > qlang[i])) continue;
                    System.arraycopy(slang, i, slang, i + 1, maxTok - i - 1);
                    System.arraycopy(qlang, i, qlang, i + 1, maxTok - i - 1);
                    slang[i] = l;
                    qlang[i] = qval;
                    continue block0;
                }
            }
            for (int i = 0; i < maxTok; ++i) {
                String l = slang[i];
                this.properties = (Utf8Properties)languages.get(l);
                if (this.properties != null) break;
                int minusIndex = l.indexOf(45);
                if (minusIndex != -1) {
                    l = l.substring(0, minusIndex);
                    this.properties = (Utf8Properties)languages.get(l);
                }
                if (this.properties != null) break;
            }
        }
        if (this.properties == null) {
            this.properties = (Utf8Properties)languages.get("en");
        }
    }

    public String getString(String message) {
        return this.properties.getProperty(message);
    }

    public String getWarningString(String message) {
        return this.getString("warning." + message);
    }

    public String getWarningLevelString(String message) {
        return this.getString("warning." + message + ".level");
    }

    public String getErrorString(String message) {
        return this.getString("error." + message);
    }

    public String getGeneratorString(String message) {
        return this.getString("generator." + message);
    }

    public String getGeneratorString(String message, String param) {
        String str = this.getString("generator." + message);
        int i = str.indexOf("%s");
        if (i >= 0) {
            str = str.substring(0, i) + param + str.substring(i + 2);
        }
        return str;
    }

    public String getServletString(String message) {
        return this.getString("servlet." + message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Utf8Properties tmp;
        InputStream f;
        URL url;
        languages = new Hashtable();
        try {
            url = Messages.class.getResource("Messages.properties.en");
            f = url.openStream();
            try {
                tmp = new Utf8Properties();
                tmp.load(f);
                languages.put("en", tmp);
            }
            finally {
                f.close();
            }
        }
        catch (Exception e) {
            System.err.println("org.w3c.css.util.Messages: couldn't load properties en");
            System.err.println("  " + e.toString());
        }
        try {
            url = Messages.class.getResource("Messages.properties.zh-cn");
            f = url.openStream();
            try {
                tmp = new Utf8Properties();
                tmp.load(f);
                languages.put("zh-cn", tmp);
            }
            finally {
                f.close();
            }
        }
        catch (Exception e) {
            System.err.println("org.w3c.css.util.Messages: couldn't load properties cn");
            System.err.println("  " + e.toString());
        }
        try {
            url = Messages.class.getResource("Messages.properties.ja");
            f = url.openStream();
            try {
                tmp = new Utf8Properties();
                tmp.load(f);
                languages.put("ja", tmp);
            }
            finally {
                f.close();
            }
        }
        catch (Exception e) {
            System.err.println("org.w3c.css.util.Messages: couldn't load properties ja");
            System.err.println("  " + e.toString());
        }
        try {
            url = Messages.class.getResource("Messages.properties.fr");
            f = url.openStream();
            try {
                tmp = new Utf8Properties();
                tmp.load(f);
                languages.put("fr", tmp);
                languages.put("fr_FR", tmp);
            }
            finally {
                f.close();
            }
        }
        catch (Exception e) {
            System.err.println("org.w3c.css.util.Messages: couldn't load properties fr");
            System.err.println("  " + e.toString());
        }
        try {
            url = Messages.class.getResource("Messages.properties.de");
            f = url.openStream();
            try {
                tmp = new Utf8Properties();
                tmp.load(f);
                languages.put("de", tmp);
                languages.put("de_DE", tmp);
                languages.put("de_AT", tmp);
                languages.put("de_CH", tmp);
            }
            finally {
                f.close();
            }
        }
        catch (Exception e) {
            System.err.println("org.w3c.css.util.Messages: couldn't load properties de");
            System.err.println("  " + e.toString());
        }
        try {
            url = Messages.class.getResource("Messages.properties.nl");
            f = url.openStream();
            try {
                tmp = new Utf8Properties();
                tmp.load(f);
                languages.put("nl", tmp);
            }
            finally {
                f.close();
            }
        }
        catch (Exception e) {
            System.err.println("org.w3c.css.util.Messages: couldn't load properties nl");
            System.err.println("  " + e.toString());
        }
        try {
            url = Messages.class.getResource("Messages.properties.es");
            f = url.openStream();
            try {
                tmp = new Utf8Properties();
                tmp.load(f);
                languages.put("es", tmp);
                languages.put("es_ES", tmp);
            }
            finally {
                f.close();
            }
        }
        catch (Exception e) {
            System.err.println("org.w3c.css.util.Messages: couldn't load properties es");
            System.err.println("  " + e.toString());
        }
    }
}

