/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.www.http;

import org.w3c.www.http.BasicValue;
import org.w3c.www.http.HttpBuffer;
import org.w3c.www.http.HttpParser;
import org.w3c.www.http.HttpParserException;
import org.w3c.www.http.ParseState;

public class HttpContentRange
extends BasicValue {
    int firstpos = -1;
    int lastpos = -1;
    int length = -1;
    String unit = null;

    HttpContentRange() {
        this.isValid = false;
    }

    public HttpContentRange(boolean bl, String string, int n, int n2, int n3) {
        this.isValid = true;
        this.setUnit(string);
        this.setFirstPosition(n);
        this.setLastPosition(n2);
        this.setFullLength(n3);
    }

    public int getFirstPosition() {
        this.validate();
        return this.firstpos;
    }

    public int getFullLength() {
        this.validate();
        return this.length;
    }

    public int getLastPosition() {
        this.validate();
        return this.lastpos;
    }

    public String getUnit() {
        this.validate();
        return this.unit;
    }

    public Object getValue() {
        return this;
    }

    protected void parse() throws HttpParserException {
        ParseState parseState = new ParseState();
        parseState.ioff = 0;
        parseState.bufend = this.raw.length;
        parseState.separator = (byte)32;
        if (HttpParser.nextItem(this.raw, parseState) < 0) {
            this.error("Invalid byte range (no byte unit).");
        }
        this.unit = new String(this.raw, 0, parseState.start, parseState.end - parseState.start);
        parseState.separator = (byte)45;
        parseState.prepare();
        if (HttpParser.nextItem(this.raw, parseState) < 0) {
            this.error("Invalid byte range (no first position).");
        }
        ParseState parseState2 = new ParseState();
        parseState2.ioff = parseState.start;
        parseState2.bufend = parseState.end;
        this.firstpos = HttpParser.parseInt(this.raw, parseState2);
        parseState.prepare();
        parseState.separator = (byte)47;
        if (HttpParser.nextItem(this.raw, parseState) < 0) {
            this.error("Invalid byte range (no last position).");
        }
        parseState2.ioff = parseState.start;
        parseState2.bufend = parseState.end;
        this.lastpos = HttpParser.parseInt(this.raw, parseState2);
        parseState.prepare();
        if (HttpParser.nextItem(this.raw, parseState) < 0) {
            this.error("Invalid byte range (no full length).");
        }
        parseState2.ioff = parseState.start;
        parseState2.bufend = parseState.end;
        this.length = this.raw[parseState2.ioff] == 42 && parseState.end - parseState.start == 1 ? -1 : HttpParser.parseInt(this.raw, parseState2);
    }

    public void setFirstPosition(int n) {
        if (n != this.firstpos) {
            this.invalidateByteValue();
        }
        this.firstpos = n;
    }

    public void setFullLength(int n) {
        if (n != this.length) {
            this.invalidateByteValue();
        }
        this.length = n;
    }

    public void setLastPosition(int n) {
        if (n != this.lastpos) {
            this.invalidateByteValue();
        }
        this.lastpos = n;
    }

    public void setUnit(String string) {
        this.invalidateByteValue();
        this.unit = string;
    }

    protected void updateByteValue() {
        HttpBuffer httpBuffer = new HttpBuffer();
        httpBuffer.append(this.unit);
        httpBuffer.append((byte)32);
        httpBuffer.appendInt(this.firstpos);
        httpBuffer.append('-');
        httpBuffer.appendInt(this.lastpos);
        httpBuffer.append('/');
        if (this.length < 0) {
            httpBuffer.append('*');
        } else {
            httpBuffer.appendInt(this.length);
        }
        this.raw = httpBuffer.getByteCopy();
        this.roff = 0;
        this.rlen = this.raw.length;
    }
}

