/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.www.protocol.http.cache.push;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.util.TreeMap;

public class PushCacheProtocol {
    public static final int PACKET_LEN = 16;
    public static final int COMMAND_LEN = 4;
    public static final int HEADER_LEN = 8;
    public static final int TAG_LEN = 4;
    public static final int MAX_STRING_LEN = 1024;
    public static final int MAX_PAYLOAD_LEN = 8192;
    public static final short MAJ_PROTO_VERSION = 1;
    public static final short MIN_PROTO_VERSION = 2;
    public static final int NO_SUCH_COMMAND = -1;
    public static final int ERR = 0;
    public static final int ADD = 1;
    public static final int DEL = 2;
    public static final int CLN = 3;
    public static final int PRS = 4;
    public static final int BYE = 5;
    public static final int OK = 6;
    public static final int NO = 7;
    public static final int NOP = 8;
    private static PushCacheProtocol _instance;
    private TreeMap _map;
    private byte[] _ok_packet_bytes = null;
    private byte[] _no_packet_bytes = null;
    private byte[] _err_packet_bytes = null;
    private byte[] _header = null;

    protected PushCacheProtocol() {
        try {
            this._map = new TreeMap();
            this._map.put("ERR\u0000", new Integer(0));
            this._map.put("ADD\u0000", new Integer(1));
            this._map.put("DEL\u0000", new Integer(2));
            this._map.put("CLN\u0000", new Integer(3));
            this._map.put("PRS\u0000", new Integer(4));
            this._map.put("BYE\u0000", new Integer(5));
            this._map.put("OK\u0000\u0000", new Integer(6));
            this._map.put("NO\u0000\u0000", new Integer(7));
            this._map.put("NOP\u0000", new Integer(8));
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(16);
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeByte(80);
            dataOutputStream.writeByte(67);
            dataOutputStream.writeByte(80);
            dataOutputStream.writeByte(80);
            dataOutputStream.writeShort(1);
            dataOutputStream.writeShort(2);
            this._header = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream = new ByteArrayOutputStream(16);
            dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.write(this._header, 0, this._header.length);
            dataOutputStream.writeBytes("OK\u0000\u0000");
            dataOutputStream.writeInt(0);
            this._ok_packet_bytes = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream = null;
            dataOutputStream = null;
            byteArrayOutputStream = new ByteArrayOutputStream(16);
            dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.write(this._header, 0, this._header.length);
            dataOutputStream.writeBytes("NO\u0000\u0000");
            dataOutputStream.writeInt(0);
            this._no_packet_bytes = byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public byte[] errorPacket(String string) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(16);
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.write(this._header, 0, this._header.length);
            dataOutputStream.writeBytes("ERR\u0000");
            dataOutputStream.writeInt(string.length());
            dataOutputStream.writeBytes(string);
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public byte[] header() {
        return this._header;
    }

    public static PushCacheProtocol instance() {
        if (_instance == null) {
            _instance = new PushCacheProtocol();
        }
        return _instance;
    }

    public boolean isValidProtocolTag(byte[] byArray) {
        return byArray[0] == 80 && byArray[1] == 67 || byArray[2] == 80 && byArray[3] == 80;
    }

    public byte[] noPacket() {
        return this._no_packet_bytes;
    }

    public byte[] okPacket() {
        return this._ok_packet_bytes;
    }

    public int parseCommand(String string) {
        Integer n = (Integer)this._map.get(string);
        if (n == null) {
            return -1;
        }
        return n;
    }
}

