/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.www.protocol.http.icp;

import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import org.w3c.www.protocol.http.icp.ICPMessage;
import org.w3c.www.protocol.http.icp.ICPProtocolException;

class ICPQuery
extends ICPMessage {
    ICPQuery(int n, URL uRL) {
        this.opcode = 1;
        this.id = n;
        this.url = uRL;
    }

    ICPQuery(InetAddress inetAddress, int n, int n2, int n3, byte[] byArray, int n4, int n5) throws ICPProtocolException {
        this.addr = inetAddress;
        this.port = n;
        this.opcode = n2;
        this.version = n3;
        this.parse(byArray, n4, n5);
    }

    protected int getByteArrayLength() {
        return super.getByteArrayLength() + 4 + 4 + (this.url == null ? 0 : this.url.toExternalForm().length()) + 1;
    }

    protected int parse(byte[] byArray, int n, int n2) throws ICPProtocolException {
        n = super.parse(byArray, n, n2);
        n += 4;
        int n3 = n += 4;
        while (n3 < n2) {
            if (byArray[n3] == 0) {
                if (n3 - n < 1) {
                    return n3;
                }
                String string = new String(byArray, 0, n, n3 - n);
                try {
                    this.url = new URL(string);
                }
                catch (MalformedURLException malformedURLException) {
                    throw new ICPProtocolException("Invalid URL:" + string);
                }
                return n3;
            }
            ++n3;
        }
        throw new ICPProtocolException("Invalid URL encoding");
    }

    protected int toByteArray(byte[] byArray) {
        int n = super.getByteArrayLength();
        String string = this.url == null ? null : this.url.toExternalForm();
        int n2 = string == null ? 0 : string.length();
        super.toByteArray(byArray);
        n += 4;
        n += 4;
        if (n2 > 0) {
            string.getBytes(0, n2, byArray, n);
        }
        byArray[n + n2] = 0;
        return n + n2 + 1;
    }
}

