/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tools.resources;

import java.util.Vector;
import org.w3c.tools.resources.ProtocolException;
import org.w3c.tools.resources.ReplyInterface;
import org.w3c.tools.resources.RequestInterface;

public class LookupState {
    private int index;
    private String[] components;
    private String[] componentstype;
    private RequestInterface request;
    private boolean is_directory = false;
    private boolean is_internal = false;
    private String uri = null;
    private String query = null;
    private String fragment = null;
    private String type = null;

    public LookupState(String string) throws ProtocolException {
        this.request = null;
        this.is_internal = true;
        this.uri = string;
        this.parseURI();
    }

    public LookupState(RequestInterface requestInterface) throws ProtocolException {
        this.request = requestInterface;
        this.uri = requestInterface.getURLPath();
        this.is_internal = requestInterface.isInternal();
        if (this.uri == null) {
            ReplyInterface replyInterface = requestInterface.makeBadRequestReply();
            replyInterface.setContent("Invalid URI (unparsable)");
            throw new ProtocolException(replyInterface);
        }
        this.parseURI();
    }

    public int countRemainingComponents() {
        return this.components.length - this.index;
    }

    public String getFragment() {
        return this.fragment;
    }

    public final String getNextComponent() {
        if (this.request != null) {
            this.request.setState("type", this.componentstype[this.index]);
        }
        return this.components[this.index++];
    }

    public String getQuery() {
        return this.query;
    }

    public final String getRemainingPath() {
        return this.getRemainingPath(false);
    }

    public final String getRemainingPath(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.index;
        while (n < this.components.length) {
            stringBuffer.append("/" + this.components[n]);
            ++n;
        }
        if (bl) {
            this.index = this.components.length;
        }
        return stringBuffer.toString();
    }

    public final RequestInterface getRequest() {
        return this.request;
    }

    public String getType() {
        return this.componentstype[this.index];
    }

    public String getURI() {
        return this.uri;
    }

    public boolean hasMoreComponents() {
        return this.index < this.components.length;
    }

    public boolean hasRequest() {
        return this.request != null;
    }

    public boolean isDirectory() {
        return this.is_directory;
    }

    public boolean isInternal() {
        return this.is_internal;
    }

    public void markInternal() {
        this.is_internal = true;
    }

    protected void parseURI() throws ProtocolException {
        int n = this.uri.length();
        int n2 = 0;
        int n3 = -1;
        int n4 = -1;
        Vector<String> vector = new Vector<String>(8);
        int n5 = this.uri.indexOf(63, n2);
        int n6 = this.uri.indexOf(35, n2);
        int n7 = -1;
        n7 = n5 >= 0 && n6 >= 0 ? Math.min(n5, n6) : (n5 >= 0 ? n5 : (n6 >= 0 ? n6 : n));
        if (n7 < 0) {
            n7 = n;
        }
        this.uri = this.uri;
        while ((n3 = this.uri.indexOf(47, n2)) < n7 && n3 >= 0) {
            if (n3 == n2) {
                n2 = n3 + 1;
                continue;
            }
            if (n3 <= 0) continue;
            String string = LookupState.unescape(this.uri.substring(n2, n3));
            n4 = string.indexOf(59);
            if (n4 == -1) {
                if (string.indexOf(47) != -1) {
                    String string2 = this.uri.substring(n2, n3);
                    vector.addElement(string2);
                } else {
                    vector.addElement(string);
                }
            } else {
                int n8 = string.indexOf(47);
                if (n8 >= 0) {
                    if (n4 < n8) {
                        vector.addElement(string);
                    } else {
                        vector.addElement(this.uri.substring(n2, n3));
                    }
                }
            }
            n2 = n3 + 1;
        }
        if (n5 >= 0 || n6 >= 0) {
            if (n5 >= 0 && n6 > n5) {
                if (n5 + 1 < n6) {
                    this.query = this.uri.substring(n5 + 1, n6);
                }
                if (n6 + 1 < n) {
                    this.fragment = this.uri.substring(n6 + 1, n);
                }
            } else if (n6 >= 0 && n5 > n6) {
                if (n6 + 1 < n5) {
                    this.fragment = this.uri.substring(n6 + 1, n5);
                }
                if (n5 + 1 < n) {
                    this.query = this.uri.substring(n5 + 1, n);
                }
            } else if (n6 >= 0) {
                if (n6 + 1 < n) {
                    this.fragment = this.uri.substring(n6 + 1, n);
                }
            } else if (n5 >= 0 && n5 + 1 < n) {
                this.query = this.uri.substring(n5 + 1, n);
            }
        }
        if (this.request != null) {
            if (this.query != null) {
                this.request.setState("query", this.query);
            }
            if (this.fragment != null) {
                this.request.setState("frag", this.fragment);
            }
        }
        if (n2 < n7) {
            vector.addElement(LookupState.unescape(this.uri.substring(n2, n7)));
        }
        if (--n7 >= 0) {
            this.is_directory = this.uri.charAt(n7) == '/';
        }
        this.components = new String[vector.size()];
        this.componentstype = new String[vector.size()];
        vector.copyInto(this.components);
        int n9 = 0;
        while (n9 < this.components.length) {
            n4 = this.components[n9].indexOf(59);
            if (n4 >= 0) {
                this.componentstype[n9] = this.components[n9].substring(n4 + 1);
                this.components[n9] = this.components[n9].substring(0, n4);
            }
            if (this.components[n9].indexOf(47) >= 0) {
                throw new ProtocolException("encoded % in URI are forbidden on this server");
            }
            ++n9;
        }
        this.index = 0;
    }

    public final String peekNextComponent() {
        if (this.index < this.components.length) {
            return this.components[this.index];
        }
        return null;
    }

    public static String unescape(String string) {
        int n = string.length();
        boolean bl = false;
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c == '%' || c == '+') {
                bl = true;
                break;
            }
            ++n2;
        }
        if (bl) {
            char[] cArray = new char[n];
            int n3 = 0;
            int n4 = -1;
            int n5 = 0;
            while (n5 < n) {
                char c = string.charAt(n5);
                n4 = c;
                switch (c) {
                    case '%': {
                        n4 = string.charAt(++n5);
                        int n6 = (Character.isDigit((char)n4) ? n4 - 48 : 10 + Character.toLowerCase((char)n4) - 97) & 0xF;
                        n4 = string.charAt(++n5);
                        int n7 = (Character.isDigit((char)n4) ? n4 - 48 : 10 + Character.toLowerCase((char)n4) - 97) & 0xF;
                        if ((n6 << 4 | n7) <= 0) break;
                        cArray[n3++] = (char)(n6 << 4 | n7);
                        break;
                    }
                    case '+': {
                        cArray[n3++] = 32;
                        break;
                    }
                    default: {
                        cArray[n3++] = (char)n4;
                    }
                }
                ++n5;
            }
            return new String(cArray, 0, n3);
        }
        return string;
    }
}

