/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.www.protocol.http.cache;

import java.util.Enumeration;
import org.w3c.www.protocol.http.cache.CacheFilter;
import org.w3c.www.protocol.http.cache.CacheGeneration;
import org.w3c.www.protocol.http.cache.CacheStore;
import org.w3c.www.protocol.http.cache.CacheSweeper;
import org.w3c.www.protocol.http.cache.CachedResource;

public class SimpleCacheSweeper
extends CacheSweeper {
    private static final boolean debug = false;
    private static final int WAIT_MIN = 5000;
    private static final int WAIT_MAX = 60000;
    protected int state = 1;
    private CacheFilter filter = null;
    private boolean signal = false;
    private long wait_time = 60000L;

    protected long collectCached(long l, boolean bl) {
        long l2 = 0L;
        CacheStore cacheStore = this.filter.getStore();
        CacheGeneration cacheGeneration = cacheStore.getLRUGeneration();
        while (cacheGeneration != null) {
            CacheGeneration cacheGeneration2 = this.filter.getStore().getPrevGeneration(cacheGeneration);
            if ((l2 += cacheGeneration.collectSpace(l - l2, bl)) >= l) break;
            cacheGeneration = cacheGeneration2;
        }
        return l2;
    }

    protected long collectCached(CacheGeneration cacheGeneration, long l, boolean bl) {
        if (l > 0L) {
            return cacheGeneration.collectSpace(l, bl);
        }
        return 0L;
    }

    protected void collectStored() {
        CacheGeneration cacheGeneration = this.filter.getStore().getLRUGeneration();
        while (cacheGeneration != null) {
            this.collectStored(cacheGeneration);
            cacheGeneration = this.filter.getStore().getPrevGeneration(cacheGeneration);
        }
    }

    protected void collectStored(CacheGeneration cacheGeneration) {
        Enumeration enumeration = cacheGeneration.getDeletedResources();
        while (enumeration.hasMoreElements()) {
            CachedResource cachedResource = (CachedResource)enumeration.nextElement();
            cacheGeneration.deleteStored(cachedResource);
        }
    }

    public void garbageCollect() {
        switch (this.state) {
            case 1: {
                try {
                    this.collectStored();
                }
                catch (Exception exception) {}
                break;
            }
            case 2: {
                CacheStore cacheStore = this.filter.getStore();
                synchronized (cacheStore) {
                    this.collectStored();
                    break;
                }
            }
            case 3: {
                long l = this.filter.getStore().getRequiredByteNumber();
                try {
                    l -= this.collectCached(l, true);
                    l -= this.collectCached(l, false);
                    this.collectStored();
                }
                catch (Exception exception) {}
                break;
            }
            case 4: {
                CacheStore cacheStore = this.filter.getStore();
                synchronized (cacheStore) {
                    long l = this.filter.getStore().getRequiredByteNumber();
                    l -= this.collectCached(l, true);
                    l -= this.collectCached(l, false);
                    this.collectStored();
                    break;
                }
            }
        }
        this.filter.getStore().updateSweeperPriority();
    }

    public void initialize(CacheFilter cacheFilter) {
        this.filter = cacheFilter;
        this.setDaemon(true);
        this.setPriority(3);
        this.setName("CacheSweeper");
    }

    public void run() {
        while (true) {
            try {
                while (true) {
                    this.waitSignal();
                    this.garbageCollect();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                continue;
            }
            break;
        }
    }

    protected synchronized void setState(int n) {
        this.state = n;
    }

    public synchronized void signal() {
        this.signal = true;
        this.notifyAll();
    }

    public synchronized void waitSignal() {
        long l = 0L;
        long l2 = 0L;
        this.signal = false;
        this.wait_time = 5000L;
        while (!this.signal) {
            try {
                this.wait(this.wait_time);
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            if (this.signal) break;
            try {
                this.collectStored();
            }
            catch (Exception exception) {}
            CacheStore cacheStore = this.filter.getStore();
            this.wait_time = (long)(60000.0f * (1.0f - cacheStore.getMRUGenerationRatio())) / (long)this.state;
            this.wait_time = Math.max(5000L, Math.min(this.wait_time, 60000L));
            l += this.wait_time;
            if ((l2 += this.wait_time) >= cacheStore.getCompactGenerationDelay()) {
                l2 = 0L;
                cacheStore.compactGenerations();
            }
            if (l < cacheStore.getSyncDelay()) continue;
            l = 0L;
            cacheStore.sync();
        }
        this.signal = false;
    }
}

