/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigsaw.forms;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Hashtable;
import org.w3c.jigsaw.forms.URLDecoderException;

public class URLDecoder {
    public static final String EMPTY_VALUE = "";
    int ch = -1;
    Hashtable values = null;
    byte[] buffer = new byte[1024];
    int bsize = 0;
    Reader in = null;
    boolean overide = true;
    String enc = null;

    public URLDecoder(InputStream inputStream) {
        this(inputStream, true, null);
    }

    public URLDecoder(InputStream inputStream, boolean bl) {
        this(inputStream, bl, null);
    }

    public URLDecoder(InputStream inputStream, boolean bl, String string) {
        this.values = new Hashtable(23);
        this.in = new InputStreamReader(inputStream);
        this.ch = -1;
        this.overide = bl;
        this.enc = string;
    }

    public URLDecoder(Reader reader) {
        this(reader, true, null);
    }

    public URLDecoder(Reader reader, boolean bl) {
        this(reader, bl, null);
    }

    public URLDecoder(Reader reader, boolean bl, String string) {
        this.values = new Hashtable(23);
        this.in = reader;
        this.ch = -1;
        this.overide = bl;
        this.enc = string;
    }

    protected void addVariable(String string, String string2) {
        if (this.overide) {
            this.values.put(string, string2);
        } else {
            Object v = this.values.get(string);
            if (v == null) {
                this.values.put(string, string2);
            } else if (v instanceof String[]) {
                String[] stringArray = (String[])v;
                String[] stringArray2 = new String[stringArray.length + 1];
                System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
                stringArray2[stringArray.length] = string2;
                this.values.put(string, stringArray2);
            } else if (v instanceof String) {
                String[] stringArray = new String[]{(String)v, string2};
                this.values.put(string, stringArray);
            }
        }
    }

    private void append(int n) {
        if (this.bsize + 1 >= this.buffer.length) {
            byte[] byArray = new byte[this.buffer.length * 2];
            System.arraycopy(this.buffer, 0, byArray, 0, this.buffer.length);
            this.buffer = byArray;
        }
        this.buffer[this.bsize++] = (byte)n;
    }

    public String[] getMultipleValues(String string) {
        if (this.overide) {
            throw new RuntimeException(String.valueOf(this.getClass().getName()) + "[getMultipleValues]: " + " overide not set !");
        }
        Object v = this.values.get(string);
        if (v instanceof String[]) {
            return (String[])v;
        }
        String[] stringArray = new String[]{(String)v};
        this.values.put(string, stringArray);
        return stringArray;
    }

    public String getValue(String string) {
        Object v = this.values.get(string);
        if (v != null && !(v instanceof String)) {
            throw new RuntimeException(String.valueOf(this.getClass().getName()) + "[getValue]:" + " use getMultipleValues in:\n\t" + string + " " + v);
        }
        return (String)v;
    }

    public Enumeration keys() {
        return this.values.keys();
    }

    public Hashtable parse() throws IOException, URLDecoderException {
        String string = null;
        this.ch = this.in.read();
        while (true) {
            switch (this.ch) {
                case 43: {
                    this.append(32);
                    break;
                }
                case 37: {
                    int n = this.ch = this.in.read();
                    if (this.ch == -1) {
                        throw new URLDecoderException("Invalid escape seq.");
                    }
                    int n2 = this.ch = this.in.read();
                    if (this.ch == -1) {
                        throw new URLDecoderException("Invalid escape seq.");
                    }
                    n = Character.isDigit((char)n) ? n - 48 : 10 + (Character.toUpperCase((char)n) - 65);
                    n2 = Character.isDigit((char)n2) ? n2 - 48 : 10 + (Character.toUpperCase((char)n2) - 65);
                    this.append((char)((byte)n2 | (byte)n << 4));
                    break;
                }
                case 38: {
                    if (string == null) {
                        this.addVariable(this.stringify(this.buffer, 0, this.bsize), EMPTY_VALUE);
                        this.bsize = 0;
                        break;
                    }
                    this.addVariable(string, this.stringify(this.buffer, 0, this.bsize));
                    string = null;
                    this.bsize = 0;
                    break;
                }
                case 59: {
                    if (string == null) {
                        this.addVariable(this.stringify(this.buffer, 0, this.bsize), EMPTY_VALUE);
                        this.bsize = 0;
                        break;
                    }
                    this.addVariable(string, this.stringify(this.buffer, 0, this.bsize));
                    string = null;
                    this.bsize = 0;
                    break;
                }
                case 61: {
                    if (string != null) {
                        this.append(this.ch);
                        break;
                    }
                    string = this.stringify(this.buffer, 0, this.bsize);
                    this.bsize = 0;
                    break;
                }
                case -1: {
                    if (string == null) {
                        this.addVariable(this.stringify(this.buffer, 0, this.bsize), EMPTY_VALUE);
                        this.bsize = 0;
                    } else {
                        this.addVariable(string, this.stringify(this.buffer, 0, this.bsize));
                        string = null;
                        this.bsize = 0;
                    }
                    return this.values;
                }
                default: {
                    this.append(this.ch);
                }
            }
            this.ch = this.in.read();
        }
    }

    private String stringify(byte[] byArray, int n, int n2) throws URLDecoderException {
        String string = null;
        if (this.enc != null) {
            try {
                string = new String(byArray, n, n2, this.enc);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new URLDecoderException("Unsupported Encoding: " + this.enc);
            }
        } else {
            string = new String(byArray, n, n2);
        }
        return string;
    }
}

