/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.www.http;

import org.w3c.www.http.BasicValue;
import org.w3c.www.http.HttpBuffer;
import org.w3c.www.http.HttpEntityTagList;
import org.w3c.www.http.HttpParser;
import org.w3c.www.http.HttpParserException;
import org.w3c.www.http.ParseState;

public class HttpEntityTag
extends BasicValue {
    boolean weak = false;
    String tag = null;
    HttpEntityTagList list = null;

    public HttpEntityTag() {
        this.isValid = false;
    }

    HttpEntityTag(HttpEntityTagList httpEntityTagList, byte[] byArray, int n, int n2) {
        this.list = httpEntityTagList;
        this.raw = byArray;
        this.isValid = false;
        this.roff = n;
        this.rlen = n2;
    }

    HttpEntityTag(boolean bl, boolean bl2, String string) {
        this.isValid = bl;
        this.weak = bl2;
        this.tag = string;
    }

    public String getTag() {
        this.validate();
        return this.tag;
    }

    public Object getValue() {
        return this;
    }

    protected void invalidateByteValue() {
        super.invalidateByteValue();
        if (this.list != null) {
            this.list.invalidateByteValue();
        }
    }

    public boolean isWeak() {
        this.validate();
        return this.weak;
    }

    protected void parse() throws HttpParserException {
        ParseState parseState = new ParseState();
        parseState.ioff = this.roff;
        parseState.bufend = this.rlen;
        parseState.separator = (byte)47;
        if (HttpParser.nextItem(this.raw, parseState) < 0) {
            this.error("Invalid entity tag.");
        }
        if (this.raw[parseState.start] == 87 || this.raw[parseState.start] == 119) {
            this.weak = true;
            parseState.prepare();
            if (HttpParser.nextItem(this.raw, parseState) < 0) {
                this.error("Invalid weak entity tag.");
            }
            parseState.ioff = parseState.start;
            parseState.bufend = parseState.end;
            HttpParser.unquote(this.raw, parseState);
            this.tag = parseState.toString(this.raw);
        } else {
            this.weak = false;
            parseState.ioff = parseState.start;
            parseState.bufend = parseState.end;
            HttpParser.unquote(this.raw, parseState);
            this.tag = parseState.toString(this.raw);
        }
    }

    public void setTag(String string) {
        if (!string.equals(this.tag)) {
            this.invalidateByteValue();
        }
        this.tag = string;
    }

    public void setWeak(boolean bl) {
        if (bl != this.weak) {
            this.invalidateByteValue();
        }
        this.weak = bl;
    }

    protected void updateByteValue() {
        this.validate();
        HttpBuffer httpBuffer = new HttpBuffer(20);
        if (this.weak) {
            httpBuffer.append('W');
            httpBuffer.append('/');
        }
        httpBuffer.appendQuoted(this.tag);
        this.raw = httpBuffer.getByteCopy();
        this.roff = 0;
        this.rlen = this.raw.length;
    }
}

