/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.www.mux;

import java.io.IOException;
import java.io.OutputStream;
import org.w3c.www.mux.MuxSession;
import org.w3c.www.mux.MuxWriter;

public class MuxOutputStream
extends OutputStream {
    protected static final boolean debug = false;
    protected MuxSession session = null;
    protected int sessid = -1;
    protected MuxWriter writer = null;
    protected int fragsz = 512;
    protected int avail_credit = 4096;
    protected boolean closed = false;

    protected MuxOutputStream(MuxSession muxSession) {
        this.session = muxSession;
        this.sessid = muxSession.getIdentifier();
        this.writer = muxSession.getMuxStream().getMuxWriter();
    }

    public synchronized void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.session.sendFIN();
        this.notifyAll();
    }

    public void flush() throws IOException {
        this.writer.flush();
    }

    protected synchronized void notifyControl(int n) {
        this.fragsz = n;
    }

    protected synchronized void notifyCredit(int n) {
        this.avail_credit += n;
        this.notifyAll();
    }

    /*
     * Unable to fully structure code
     */
    private synchronized void send(byte[] var1_1, int var2_2, int var3_3) throws IOException {
        ** GOTO lbl29
        {
            if (this.closed) {
                throw new IOException("Broken pipe");
            }
            this.writer.flush();
            try {
                this.wait();
            }
            catch (InterruptedException v0) {
                throw new IOException("Interrupted IO !");
            }
            do {
                if (this.avail_credit <= 0) continue block2;
                while (this.avail_credit > 0) {
                    if (this.fragsz <= 0) {
                        var4_4 = Math.min(this.avail_credit, var3_3);
                        this.writer.writeData(this.sessid, var1_1, var2_2, var4_4);
                        var3_3 -= var4_4;
                        var2_2 += var4_4;
                        this.avail_credit -= var4_4;
                        continue;
                    }
                    if (var3_3 < this.fragsz) {
                        this.writer.writeData(this.sessid, var1_1, var2_2, var3_3);
                        this.avail_credit -= var3_3;
                        return;
                    }
                    this.writer.writeData(this.sessid, var1_1, var2_2, this.fragsz);
                    var3_3 -= this.fragsz;
                    var2_2 += this.fragsz;
                    this.avail_credit -= this.fragsz;
                }
lbl29:
                // 2 sources

            } while (var3_3 > 0);
        }
    }

    public void write(int n) throws IOException {
        byte[] byArray = new byte[]{(byte)(n & 0xFF)};
        this.write(byArray, 0, 1);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.send(byArray, n, n2);
    }
}

