/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.www.mux;

import java.io.IOException;
import java.io.OutputStream;
import org.w3c.www.mux.MUX;
import org.w3c.www.mux.MuxStream;

class MuxWriter
implements MUX {
    private static final byte[] padbytes = new byte[8];
    private static final boolean debug = true;
    protected MuxStream stream = null;
    protected byte[] buffer = new byte[4096];
    protected int buflen = 0;
    protected int bufptr = 0;
    protected OutputStream out = null;

    MuxWriter(MuxStream muxStream, OutputStream outputStream) throws IOException {
        this.stream = muxStream;
        this.out = outputStream;
        this.buffer = new byte[4096];
        this.bufptr = 0;
        this.buflen = 0;
    }

    protected void ctrlDefineStack(int n, int[] nArray) throws IOException {
        int n2 = 0xC4000000 | n & 0x3FFFF;
        int n3 = nArray.length << 1;
        MuxWriter muxWriter = this;
        synchronized (muxWriter) {
            this.encodeWord(n2);
            this.encodeWord(n3);
            this.emitShortArray(nArray);
        }
    }

    protected void ctrlDefineString(int n, String string) throws IOException {
        int n2 = 0xC0000000 | n & 0x3FFFF;
        int n3 = string.length();
        MuxWriter muxWriter = this;
        synchronized (muxWriter) {
            this.encodeWord(n2);
            this.encodeWord(n3);
            this.emitData(string, n3);
        }
    }

    protected void ctrlMuxControl(int n, int n2) throws IOException {
        int n3 = 0xC8000000 | n << 18 | n2 & 0x3FFFF;
        MuxWriter muxWriter = this;
        synchronized (muxWriter) {
            this.encodeWord(n3);
            this.encodeWord(0);
        }
    }

    protected void ctrlSendCredit(int n, int n2) throws IOException {
        int n3 = 0xCC000000 | n << 18;
        MuxWriter muxWriter = this;
        synchronized (muxWriter) {
            this.encodeWord(n3);
            this.encodeWord(n2);
        }
    }

    private final void emitData(String string, int n) throws IOException {
        if (n < 0) {
            n = string.length();
        }
        if (!this.ensureCapacity(n)) {
            throw new RuntimeException("String to big to hold in buffer !");
        }
        string.getBytes(0, n, this.buffer, this.bufptr + this.buflen);
        this.buflen += n;
    }

    private final void emitData(byte[] byArray, int n, int n2) throws IOException {
        if (n2 <= 0) {
            return;
        }
        if (this.ensureCapacity(n2)) {
            System.arraycopy(byArray, n, this.buffer, this.bufptr + this.buflen, n2);
            this.buflen += n2;
        } else {
            this.flush();
            this.out.write(byArray, n, n2);
        }
    }

    private final void emitShortArray(int[] nArray) throws IOException {
        if (!this.ensureCapacity(nArray.length << 1)) {
            throw new RuntimeException("Array to bug to hold in buffer.");
        }
        int n = 0;
        while (n < nArray.length) {
            this.encodeShort((short)(nArray[n] & 0xFFFF));
            ++n;
        }
    }

    private final void encodeLongMessage(int n, int n2, int n3, int n4) throws IOException {
        this.ensureCapacity(8);
        int n5 = n | (n2 & 0xFF) << 18 | n3;
        System.out.println("sending h=" + Integer.toString(n5, 16) + ", l=" + Integer.toString(n4, 16));
        this.encodeWord(n5);
        this.encodeWord(n4);
    }

    private final void encodeMessage(int n, int n2, int n3) throws IOException {
        this.ensureCapacity(4);
        int n4 = n | (n2 & 0xFF) << 18 | n3;
        System.out.println("sending h=" + Integer.toString(n4, 16));
        this.encodeWord(n4);
    }

    private final void encodeShort(short s) {
        int n = this.bufptr + this.buflen;
        this.buffer[n++] = (byte)(s & 0xFF);
        this.buffer[n++] = (byte)((s & 0xFF00) >> 8);
        this.buflen += 2;
    }

    private final void encodeWord(int n) {
        int n2 = this.bufptr + this.buflen;
        this.buffer[n2++] = (byte)(n & 0xFF);
        this.buffer[n2++] = (byte)((n & 0xFF00) >> 8);
        this.buffer[n2++] = (byte)((n & 0xFF0000) >> 16);
        this.buffer[n2++] = (byte)((n & 0xFF000000) >> 24);
        this.buflen += 4;
        System.out.println("[encodeWord] 0x" + Integer.toString(this.buffer[this.bufptr], 16) + Integer.toString(this.buffer[this.bufptr + 1], 16) + Integer.toString(this.buffer[this.bufptr + 2], 16) + Integer.toString(this.buffer[this.bufptr + 3], 16));
    }

    private boolean ensureCapacity(int n) throws IOException {
        if (this.bufptr + this.buflen + n < this.buffer.length) {
            return true;
        }
        if (this.buffer.length < n) {
            this.flush();
            return true;
        }
        return false;
    }

    protected synchronized void flush() throws IOException {
        if (this.buflen > 0) {
            this.out.write(this.buffer, this.bufptr, this.buflen);
            this.bufptr = 0;
            this.buflen = 0;
        }
    }

    protected synchronized boolean needsFlush() {
        return this.buflen > 0;
    }

    protected synchronized void shutdown() {
        this.buffer = null;
    }

    protected synchronized void writeData(int n, byte[] byArray, int n2, int n3) throws IOException {
        this.encodeMessage(0, n, n3);
        if (n3 > 0) {
            int n4;
            this.emitData(byArray, n2, n3);
            int n5 = n4 = (n3 & 3) != 0 ? 4 - (n3 & 3) : 0;
            if (n4 != 0) {
                this.emitData(padbytes, 0, n4);
            }
        }
    }

    protected synchronized void writeMessage(int n, int n2, int n3) throws IOException {
        this.encodeMessage(n2, n, n3);
    }

    protected synchronized void writeMessage(int n, int n2, int n3, byte[] byArray, int n4, int n5) throws IOException {
        this.encodeLongMessage(n2, n, n3, n5);
        this.emitData(byArray, n4, n5);
    }
}

