/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.css1;

import org.w3c.css.parser.CssStyle;
import org.w3c.css.properties.css1.Css1Style;
import org.w3c.css.properties.css1.CssBackgroundConstants;
import org.w3c.css.properties.css1.CssBackgroundMob;
import org.w3c.css.properties.css1.CssProperty;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssLength;
import org.w3c.css.values.CssNumber;
import org.w3c.css.values.CssOperator;
import org.w3c.css.values.CssPercentage;
import org.w3c.css.values.CssValue;

public class CssBackgroundPositionMob
extends CssProperty
implements CssBackgroundConstants,
CssOperator {
    CssValue horizontal;
    CssValue vertical;
    private static int[] hash_values;
    private static int INVALID;
    private static CssPercentage DefaultValue0;
    private static CssPercentage DefaultValue50;
    private static CssPercentage DefaultValue100;

    public CssBackgroundPositionMob() {
        this.horizontal = DefaultValue0;
        this.vertical = DefaultValue0;
    }

    public CssBackgroundPositionMob(ApplContext ac, CssExpression expression, boolean check2) throws InvalidParamException {
        int index;
        if (check2 && expression.getCount() > 2) {
            throw new InvalidParamException("unrecognize", ac);
        }
        this.setByUser();
        CssValue val = expression.getValue();
        char op = expression.getOperator();
        if (op != ' ') {
            throw new InvalidParamException("operator", new Character(op).toString(), ac);
        }
        if (val.equals(inherit)) {
            if (expression.getCount() > 1) {
                throw new InvalidParamException("unrecognize", ac);
            }
            this.horizontal = inherit;
            this.vertical = inherit;
            expression.next();
            return;
        }
        if (val instanceof CssIdent && (index = this.IndexOfIdent((String)val.get())) != INVALID) {
            CssValue next = expression.getNextValue();
            if (next.equals(inherit)) {
                throw new InvalidParamException("unrecognize", ac);
            }
            expression.next();
            if (next == null) {
                this.getPercentageFromIdent(index, INVALID);
            } else if (next instanceof CssIdent) {
                int index2 = this.IndexOfIdent((String)next.get());
                if (index2 != INVALID) {
                    this.getPercentageFromIdent(index, index2);
                    expression.next();
                } else {
                    this.getPercentageFromIdent(index, INVALID);
                }
            }
        } else if (val instanceof CssLength || val instanceof CssPercentage || val instanceof CssNumber) {
            if (val instanceof CssNumber) {
                val = ((CssNumber)val).getLength();
            }
            this.horizontal = val;
            expression.next();
            val = expression.getValue();
            if (val.equals(inherit)) {
                throw new InvalidParamException("unrecognize", ac);
            }
            if (val instanceof CssLength || val instanceof CssPercentage || val instanceof CssNumber) {
                if (val instanceof CssNumber) {
                    val = ((CssNumber)val).getLength();
                }
                this.vertical = val;
                expression.next();
            } else if (val != null) {
                throw new InvalidParamException("value", expression.getValue(), this.getPropertyName(), ac);
            }
        } else {
            throw new InvalidParamException("value", expression.getValue(), this.getPropertyName(), ac);
        }
    }

    public CssBackgroundPositionMob(ApplContext ac, CssExpression expression) throws InvalidParamException {
        this(ac, expression, false);
    }

    public Object get() {
        return this.horizontal;
    }

    public String getPropertyName() {
        return "background-position";
    }

    public CssValue getHorizontalPosition() {
        return this.horizontal;
    }

    public CssValue getVerticalPosition() {
        return this.vertical;
    }

    public boolean isSoftlyInherited() {
        return this.horizontal == inherit;
    }

    public String toString() {
        if (this.horizontal == inherit) {
            return inherit.toString();
        }
        String ret = "";
        if (this.horizontal != null) {
            ret = ret + this.horizontal;
        }
        if (this.vertical != null) {
            if (!ret.equals("")) {
                ret = ret + " ";
            }
            ret = ret + this.vertical;
        }
        return ret;
    }

    private void getPercentageFromIdent(int first, int second) {
        this.horizontal = DefaultValue50;
        this.vertical = DefaultValue50;
        if (first == 3 || second == 3) {
            this.horizontal = DefaultValue0;
        }
        if (first == 4 || second == 4) {
            this.horizontal = DefaultValue100;
        }
        if (first == 0 || second == 0) {
            this.vertical = DefaultValue0;
        }
        if (first == 2 || second == 2) {
            this.vertical = DefaultValue100;
        }
    }

    public void addToStyle(ApplContext ac, CssStyle style) {
        CssBackgroundMob cssBackground = ((Css1Style)style).cssBackgroundMob;
        if (cssBackground.position != null) {
            style.addRedefinitionWarning(ac, this);
        }
        cssBackground.position = this;
    }

    public CssProperty getPropertyInStyle(CssStyle style, boolean resolve) {
        if (resolve) {
            return ((Css1Style)style).getBackgroundPositionMob();
        }
        return ((Css1Style)style).cssBackgroundMob.position;
    }

    public boolean equals(CssProperty property) {
        return property instanceof CssBackgroundPositionMob && this.horizontal.equals(((CssBackgroundPositionMob)property).horizontal) && this.vertical.equals(((CssBackgroundPositionMob)property).vertical);
    }

    public boolean isDefault() {
        return this.horizontal != null && this.vertical != null && this.horizontal.equals(DefaultValue0) && this.vertical.equals(DefaultValue0);
    }

    private int IndexOfIdent(String ident) throws InvalidParamException {
        int hash = ident.hashCode();
        for (int i = 0; i < POSITION.length; ++i) {
            if (hash_values[i] != hash) continue;
            return i;
        }
        return -1;
    }

    static {
        INVALID = -1;
        DefaultValue0 = new CssPercentage(0);
        DefaultValue50 = new CssPercentage(50);
        DefaultValue100 = new CssPercentage(100);
        hash_values = new int[POSITION.length];
        for (int i = 0; i < POSITION.length; ++i) {
            CssBackgroundPositionMob.hash_values[i] = POSITION[i].hashCode();
        }
    }
}

