/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.util;

import java.util.Hashtable;
import org.w3c.css.util.Tuple;

public class HTTPMessage {
    public static int H_CACHE_CONTROL = 0;
    public static int H_CONNECTION = 1;
    public static int H_PROXY_CONNECTION = 2;
    public static int H_DATE = 3;
    public static int H_PRAGMA = 4;
    public static int H_TRANSFER_ENCODING = 5;
    public static int H_UPGRADE = 6;
    public static int H_VIA = 7;
    public static int H_PROTOCOL = 8;
    public static int H_PROTOCOL_REQUEST = 9;
    public static int H_PROTOCOL_INFO = 10;
    public static int H_PROTOCOL_QUERY = 11;
    public static int H_SET_COOKIE = 12;
    public static int H_COOKIE = 13;
    public static int H_TRAILER = 14;
    public static int H_MAN_EXT = 15;
    public static int H_OPT_EXT = 16;
    public static int H_CMAN_EXT = 17;
    public static int H_COPT_EXT = 18;
    public static int MAX_HEADERS = 61;
    protected static Hashtable factory = new Hashtable(MAX_HEADERS);
    protected static String[] descriptors = new String[MAX_HEADERS];

    protected static final void registerHeader(int i, String name) {
        HTTPMessage.descriptors[i] = name;
        factory.put(name, new Tuple(name, i));
    }

    public static int getOffset(String name) {
        Tuple t = (Tuple)factory.get(name);
        return t == null ? -1 : t.getOffset();
    }

    public static String getName(int offset) {
        return descriptors[offset];
    }

    static {
        HTTPMessage.registerHeader(H_CACHE_CONTROL, "Cache-Control");
        HTTPMessage.registerHeader(H_CONNECTION, "Connection");
        HTTPMessage.registerHeader(H_PROXY_CONNECTION, "Proxy-Connection");
        HTTPMessage.registerHeader(H_DATE, "Date");
        HTTPMessage.registerHeader(H_PRAGMA, "Pragma");
        HTTPMessage.registerHeader(H_TRANSFER_ENCODING, "Transfer-Encoding");
        HTTPMessage.registerHeader(H_UPGRADE, "Upgrade");
        HTTPMessage.registerHeader(H_VIA, "Via");
        HTTPMessage.registerHeader(H_TRAILER, "Trailer");
        HTTPMessage.registerHeader(H_PROTOCOL, "Protocol");
        HTTPMessage.registerHeader(H_PROTOCOL_REQUEST, "Protocol-Request");
        HTTPMessage.registerHeader(H_PROTOCOL_QUERY, "Protocol-Query");
        HTTPMessage.registerHeader(H_PROTOCOL_INFO, "Protocol-Info");
        HTTPMessage.registerHeader(H_SET_COOKIE, "Set-Cookie");
        HTTPMessage.registerHeader(H_COOKIE, "Cookie");
        HTTPMessage.registerHeader(H_MAN_EXT, "Man");
        HTTPMessage.registerHeader(H_OPT_EXT, "Opt");
        HTTPMessage.registerHeader(H_CMAN_EXT, "C-Man");
        HTTPMessage.registerHeader(H_COPT_EXT, "C-Opt");
    }
}

