/*
 * Decompiled with CFR 0.152.
 */
package html.parser;

import html.parser.DTD;
import html.parser.Parser;
import html.parser.ParserException;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;

public class JmlParser
extends Parser {
    static final String defaultDTD = "html2-net";
    String dtdname;

    public JmlParser() throws ParserException {
        this(defaultDTD);
    }

    public JmlParser(String dtdn) throws ParserException {
        this.dtdname = dtdn;
        URL url = null;
        InputStream f = null;
        DTD.props = new Properties();
        try {
            url = JmlParser.class.getResource("Parser.properties");
            f = url.openStream();
            DTD.props.load(f);
        }
        catch (Exception e) {
            String msg = "Failed to load properties (url=" + url + ")" + "(msg=" + e.getMessage() + ")";
            throw new ParserException(msg);
        }
        finally {
            try {
                f.close();
            }
            catch (Exception e) {}
        }
        DTD.props = new Properties(DTD.props);
        try {
            this.dtd = DTD.getDTD(this.dtdname);
        }
        catch (IOException x) {
            throw new ParserException("Failed to load dtd...");
        }
    }

    public void parseFile(String filename) throws ParserException {
        try {
            InputStream in = filename.indexOf(58) > 0 ? new URL(null, filename).openStream() : new BufferedInputStream(new FileInputStream(filename));
            try {
                long tm = System.currentTimeMillis();
                this.parse(in, this.dtd);
                tm = System.currentTimeMillis() - tm;
                System.out.println("[Parsed " + filename + " in " + tm + "ms]");
            }
            catch (Exception e) {
                throw new ParserException("Uncaught error while parsing");
            }
        }
        catch (Exception e) {
            throw new ParserException("Failed to open: " + filename);
        }
    }
}

