/*
 * Decompiled with CFR 0.152.
 */
package html.parser;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Hashtable;

public class PublicMapping {
    public static final boolean debug = false;
    String dir;
    Hashtable tab = new Hashtable();

    public PublicMapping(String dir) throws FileNotFoundException, IOException {
        this.dir = dir;
        URL url = PublicMapping.class.getResource(dir + "/public.map");
        this.load(url.openStream());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(InputStream in) throws IOException {
        BufferedReader data = null;
        try {
            data = new BufferedReader(new InputStreamReader(in));
            String ln = data.readLine();
            while (ln != null) {
                if (ln.startsWith("PUBLIC")) {
                    int j;
                    int i;
                    int len = ln.length();
                    for (i = 6; i < len && ln.charAt(i) != '\"'; ++i) {
                    }
                    for (j = ++i; j < len && ln.charAt(j) != '\"'; ++j) {
                    }
                    String id = ln.substring(i, j);
                    for (i = ++j; i < len && (ln.charAt(i) == ' ' || ln.charAt(i) == '\t'); ++i) {
                    }
                    for (j = i + 1; j < len && ln.charAt(j) != ' ' && ln.charAt(j) != '\t'; ++j) {
                    }
                    String where = ln.substring(i, j);
                    this.put(id, where);
                }
                ln = data.readLine();
            }
        }
        finally {
            try {
                data.close();
            }
            catch (Exception exception) {}
        }
    }

    public void put(String id, String where) {
        this.tab.put(id, where);
        if (where.endsWith(".dtd")) {
            this.tab.put(where.substring(where.lastIndexOf(File.separatorChar) + 1, where.length() - 4), where);
        }
    }

    public InputStream get(String id) throws FileNotFoundException {
        String name = this.dir + "/" + this.tab.get(id);
        try {
            URL url = this.getClass().getResource(name);
            return new BufferedInputStream(url.openStream());
        }
        catch (Exception x) {
            throw new FileNotFoundException(name);
        }
    }
}

