/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.values;

import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.util.Util;
import org.w3c.css.values.CssValue;

public class CssResolution
extends CssValue {
    private Float value = defaultValue;
    private String unit;
    private static Float defaultValue = new Float(0.0f);

    public void set(String s, ApplContext ac) throws InvalidParamException {
        s = s.toLowerCase();
        int length = s.length();
        String unit = "";
        if (s.toUpperCase().indexOf("DPI") != -1) {
            unit = s.substring(length - 3, length);
            this.value = new Float(s.substring(0, length - 3));
            if (unit.toUpperCase().equals("DPI")) {
                this.unit = unit;
            }
            return;
        }
        if (s.toUpperCase().indexOf("DPCM") != -1) {
            unit = s.substring(length - 4, length);
            this.value = new Float(s.substring(0, length - 4));
            if (unit.toUpperCase().equals("DPCM")) {
                this.unit = unit;
            }
            return;
        }
        if (!ac.getCssVersion().equals("css3")) {
            throw new InvalidParamException("unit", unit, ac);
        }
        throw new InvalidParamException("unit", unit, ac);
    }

    public Object get() {
        return this.value;
    }

    public String getUnit() {
        return this.unit;
    }

    public String toString() {
        if (this.value.floatValue() != 0.0f) {
            return Util.displayFloat(this.value) + this.getUnit();
        }
        return Util.displayFloat(this.value);
    }

    public boolean equals(Object value) {
        return value instanceof CssResolution && this.value.equals(((CssResolution)value).value) && this.unit == ((CssResolution)value).unit;
    }
}

