/*-*-	Mode:C++; c-basic-offset:8; tab-width:8; indent-tabs-mode:t -*- */
/*
 * Copyright (c) 1997 by the University of Southern California
 * All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation in source and binary forms for non-commercial purposes
 * and without fee is hereby granted, provided that the above copyright
 * notice appear in all copies and that both the copyright notice and
 * this permission notice appear in supporting documentation. and that
 * any documentation, advertising materials, and other materials related
 * to such distribution and use acknowledge that the software was
 * developed by the University of Southern California, Information
 * Sciences Institute.  The name of the University may not be used to
 * endorse or promote products derived from this software without
 * specific prior written permission.
 *
 * THE UNIVERSITY OF SOUTHERN CALIFORNIA makes no representations about
 * the suitability of this software for any purpose.  THIS SOFTWARE IS
 * PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 *
 * Other copyrights might apply to parts of this software and are so
 * noted when applicable.
 *
 *  sgb2hierns.c -- converter from sgb format to ns format with hierarchical addressing. 
 *
 *  usage :  sgb2hierns <sgbgraph.file> {optional <topo.file -used for scenario
 *  generation>}
 *
 *  Based on sgb2ns converter
 *  Maintainer: Padma Haldar (haldar@isi.edu)
 */

#include <stdio.h>
#include <strings.h>
#include "gb_graph.h"
#include "gb_save.h"
#include "geog.h"

#define TRUE   1
#define FALSE  0
#define MED    256
#define LARGE  4096
#define HUGE   655536


main(argc,argv)
    int argc;
    char *argv[];
{

    int i, 
	j, 
	nlink, 
	k, 
	jj, 
	domain = 0,
	cluster = 0,
	p=0,
	/* q=0, */
	q_b=0,
	r=0,
	n=0,
	    l=0;
    Vertex *v;  
    Arc *a;
    Graph *g;
    FILE    *fopen(), 
	    *fout;
    char m[420],
	    tempstr[10],
	    node_per_cluster[HUGE],
	    name[40];
    char *temp,
	    *index;
    char *address[HUGE];
    int q[HUGE];
    FILE    *output = NULL;
    int     stubsize[LARGE],
	    stubnode[LARGE];
    char    transits[LARGE]; 
    
    

    if (argc < 3) {
	    /* for the purpose of scenario generator, need to return a list of transits
	       & stubs and num of nodes in each - hence the optional third arg topofile */
	    printf("sgb2hierns <sgfile> <outfile> ?<topofile>?\n\n");
	    return;
    }
  
    fout = fopen(argv[2],"w");
    if (argc > 3) {
	    printf("More than 3 arguments: generate topoinfo %s\n", argv[3]);
	    output = fopen(argv[3], "w"); 
    }
    
    g = restore_graph(argv[1]);
    if (g == NULL) {
	    printf("%s does not contain a correct SGB graph\n",argv[1]);
	    return;
    }

    fprintf(fout,"# Generated by sgb2hier-ns,sgb2hier-ns generated from sgb2ns\n");
    fprintf(fout,"# sgb2ns adapted from sgb2alt by Polly Huang\n");
    fprintf(fout,"# GRAPH (#nodes #edges id uu vv ww xx yy zz):\n");
    fprintf(fout,"# %d %d %s ",g->n, g->m, g->id);
    if (g->util_types[8] == 'I') fprintf(fout,"%ld ",g->uu.I);
    if (g->util_types[9] == 'I') fprintf(fout,"%ld ",g->vv.I);
    if (g->util_types[10] == 'I') fprintf(fout,"%ld ",g->ww.I);
    if (g->util_types[11] == 'I') fprintf(fout,"%ld ",g->xx.I);
    if (g->util_types[12] == 'I') fprintf(fout,"%ld ",g->yy.I);
    if (g->util_types[13] == 'I') fprintf(fout,"%ld ",g->zz.I);
    fprintf(fout,"\n\n");
  
    fprintf(fout, "#Creating hierarchical topology from transit-stub graph:\n\n");
    
    q[p] = 0;
    /* generating hierarchical topology from transit-stub*/
    for (v = g->vertices,i=0; i < g->n; i++,v++) {
	strcpy(name, v->name);
	temp = name;
	temp += 2;
	index = strstr(temp, ".");
	temp[index - temp] = '\0';
	if ( p == atoi(temp)) { /* in same domain as before */
	  
	    if (name[0] == 'T') { /* for transits -> single node domains */
		r = 0;
		address[i] = (char *)malloc(strlen(v->name));
		sprintf(address[i],"%d.%d.%d",p,q[p],r);
		strcat(node_per_cluster, "1 ");

		sprintf(tempstr, "%d ", i); 
 		strcat(transits, tempstr); 

		q[p] = q[p] + 1;
	    }
	    else if (name[0] == 'S') { /* for stubs */
		strcpy(name, v->name);
		temp = name;
		while(temp){
		    index = strstr(temp, ".");
		    if (index != NULL)
			    temp = index + 1;
		    else{
			    if (atoi(temp) == 0) {
				    /* counting stub nodes for scenario gen */
				    stubnode[l] = i;
				    l++;
				    
				    if ( q_b != 0) {
					    sprintf(tempstr, "%d ", r + 1);
					    strcat(node_per_cluster, tempstr);
					    
					    stubsize[n] = r + 1;
					    n++;
				    } 
				    r = 0;
				    address[i] = (char *)malloc(strlen(v->name));
				    sprintf(address[i],"%d.%d.%d", p, q[p], r);
				    q_b = q[p];
				    q[p] = q[p] + 1;
			    }
			    else {
				    r++;
				    address[i] = (char *)malloc(strlen(v->name));
				    sprintf(address[i],"%d.%d.%d", p, q_b, r);
				    
			    }
			    break;
		    }
		}
	    }
	}
	else {
	    sprintf(tempstr, "%d ", r + 1);
	    strcat(node_per_cluster, tempstr);

	    stubsize[n] = r + 1;
	    n++; 

	    p = atoi(temp);
	    q[p] = 0;
	    q_b = 0;
	    r = 0;
	    address[i] = (char *)malloc(strlen(v->name));
	    sprintf(address[i],"%d.%d.%d",p,q[p],r);
	    strcat(node_per_cluster, "1 ");

	    sprintf(tempstr, "%d ", i); 
 	    strcat(transits, tempstr); 
	    
	    q[p] = q[p] + 1;
	}
    }
    domain = p + 1;
    /* cluster = q;  */  /* assuming all domains have equal # of clusters */
    /* for domains having diff no of clusters , use q[domain num]*/
    
    sprintf(tempstr, "%d ", r + 1);
    strcat(node_per_cluster, tempstr);
    stubsize[n] = r + 1;

    /* writing topology (transit/stub) details into topo outfile for scenario gen.:*/
    if (output != NULL) {
	    fprintf(output, "domains %d\n", domain);
	    fprintf(output, "transits %s\n", transits);
	    fprintf(output, "total-stubs %d\n", n+1);
	    fprintf(output, "stubs ");
	    for(i = 0; i < l; i++) 
		    fprintf(output, "%d ", stubnode[i]);
	    fprintf(output, "\nnodes/stub ");
	    for(i = 0; i <= n; i++) 
		    fprintf(output, "%d ", stubsize[i]);
	    fprintf(output, "\n\nEnd of topology file. \n");
	    fclose(output);
    } 
    
    fprintf(fout, "proc create-hier-topology {nsns node linkBW} {\n");
    fprintf(fout, "\tupvar $node n\n"); 
    fprintf(fout, "\tupvar $nsns ns\n\n"); 
/*     fprintf(fout, "\tglobal ns n\n\n"); */
  
    fprintf(fout,"\tset verbose 1\n\n");

    /* nodes */
    fprintf(fout, "\tif {$verbose} { \n");
    fprintf(fout, "\t\tputs \"Creating hierarchical nodes..\" \n\n");
    fprintf(fout, "\t}\n");
    fprintf(fout, "\tset i 0 \n");
    fprintf(fout, "\tforeach a { \n\n");
    
    for (i = 0; i < g->n; i++) {
	    fprintf(fout, "\t\t%s\n",address[i]);
	    /* fprintf(fout, "set n(%d) [$ns node %s]\n", i, address[i]); */
/* 	    if ((i % 100) == 0) { */
/* 		    fprintf(fout,  */
/* 		    "\tif {$verbose} { puts -nonewline \"%d...\"; flush stdout }\n",i);	 */
/* 	} */
    }
    fprintf(fout,"\t} { \n");
    fprintf(fout,"\t\tset n($i) [$ns node $a]\n");
    fprintf(fout,"\t\tincr i \n");
    fprintf(fout,"\t\tif {[expr $i %% 100] == 0} {\n");
    fprintf(fout,"\t\t\tputs \"creating node $i...\" \n \t\t} \n\t}");
    
    
    fprintf(fout,"\n\n");
    fprintf(fout,"# Topology information :\n");
    fprintf(fout, "\tlappend domain %d\n", domain);
    fprintf(fout, "\tAddrParams set domain_num_ $domain\n");
    fprintf(fout, "\tlappend cluster ");
    for (i = 0; i < domain; i++) {
	/* printf("q[%d] = %d\n",i,q[i]); */
	fprintf(fout, "%d ",q[i]);
    }
    fprintf(fout, "\n");
    fprintf(fout, "\tAddrParams set cluster_num_ $cluster\n");
    fprintf(fout, "\tlappend eilastlevel %s\n",node_per_cluster);
    fprintf(fout, "\tAddrParams set nodes_num_ $eilastlevel\n");
    fprintf(fout,"\n\n");

    /* edges */
    fprintf(fout, "\t# EDGES (from-node to-node length a b):\n");
    nlink = 0;
    fprintf(fout, "\tif {$verbose} { \n");
    fprintf(fout, "\t\tputs \"Creating links 0...\"\n");
    fprintf(fout, "\t\tflush stdout \n");
    fprintf(fout, "\t}\n");
    fprintf(fout, "\tset i 0 \n");
    fprintf(fout, "\tforeach t { \n");
    
    for (v = g->vertices,i=0; i < g->n; i++,v++) 
	for (a = v->arcs; a != NULL; a = a->next) {
	    j = a->tip - g->vertices;
	    if (j > i) {
		    fprintf(fout, "\t\t{%d %d %dms} \n",i, j, 10 * a->len);
		    
		    /*   fprintf(fout,  */
/* 			    "\t$ns duplex-link-of-interfaces $n(%d) $n(%d) $linkBW %dms DropTail\n", i, j, 10 * a->len); */
		    nlink++;
		    /* if ((nlink % 10) == 0) { */
/* 			    fprintf(fout, */
/* 				    "\tif {$verbose} { puts -nonewline \"%d...\"; flush stdout }\n",  */
/* 				    nlink); */
/* 		    } */
	    }
	    
	}
    fprintf(fout, "\t} { \n");
    fprintf(fout, "\t$ns duplex-link-of-interfaces $n([lindex $t 0]) $n([lindex $t 1]) $linkBW [lindex $t 2] DropTail \n");
    fprintf(fout, "\tincr i \n");
    fprintf(fout, "\tif {[expr $i %% 100] == 0} { \n");
    fprintf(fout, "\t\tputs \"creating link $i...\" \n");
    fprintf(fout, "\t} \n } \n");
/*     fprintf(fout, "\n\tif {$verbose} { \n"); */
/*     fprintf(fout, "\t\tputs -nonewline \"%d...\"\n", nlink); */
/*     fprintf(fout, "\t\tflush stdout\n"); */
/*     fprintf(fout, "\t\tputs \"starting\"\n"); */
/*     fprintf(fout, "\t}\n"); */
	
    /* srm members. join-group will be performed by Agent/SRM::start */
    /* return the number of nodes in this topology */
    fprintf(fout, "\treturn %d\n", g->n);
    fprintf(fout, "}\n");
	
    for (i=0; i < g->n; i++)
	if (address[i] != NULL)
	    free(address[i]);
    fprintf(fout,"# end of hier topology generation\n");
    fclose(fout);
    
	
}   
	      
