/*
 * Copyright (c) 1983 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *	  notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *	  notice, this list of conditions and the following disclaimer in the
 *	  documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *	  must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *	  may be used to endorse or promote products derived from this software
 *	  without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.	IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#if defined(LIBC_SCCS) && !defined(lint)
/*static char *sccsid = "from: @(#)getnetent.c	5.8 (Berkeley) 2/24/91";*/
static char *rcsid = "getnetent.c,v 1.4 1995/01/06 10:46:08 ghudson Exp";
#endif /* LIBC_SCCS and not lint */

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <stdio.h>
#include <string.h>
#include "net_internal.h"

void setnetent(int keep_open)
{
	struct net_data *data = _net_init();
	
	if (data) {
		data->keep_netfp_open |= keep_open;
		setnetent_r(&data->netfp);
	}
}

void endnetent()
{
	struct net_data *data = _net_init();
	
	if (data) {
		data->keep_netfp_open = 0;
		endnetent_r(&data->netfp);
	}
}

struct netent *getnetent()
{
	struct net_data *data = _net_init();
	
	return (data) ? getnetent_r(&data->net_answer, &data->netfp) : NULL;
}

void setnetent_r(FILE **fp)
{
	if (*fp == NULL)
		*fp = fopen(_PATH_NETWORKS, "r" );
	else
		rewind(*fp);
}

void endnetent_r(FILE **fp)
{
	fclose(*fp);
	*fp = NULL;
}

struct netent *getnetent_r(struct netent_answer *result, FILE **fp)
{
	char *p, *cp, **q;
	
	if (*fp == NULL && (*fp = fopen(_PATH_NETWORKS, "r" )) == NULL)
		return NULL;
	
  again:
	p = fgets(result->line, BUFSIZ, *fp);
	if (p == NULL)
		return NULL;
	if (*p == '#')
		goto again;
	cp = strpbrk(p, "#\n");
	if (cp == NULL)
		goto again;
	*cp = '\0';
	result->net.n_name = p;
	cp = strpbrk(p, " \t");
	if (cp == NULL)
		goto again;
	*cp++ = '\0';
	while (*cp == ' ' || *cp == '\t')
		cp++;
	p = strpbrk(cp, " \t");
	if (p != NULL)
		*p++ = '\0';
	result->net.n_net = inet_network(cp);
	result->net.n_addrtype = AF_INET;
	q = result->net.n_aliases = result->net_aliases;
	if (p != NULL) 
		cp = p;
	while (cp && *cp) {
		if (*cp == ' ' || *cp == '\t') {
			cp++;
			continue;
		}
		if (q < &result->net_aliases[__NETDB_MAXALIASES - 1])
			*q++ = cp;
		cp = strpbrk(cp, " \t");
		if (cp != NULL)
			*cp++ = '\0';
	}
	*q = NULL;
	
	return (&result->net);
}
