/*
 * Copyright (c) 1983 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *	  notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *	  notice, this list of conditions and the following disclaimer in the
 *	  documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *	  must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *	  may be used to endorse or promote products derived from this software
 *	  without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.	IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#if defined(LIBC_SCCS) && !defined(lint)
/*static char *sccsid = "from: @(#)getservent.c	5.9 (Berkeley) 2/24/91";*/
static char *rcsid = "getservent.c,v 1.3 1995/01/06 10:46:24 ghudson Exp";
#endif /* LIBC_SCCS and not lint */

#include <sys/types.h>
#include <sys/socket.h>
#include <netdb.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "serv_internal.h"

void setservent(int keep_open)
{
	struct serv_data *data = _serv_init();

	if (data) {
		data->keep_servfp_open |= keep_open;
		setservent_r(&data->servfp);
	}
}

void endservent()
{
	struct serv_data *data = _serv_init();

	if (data) {
		data->keep_servfp_open = 0;
		endservent_r(&data->servfp);
	}
}

struct servent *getservent()
{
	struct serv_data *data = _serv_init();

	return (data) ? getservent_r(&data->serv_answer, &data->servfp) : NULL;
}

void setservent_r(FILE **fp)
{
	if (*fp == NULL)
		*fp = fopen(_PATH_SERVICES, "r");
	else
		rewind(*fp);
}

void endservent_r(FILE **fp)
{
	fclose(*fp);
	*fp = NULL;
}

struct servent *getservent_r(struct servent_answer *result, FILE **fp)
{
	char *p;
	char *cp, **q;
	
	if (*fp == NULL && (*fp = fopen(_PATH_SERVICES, "r")) == NULL)
		return NULL;
  again:
	if ((p = fgets(result->line, BUFSIZ, *fp)) == NULL)
		return NULL;
	if (*p == '#')
		goto again;
	cp = strpbrk(p, "#\n");
	if (cp == NULL)
		goto again;
	*cp = '\0';
	result->serv.s_name = p;
	p = strpbrk(p, " \t");
	if (p == NULL)
		goto again;
	*p++ = '\0';
	while (*p == ' ' || *p == '\t')
		p++;
	cp = strpbrk(p, ",/");
	if (cp == NULL)
		goto again;
	*cp++ = '\0';
	result->serv.s_port = htons((u_short)atoi(p));
	result->serv.s_proto = cp;
	q = result->serv.s_aliases = result->serv_aliases;
	cp = strpbrk(cp, " \t");
	if (cp != NULL)
		*cp++ = '\0';
	while (cp && *cp) {
		if (*cp == ' ' || *cp == '\t') {
			cp++;
			continue;
		}
		if (q < &result->serv_aliases[__NETDB_MAXALIASES - 1])
			*q++ = cp;
		cp = strpbrk(cp, " \t");
		if (cp != NULL)
			*cp++ = '\0';
	}
	*q = NULL;
	return &result->serv;
}

