/* main.cc: Main loop of TNS. */

#include "threads.h"

#include "Server.h"
#include "Connection.h"

static void initialize();
static void main_loop();
static void cleanup();
static void *handle_connection(void *conn);

int main(int argc, char **argv)
{
    initialize();
    main_loop();
    cleanup();
    return 0;
}

static void initialize()
{
    /* Required for libpthreads, but NOT required by POSIX threads. */
    pthread_init();
}

static void main_loop()
{
    Server server(4119);
    Connection *conn;

    while (1) {
	conn = server.accept();
	start_thread(handle_connection, conn);
    }
}

static void cleanup()
{
}

static void *handle_connection(void *conn)
{
    ((Connection *) conn)->run();
    return NULL;
}

