#include <stdio.h>
#include "sock_lib.h"

main(int argc, char **argv)
{
  int count = 0, test_count;
  char local_hostname[256];

  setbuf(stdout, NULL);
  test_count = 100;
  if (gethostname(local_hostname, sizeof(local_hostname)) < 0) {
    perror("gethostname");
    exit(1);
  }
  while (test_count-- >= 0) {
    int s, nread;
    char buf[128];

    printf("*** start %d ***\n\n", ++count);
    s = socket_to_service(local_hostname, "daytime", "tcp");
    if (s < 0) {
      printf("socket_to_service => %d\n", s);
      exit(1);
    }
    while ((nread = read(s, buf, sizeof(buf))) > 0)
      write(1, buf, nread);
    close(s);
    printf("*** end %d: nread=%d ***\n\n", count, nread);
  }
}
